/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.executeengine.core;

import bexee.core.MissingActivityException;
import bexee.core.ProcessContext;
import bexee.core.ProcessController;
import bexee.core.ProcessControllerImpl;
import bexee.core.ProcessInstance;
import bexee.event.Event;
import bexee.model.activity.Activity;
import bexee.model.activity.Assign;
import bexee.model.activity.Invoke;
import bexee.model.activity.Switch;
import bexee.model.elements.BpelCase;
import bexee.model.elements.Copy;
import bexee.model.elements.From;
import bexee.model.elements.PartnerLinks;
import bexee.model.elements.To;
import bexee.model.elements.Variable;
import bexee.model.elements.Variables;
import bexee.model.process.BPELProcess;
import bexee.model.process.Process;
import com.supermap.geoprocessor.common.ModelFileManager;
import com.supermap.geoprocessor.core.MethodRunner;
import com.supermap.geoprocessor.core.MethodRunnerPython;
import com.supermap.geoprocessor.core.RunningContext;
import com.supermap.geoprocessor.executeengine.EngineManager;
import com.supermap.geoprocessor.executeengine.OutInputManager;
import com.supermap.geoprocessor.executeengine.activity.GeoActivity;
import com.supermap.geoprocessor.executeengine.activity.GeoInvoke;
import com.supermap.geoprocessor.executeengine.core.GeoProcessController;
import com.supermap.geoprocessor.executeengine.core.GeoProcessInstance;
import com.supermap.geoprocessor.executeengine.elements.GeoVariable;
import com.supermap.geoprocessor.executeengine.elements.Input;
import com.supermap.geoprocessor.executeengine.elements.impl.GeoVariableImpl;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeoProcessControllerImpl
extends ProcessControllerImpl
implements GeoProcessController {
    private static Log log = LogFactory.getLog(ProcessControllerImpl.class);
    private static String fileNamespace = "http://supermap.com/supermapmodeler6r/file";
    private static String classNamespace = "http://supermap.com/supermapmodeler6r/class";
    private static String pyfileNamespace = "http://supermap.com/supermapmodeler6r/pyfile";

    public void process(Process process, ProcessInstance processInstance) throws Exception {
        PartnerLinks partnerLinks;
        log.info((Object)"Processing a Process");
        GeoProcessInstance geoProcessInstance = (GeoProcessInstance)processInstance;
        Variables variables = process.getVariables();
        if (variables != null) {
            variables.accept((ProcessController)this, processInstance);
        }
        if ((partnerLinks = process.getPartnerLinks()) != null) {
            partnerLinks.accept((ProcessController)this, processInstance);
        }
        Activity activity = process.getActivity();
        RunningContext runningContext = geoProcessInstance.getRunningContext();
        List<GeoActivity> list = ((GeoActivity)activity).getInvokeActivities();
        for (int i = 0; i < list.size(); ++i) {
            GeoInvoke geoInvoke = (GeoInvoke)((Object)list.get(i));
            runningContext.newRunningContext(geoInvoke.getID());
        }
        geoProcessInstance.getRunningContext().addTask();
        if (activity == null) {
            throw new MissingActivityException();
        }
        activity.accept((ProcessController)this, processInstance);
        runningContext.updateProcessStatus(runningContext.getStatus());
    }

    public void process(Switch switch_, ProcessInstance processInstance) throws Exception {
        List list = switch_.getCases();
        for (BpelCase bpelCase : list) {
            String string = bpelCase.getBooleanExpression().getBooleanExpression();
            if (!bpelCase.getBooleanExpression().evaluate()) continue;
            bpelCase.getCaseActivity().accept((ProcessController)this, processInstance);
            return;
        }
        Activity activity = switch_.getOtherwise();
        if (activity != null) {
            activity.accept((ProcessController)this, processInstance);
        }
    }

    public void process(Invoke invoke, ProcessInstance processInstance) throws Exception {
        this.slog((Activity)invoke);
        GeoInvoke geoInvoke = (GeoInvoke)invoke;
        GeoProcessInstance geoProcessInstance = (GeoProcessInstance)processInstance;
        ProcessContext processContext = processInstance.getContext();
        BPELProcess bPELProcess = processInstance.getProcess();
        Event event = processContext.getEvent((Activity)invoke);
        if (event == null) {
            Object object;
            QName qName;
            event = new Event((Activity)invoke);
            GeoVariable geoVariable = (GeoVariable)invoke.getInputVariable();
            Object[] objectArray = null;
            RunningContext runningContext = geoProcessInstance.getRunningContext().getChildren().get(Integer.toString(geoInvoke.getID()));
            if (geoVariable != null) {
                objectArray = geoVariable.toArray();
            }
            if ((qName = invoke.getPartnerLink().getPartnerLinkType()).getNamespaceURI().equalsIgnoreCase(fileNamespace)) {
                object = ModelFileManager.getModelFilePath(qName.getLocalPart());
                runningContext.setOutInput(geoVariable.toXml());
                boolean bl = EngineManager.internalExecuteFromURL((URL)object, runningContext.getJobID(), runningContext);
                if (!bl) {
                    log.error((Object)("Processing file:" + object.getFile() + "  execute failed"));
                }
            } else if (qName.getNamespaceURI().equalsIgnoreCase(classNamespace) || qName.getNamespaceURI().equalsIgnoreCase("")) {
                object = new MethodRunner(qName.getLocalPart(), "run", objectArray, runningContext, geoInvoke.getCaption());
                boolean bl = object.exectue();
                if (!bl) {
                    log.error((Object)("Processing " + invoke.getClass().getName() + " name: " + invoke.getName() + " execute failed"));
                }
            } else if (qName.getNamespaceURI().equalsIgnoreCase(pyfileNamespace)) {
                object = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    object[i] = objectArray[i].toString();
                }
                MethodRunnerPython methodRunnerPython = new MethodRunnerPython(qName.getLocalPart(), "run", (String[])object, runningContext, geoInvoke.getCaption());
                boolean bl = methodRunnerPython.exectue();
                if (!bl) {
                    log.error((Object)("Processing " + invoke.getClass().getName() + " name: " + invoke.getName() + " execute failed"));
                }
            } else {
                log.error((Object)("PartLinkType:" + qName.toString() + " is not supported"));
            }
            object = invoke.getOutputVariable();
            processContext.addEvent(event);
        }
    }

    private void slog(Activity activity) {
        if (activity != null) {
            log.info((Object)("Processing " + activity.getClass().getName() + " name: " + activity.getName()));
        } else {
            log.info((Object)"Processing null activity");
        }
    }

    public void process(Variables variables, ProcessInstance processInstance) throws Exception {
        log.info((Object)"Processing Variables");
        GeoProcessInstance geoProcessInstance = (GeoProcessInstance)processInstance;
        List list = variables.getVariables();
        for (Object object : list) {
            object.accept((ProcessController)this, processInstance);
        }
        String string = geoProcessInstance.getRunningContext().getOutInput();
        if (string != null) {
            Object object;
            object = new OutInputManager(string);
            ((OutInputManager)object).Load(geoProcessInstance.getContext());
        }
    }

    public void process(Variable variable, ProcessInstance processInstance) {
        log.info((Object)("Processing a Variable: " + variable.getName()));
        LinkedHashMap<String, Input> linkedHashMap = new LinkedHashMap<String, Input>();
        GeoVariableImpl geoVariableImpl = (GeoVariableImpl)variable;
        Vector<Input> vector = geoVariableImpl.getInputs();
        for (int i = 0; i < vector.size(); ++i) {
            linkedHashMap.put(vector.get(i).getName(), vector.get(i));
        }
        processInstance.getContext().setVariable(variable, linkedHashMap);
    }

    public void process(Assign assign, ProcessInstance processInstance) throws Exception {
        this.slog((Activity)assign);
        BPELProcess bPELProcess = processInstance.getProcess();
        ProcessContext processContext = processInstance.getContext();
        Event event = processContext.getEvent((Activity)assign);
        if (event == null) {
            event = new Event((Activity)assign);
            Copy copy = assign.getCopy();
            From from = copy.getFrom();
            Variable variable = from.getVariable();
            String string = from.getPart();
            To to = copy.getTo();
            Variable variable2 = to.getVariable();
            String string2 = to.getPart();
            Object object = processContext.getVariablePart(variable, string);
            String string3 = "";
            if (assign.getName() != null && assign.getName().indexOf("Response") != -1) {
                Set set = processContext.getVariablesIdentifiers();
                for (Variable variable3 : set) {
                    Collection collection = processContext.getVariable(variable3).values();
                    for (Object v : collection) {
                        if (v == null) continue;
                        string3 = string3 + "} {" + v.toString();
                    }
                }
                object = string3;
            }
            processContext.setVariablePart(variable2, string2, ((Input)object).getObjValue());
            processContext.addEvent(event);
        }
    }

    public void process(Input input, ProcessInstance processInstance) throws Exception {
        log.info((Object)("Processing a Input: " + input.getCaption()));
    }
}

