/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.LinkItemNative;
import com.supermap.data.Toolkit;

public class LinkItem
extends InternalHandleDisposable {
    private DatasourceConnectionInfo _$3 = null;

    public LinkItem() {
        this.setHandle(LinkItemNative.jni_New(), true);
        this.reset();
    }

    LinkItem(long l) {
        this.setHandle(l, false);
    }

    LinkItem(LinkItem linkItem) {
        if (linkItem == null) {
            String string = InternalResource.loadString("linkItem", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (linkItem.getHandle() == 0L) {
            String string = InternalResource.loadString("linkItem", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = LinkItemNative.jni_Clone(linkItem.getHandle());
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(linkItem);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return LinkItemNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        LinkItemNative.jni_SetName(this.getHandle(), string);
    }

    public String getForeignTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return LinkItemNative.jni_GetForeignTable(this.getHandle());
    }

    public void setForeignTable(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        LinkItemNative.jni_SetForeignTable(this.getHandle(), string);
    }

    public DatasourceConnectionInfo getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null) {
            long l = LinkItemNative.jni_GetConnectionInfo(this.getHandle());
            this._$3 = new DatasourceConnectionInfo(l);
        }
        return this._$3;
    }

    public void setConnectionInfo(DatasourceConnectionInfo datasourceConnectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasourceConnectionInfo == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasourceConnectionInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        LinkItemNative.jni_SetConnectionInfo(this.getConnectionInfo().getHandle(), datasourceConnectionInfo.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(datasourceConnectionInfo);
    }

    public String getLinkFilter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return LinkItemNative.jni_GetLinkFilter(this.getHandle());
    }

    public void setLinkFilter(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        LinkItemNative.jni_SetLinkFilter(this.getHandle(), string);
    }

    public String[] getLinkFields() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = LinkItemNative.jni_GetLinkFields(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setLinkFields(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (stringArray != null) {
            string = Toolkit.joinString(stringArray, ";");
        }
        LinkItemNative.jni_SetLinkFields(this.getHandle(), string);
    }

    public String[] getPrimaryKeys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = LinkItemNative.jni_GetPrimaryKeys(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setPrimaryKeys(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = "";
        if (stringArray != null) {
            string = Toolkit.joinString(stringArray, ";");
        }
        LinkItemNative.jni_SetPrimaryKeys(this.getHandle(), string);
    }

    public String[] getForeignKeys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = LinkItemNative.jni_GetForeignKeys(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setForeignKeys(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (stringArray == null) {
            LinkItemNative.jni_SetForeignKeys(this.getHandle(), "");
        } else {
            String string = Toolkit.joinString(stringArray, ";");
            LinkItemNative.jni_SetForeignKeys(this.getHandle(), string);
        }
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            LinkItemNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name = ");
        stringBuffer.append(this.getName());
        stringBuffer.append(",ForeignTable = ");
        stringBuffer.append(this.getForeignTable());
        stringBuffer.append(",ConnectionInfo = ");
        stringBuffer.append(this.getConnectionInfo().toString());
        stringBuffer.append(",LinkFilter = ");
        stringBuffer.append(this.getLinkFilter());
        stringBuffer.append(",LinkFields = {");
        String[] stringArray = this.getLinkFields();
        int n = stringArray.length;
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                stringBuffer.append("\"");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("\",");
            }
            stringBuffer.append("\"");
            stringBuffer.append(stringArray[n - 1]);
            stringBuffer.append("\"");
        }
        stringBuffer.append("},PrimaryKeys = {");
        String[] stringArray2 = this.getPrimaryKeys();
        int n2 = stringArray2.length;
        if (n2 > 0) {
            for (int i = 0; i < n2 - 1; ++i) {
                stringBuffer.append("\"");
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append("\",");
            }
            stringBuffer.append("\"");
            stringBuffer.append(stringArray2[n2 - 1]);
            stringBuffer.append("\"");
        }
        stringBuffer.append("},ForeignKeys = {");
        String[] stringArray3 = this.getForeignKeys();
        int n3 = stringArray3.length;
        if (n3 > 0) {
            for (int i = 0; i < n3 - 1; ++i) {
                stringBuffer.append("\"");
                stringBuffer.append(stringArray3[i]);
                stringBuffer.append("\",");
            }
            stringBuffer.append("\"");
            stringBuffer.append(stringArray3[n3 - 1]);
            stringBuffer.append("\"");
        }
        stringBuffer.append("}}\n");
        return stringBuffer.toString();
    }

    protected void clearHandle() {
        if (this._$3 != null) {
            this._$3.clearHandle();
            this._$3 = null;
        }
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            LinkItemNative.jni_Reset(this.getHandle());
            this.getConnectionInfo().reset();
        }
    }

    protected void refreshHandle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }
}

