/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoRegion3D
extends Geometry3D {
    private ArrayList<Point3Ds> _$8;

    public GeoRegion3D() {
        super.setHandle(GeoRegion3DNative.jni_New(), true);
        this._$8 = new ArrayList();
    }

    public GeoRegion3D(Point3Ds point3Ds) {
        this();
        this.addPart(point3Ds);
    }

    public GeoRegion3D(GeoRegion3D geoRegion3D) {
        if (geoRegion3D == null) {
            String string = InternalResource.loadString("region3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion3D.getHandle() == 0L) {
            String string = InternalResource.loadString("region3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegion3DNative.jni_Clone(geoRegion3D.getHandle());
        super.setHandle(l, true);
        this._$8 = new ArrayList();
        for (int i = 0; i < geoRegion3D.getPartsList().size(); ++i) {
            Point3Ds point3Ds = geoRegion3D.getPartsList().get(i);
            this._$8.add(point3Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion3D);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegion3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPerimeter(this.getHandle());
    }

    public int addPart(Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = point3Ds.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        int n2 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
        Point3Ds point3Ds2 = new Point3Ds(this._$1(n2));
        Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
        this._$8.add(point3Ds3);
        return n2;
    }

    public GeoLine3D convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLine3D geoLine3D = new GeoLine3D();
        for (int i = 0; i < this.getPartCount(); ++i) {
            geoLine3D.addPart(this.getPart(i));
        }
        geoLine3D.setIsDisposable(true);
        return geoLine3D;
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegion3DNative.jni_RemovePart(this.getHandle(), n);
        if (bl) {
            this._$8.remove(n);
        }
        return bl;
    }

    public Point3Ds getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$8.get(n);
    }

    public boolean insertPart(int n, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = point3Ds.getCount();
        if (n2 < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        if (n == this.getPartCount()) {
            int n3 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
            Point3Ds point3Ds2 = new Point3Ds(this._$1(n3));
            Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
            this._$8.add(n, point3Ds3);
            return n3 != -1;
        }
        boolean bl = GeoRegion3DNative.jni_InsertPart(this.getHandle(), n, dArray, dArray2, dArray3);
        Point3Ds point3Ds4 = new Point3Ds(this._$1(n));
        Point3Ds point3Ds5 = new Point3Ds(point3Ds4, this);
        this._$8.add(n, point3Ds5);
        return bl;
    }

    public boolean setPart(int n, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (point3Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point3Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3);
        if (bl) {
            Point3Ds point3Ds2 = new Point3Ds(this._$1(n));
            Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
            this._$8.set(n, point3Ds3);
        }
        return bl;
    }

    boolean setPartJustToUGC(int n, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (point3Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point3Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point3Ds.getItem(i).getX();
            dArray2[i] = point3Ds.getItem(i).getY();
            dArray3[i] = point3Ds.getItem(i).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3);
        return bl;
    }

    public int indexOf(Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$8.indexOf(point3Ds);
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this._$8 != null) {
            this._$8.clear();
            this._$8 = null;
        }
        this.setHandle(0L);
    }

    ArrayList<Point3Ds> getPartsList() {
        return this._$8;
    }

    private Point3D[] _$1(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoRegion3DNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 2) {
            Point3D[] point3DArray = new Point3D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            GeoRegion3DNative.jni_GetPart(this.getHandle(), n, dArray, dArray2, dArray3);
            for (int i = 0; i < n2; ++i) {
                point3DArray[i] = new Point3D(dArray[i], dArray2[i], dArray3[i]);
            }
            return point3DArray;
        }
        return null;
    }

    @Override
    public GeoRegion3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion3DNative.jni_Clear(this.getHandle());
        this._$8.clear();
    }

    GeoRegion3D(long l) {
        this.setHandle(l, false);
        this._$8 = new ArrayList();
        this._$1();
    }

    private void _$1() {
        int n = this.getPartCount();
        this._$8.clear();
        for (int i = 0; i < n; ++i) {
            Point3Ds point3Ds = new Point3Ds(this._$1(i));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this._$8.add(point3Ds2);
        }
    }
}

