/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoParametricLineNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoParametricLine
extends Geometry {
    private ArrayList<Geometry> _$5;

    public GeoParametricLine() {
        long l = GeoParametricLineNative.jni_New();
        this.setHandle(l, true);
        this._$5 = new ArrayList();
    }

    GeoParametricLine(long l) {
        if (0L != l) {
            this.setHandle(l, false);
            this._$5 = new ArrayList();
            GeoParametricLine.refreshFromUGC1(this);
        }
    }

    public GeoParametricLine(GeoParametricLine geoParametricLine) {
        if (geoParametricLine == null) {
            String string = InternalResource.loadString("GeoParametricLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoParametricLine);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParametricLine", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoParametricLineNative.jni_Clone(l);
        this._$5 = new ArrayList();
        this.setHandle(l2, true);
        GeoParametricLine.refreshFromUGC1(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoParametricLine);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricLineNative.jni_getLength(this.getHandle());
    }

    public int add(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoParametricLineNative.jni_add(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this._$5.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this._$5.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricLineNative.jni_getCount(this.getHandle());
    }

    public Geometry get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$5.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$5.get(n);
    }

    public boolean set(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this._$5.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoParametricLineNative.jni_set(this.getHandle(), n, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this._$5.get(n);
            geometry3.clearHandle();
            this._$5.remove(n);
            this._$5.add(n, geometry2);
            geometry2.setIsDisposable(false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public GeoParametricLine clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoParametricLine(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoParametricLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getCount() == 0;
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricLineNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this._$5.size(); ++i) {
            this._$5.get(i).setIsDisposable(true);
            this._$5.get(i).setHandle(0L);
            this._$5.get(i).clearHandle();
        }
        this._$5.clear();
    }

    static void refreshFromUGC1(GeoParametricLine geoParametricLine) {
        int n = geoParametricLine.getCount();
        long[] lArray = new long[n];
        GeoParametricLineNative.jni_AllGeometrys(geoParametricLine.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoParametricLine._$5.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoParametricLine);
    }

    void refrashPartsList() {
        for (int i = 0; i < this._$5.size(); ++i) {
            Geometry geometry;
            if (this._$5.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this._$5.get(i);
                ((GeoRegion)geometry).refrashPartsList();
            }
            if (!(this._$5.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this._$5.get(i);
            ((GeoLine)geometry).refrashPartsList();
        }
    }

    protected static GeoParametricLine creatInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoParametricLine(l);
    }
}

