/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.Service;
import org.smslib.TimeoutException;
import org.smslib.helper.Logger;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.CNMIDetector;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.AATHandler;

public class ATHandler
extends AATHandler {
    protected AModemDriver modemDriver;
    protected CNMIDetector cnmiDetector;
    protected static final int DEFAULT_USSD_DCS_NUM = 15;

    public AModemDriver getModemDriver() {
        return this.modemDriver;
    }

    public ATHandler(ModemGateway myGateway) {
        super(myGateway);
        this.modemDriver = myGateway.getModemDriver();
        this.cnmiDetector = null;
        this.terminators = new String[14];
        this.terminators[0] = "OK\\s";
        this.terminators[1] = "\\s*[\\p{ASCII}]*\\s+OK\\s";
        this.terminators[2] = "(ERROR|NO CARRIER|NO DIALTONE)\\s";
        this.terminators[3] = "ERROR:\\s*\\d+\\s";
        this.terminators[4] = "\\+CM[ES]\\s+ERROR:\\s*\\d+\\s";
        this.terminators[5] = "\\+CPIN:\\s*READY\\s";
        this.terminators[6] = "\\+CPIN:\\s*SIM\\s*BUSY\\s";
        this.terminators[7] = "\\+CPIN:\\s*SIM\\s*PIN\\s";
        this.terminators[8] = "\\+CPIN:\\s*SIM\\s*PIN2\\s";
        this.terminators[9] = "\\+CUSD:\\s.*\\s";
        this.terminators[10] = "\\+CMTI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[11] = "\\+CDSI:\\s*\\p{Punct}[\\p{ASCII}]+\\p{Punct}\\p{Punct}\\s*\\d+\\s";
        this.terminators[12] = "RING\\s";
        this.terminators[13] = "\\+CLIP:\\s*\\p{Punct}[\\p{ASCII}]*\\p{Punct}\\p{Punct}\\s*\\d+[\\p{ASCII}]*\\s";
        this.unsolicitedResponses = new String[5];
        this.unsolicitedResponses[0] = "+CMTI";
        this.unsolicitedResponses[1] = "+CDSI";
        this.unsolicitedResponses[2] = "RING";
        this.unsolicitedResponses[3] = "+CLIP";
        this.unsolicitedResponses[4] = "+CUSD";
    }

    @Override
    public void sync() throws IOException, InterruptedException {
        this.getModemDriver().write("ATZ\r");
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("\u001b");
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().write("+++");
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().write("ATZ\r");
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().clearBuffer();
    }

    @Override
    public void echoOff() throws IOException, InterruptedException {
        this.getModemDriver().write("ATE0\r");
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().clearBuffer();
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
        if (!Service.getInstance().getSettings().DISABLE_COPS) {
            this.getModemDriver().write("AT+COPS=0\r");
            this.getModemDriver().getResponse();
        }
    }

    @Override
    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }

    @Override
    public boolean isAlive() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT\r");
        String response = this.getModemDriver().getResponse();
        if (response.indexOf("AT\r") == -1) {
            return this.getModemDriver().isOk();
        }
        return false;
    }

    @Override
    public String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean enterPin(String pin) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPIN=\"_1_\"\r".replaceAll("_1_", pin));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public boolean setVerboseErrors() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMEE=1\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public boolean setPduProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=0\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=1\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT+CSCS=\"8859-1\"\r");
            this.getModemDriver().getResponse();
            return this.getModemDriver().isOk();
        }
        return false;
    }

    @Override
    public boolean setIndications() throws TimeoutException, GatewayException, IOException, InterruptedException {
        int RETRIES = 3;
        for (int count = 0; count < RETRIES; ++count) {
            this.getModemDriver().write("AT+CNMI=?\r");
            try {
                this.cnmiDetector = new CNMIDetector(this.getModemDriver().getResponse());
                this.getModemDriver().write(this.cnmiDetector.getATCommand());
                this.getModemDriver().getResponse();
                return this.getModemDriver().isOk();
            }
            catch (Exception e) {
                Logger.getInstance().logWarn("Retrying the detection of CNMI, modem busy?", null, this.getGateway().getGatewayId());
                Thread.sleep(Service.getInstance().getSettings().AT_WAIT_CNMI);
                continue;
            }
        }
        Logger.getInstance().logWarn("CNMI detection failed, proceeding with defaults.", null, this.getGateway().getGatewayId());
        return false;
    }

    @Override
    public CNMIDetector getIndications() {
        return this.cnmiDetector;
    }

    @Override
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMI\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMM\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGSN\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CIMI\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGMR\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CBC\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSQ\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getNetworkOperator() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+COPS?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean switchStorageLocation(String mem) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (mem.equalsIgnoreCase("--")) {
            return true;
        }
        this.getModemDriver().write("AT+CPMS=\"" + mem + "\"\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public void switchToCmdMode() throws IOException, InterruptedException {
        this.getModemDriver().write("+++");
        Date start = new Date();
        while (new Date().getTime() - start.getTime() <= (long)Service.getInstance().getSettings().AT_WAIT_CMD) {
            Thread.sleep(100L);
        }
    }

    @Override
    public void keepLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (!Service.getInstance().getSettings().DISABLE_CMMS) {
            this.getModemDriver().write("AT+CMMS=2\r");
            this.getModemDriver().getResponse();
        }
    }

    @Override
    public int sendMessage(int size, String pdu, String phone, String text) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int refNo;
        block14: {
            refNo = -1;
            if (this.getGateway().getProtocol() == AGateway.Protocols.PDU) {
                int errorRetries = 0;
                while (true) {
                    int responseRetries = 0;
                    this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("\"_1_\"", "" + size));
                    Thread.sleep(Service.getInstance().getSettings().AT_WAIT_CGMS);
                    while (!this.getModemDriver().dataAvailable()) {
                        if (++responseRetries == Service.getInstance().getSettings().OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        Logger.getInstance().logWarn("ATHandler().SendMessage(): Still waiting for response (I) (" + responseRetries + ")...", null, this.getGateway().getGatewayId());
                        Thread.sleep(Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT);
                    }
                    responseRetries = 0;
                    this.getModemDriver().clearBuffer();
                    this.getModemDriver().write(pdu);
                    this.getModemDriver().write('\u001a');
                    String response = this.getModemDriver().getResponse();
                    while (response.length() == 0) {
                        if (++responseRetries == Service.getInstance().getSettings().OUTBOUND_RETRIES) {
                            throw new GatewayException("Gateway is not responding, max number of retries reached.");
                        }
                        Logger.getInstance().logWarn("ATHandler().SendMessage(): Still waiting for response (II) (" + responseRetries + ")...", null, this.getGateway().getGatewayId());
                        Thread.sleep(Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT);
                        response = this.getModemDriver().getResponse();
                    }
                    if (this.getModemDriver().getLastError() == 0) {
                        Matcher m = Pattern.compile("\\s*\\+CMGS: *(\\d+)").matcher(response);
                        refNo = m.find() ? Integer.parseInt(m.group(1)) : -1;
                        break block14;
                    }
                    if (this.getModemDriver().getLastError() > 0) {
                        if (++errorRetries == Service.getInstance().getSettings().OUTBOUND_RETRIES) {
                            Logger.getInstance().logError(this.getModemDriver().getLastErrorText() + ": Quit retrying, message lost...", null, this.getGateway().getGatewayId());
                            refNo = -1;
                            break block14;
                        }
                        Logger.getInstance().logWarn(this.getModemDriver().getLastErrorText() + ": Retrying...", null, this.getGateway().getGatewayId());
                        Thread.sleep(Service.getInstance().getSettings().OUTBOUND_RETRY_WAIT);
                        continue;
                    }
                    refNo = -1;
                }
            }
            if (this.getGateway().getProtocol() == AGateway.Protocols.TEXT) {
                this.getModemDriver().write("AT+CMGS=\"_1_\"\r".replaceAll("_1_", phone));
                this.getModemDriver().clearBuffer();
                this.getModemDriver().write(text);
                Thread.sleep(Service.getInstance().getSettings().AT_WAIT_CGMS);
                this.getModemDriver().write('\u001a');
                String response = this.getModemDriver().getResponse();
                if (response.indexOf("OK\r") >= 0) {
                    StringBuilder tmp = new StringBuilder();
                    int i = response.indexOf(":");
                    while (!Character.isDigit(response.charAt(i))) {
                        ++i;
                    }
                    while (Character.isDigit(response.charAt(i))) {
                        tmp.append(response.charAt(i));
                        ++i;
                    }
                    refNo = Integer.parseInt(tmp.toString());
                } else {
                    refNo = -1;
                }
            }
        }
        return refNo;
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getGateway().getProtocol() == AGateway.Protocols.PDU) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=4\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=0\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=1\r");
            }
        } else if (this.getGateway().getProtocol() == AGateway.Protocols.TEXT) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
            }
        }
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getMessageByIndex(int msgIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGR=" + msgIndex + "\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (!this.switchStorageLocation(memLocation)) {
            return false;
        }
        Thread.sleep(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().write("AT+CMGD=_1_\r".replaceAll("_1_", "" + memIndex));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public String getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGATT?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String send(String s) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write(s);
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getNetworkRegistration() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CREG=1\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CREG?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public void readStorageLocations() throws Exception {
        this.getModemDriver().write("AT+CPMS=?\r");
        String response = this.getModemDriver().getResponse();
        try {
            if (response.indexOf("+CPMS:") >= 0) {
                int i = response.indexOf(40);
                while (response.charAt(i) == '(') {
                    ++i;
                }
                int j = i;
                while (response.charAt(j) != ')') {
                    ++j;
                }
                response = response.substring(i, j);
                StringTokenizer tokens = new StringTokenizer(response, ",");
                while (tokens.hasMoreTokens()) {
                    String loc = tokens.nextToken().replaceAll("\"", "");
                    if (loc.equalsIgnoreCase("MT") || this.getStorageLocations().indexOf(loc) >= 0) continue;
                    this.addStorageLocation(loc);
                }
            } else {
                this.addStorageLocation("SM");
                Logger.getInstance().logWarn("CPMS detection failed, proceeding with default storage 'SM'.", null, this.getGateway().getGatewayId());
            }
        }
        catch (Exception e) {
            this.addStorageLocation("SM");
            Logger.getInstance().logWarn("CPMS detection failed, proceeding with default storage 'SM'.", null, this.getGateway().getGatewayId());
        }
    }

    @Override
    public String readPhonebookLocations() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPBS=?\r");
        String response = this.getModemDriver().getResponse();
        if (response.indexOf("+CPBS:") >= 0) {
            response = response.replaceAll("\\s*\\+CPBS:\\s*", "");
            response = response.replaceAll("[()]", "");
            return response;
        }
        return "";
    }

    @Override
    public String readPhonebook(String loc) throws GatewayException, TimeoutException, IOException {
        try {
            this.getModemDriver().write("AT+CPBS=\"" + loc + "\"\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBR=?\r");
            String response = this.getModemDriver().getResponse();
            response = response.replaceAll("\\s*\\+CPBR:\\s*", "");
            response = response.replaceAll("[()]", "");
            StringTokenizer tokens1 = new StringTokenizer(response, ",");
            StringTokenizer tokens2 = new StringTokenizer(tokens1.nextToken(), "-");
            int minIndex = Integer.parseInt(tokens2.nextToken());
            int maxIndex = Integer.parseInt(tokens2.nextToken());
            this.getModemDriver().write("AT+CPBR=" + minIndex + "," + maxIndex + "\r");
            response = this.getModemDriver().getResponse();
            return response;
        }
        catch (Exception e) {
            Logger.getInstance().logWarn("Phonebook detection failed.", null, this.getGateway().getGatewayId());
            return "";
        }
    }

    @Override
    public String sendCustomATCommand(String atCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.getModemDriver().write(atCommand);
        return this.getModemDriver().getResponse();
    }

    @Override
    public String sendUSSDCommand(String ussdCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        return this.sendUSSDCommand(ussdCommand, false);
    }

    @Override
    public String sendUSSDCommand(String ussdCommand, boolean interactive) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String regex;
        Pattern pattern;
        Matcher matcher;
        String command = this.formatUSSDCommand(ussdCommand);
        String ussdResponse = this.sendCustomATCommand(command);
        if (!ussdResponse.contains("OK")) {
            Logger.getInstance().logError("+CUSD command returned non-OK result: " + ussdResponse, null, this.getGateway().getGatewayId());
            return null;
        }
        ussdResponse = this.getModemDriver().getResponse(AGateway.AsyncEvents.USSDRESPONSE);
        if (!interactive) {
            char esc = '\u001b';
            command = "" + esc + '\r';
            this.getModemDriver().write(command);
            this.getModemDriver().clearBuffer();
        }
        String response = (matcher = (pattern = Pattern.compile(regex = "\"(.*)\"")).matcher(ussdResponse)).find() ? this.formatUSSDResponse(matcher.group(1)) : ussdResponse;
        return response;
    }

    @Override
    public boolean sendUSSDRequest(String presentation, String content, String dcs) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String rawRequest = this.formatUSSDCommand(presentation, content, dcs);
        String ussdResponse = this.sendCustomATCommand(rawRequest);
        if (!ussdResponse.contains("OK")) {
            Logger.getInstance().logError("+CUSD command returned non-OK result: " + ussdResponse, null, this.getGateway().getGatewayId());
            return false;
        }
        return true;
    }

    protected String formatUSSDCommand(String ussdCommand) {
        return this.formatUSSDCommand("1", ussdCommand, null);
    }

    protected String formatUSSDCommand(String presentation, String content, String dcs) {
        StringBuffer buf = new StringBuffer();
        buf.append("AT+CUSD=");
        buf.append(presentation);
        buf.append(",");
        buf.append("\"");
        buf.append(content);
        buf.append("\"");
        if (dcs != null && dcs.length() > 0) {
            buf.append(",");
            buf.append(dcs);
        }
        buf.append("\r");
        return buf.toString();
    }

    @Override
    public String formatUSSDResponse(String ussdResponse) {
        return ussdResponse;
    }

    @Override
    public AGateway.AsyncEvents processUnsolicitedEvents(String response) throws IOException {
        AGateway.AsyncEvents event = AGateway.AsyncEvents.NOTHING;
        if (response.indexOf(this.getUnsolicitedResponse(0)) >= 0) {
            event = AGateway.AsyncEvents.INBOUNDMESSAGE;
        } else if (response.indexOf(this.getUnsolicitedResponse(1)) >= 0) {
            event = AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE;
        } else if (response.indexOf(this.getUnsolicitedResponse(2)) >= 0) {
            event = AGateway.AsyncEvents.NOTHING;
        } else if (response.indexOf(this.getUnsolicitedResponse(3)) >= 0) {
            event = AGateway.AsyncEvents.INBOUNDCALL;
        } else if (response.indexOf(this.getUnsolicitedResponse(4)) >= 0) {
            event = AGateway.AsyncEvents.USSDRESPONSE;
        }
        return event;
    }
}

