/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import net.sf.oval.Check;
import net.sf.oval.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.LengthCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.RangeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAAnnotationsConfigurer
implements Configurer {
    private static final NotNullCheck NOT_NULL = new NotNullCheck();
    private static final AssertValidCheck ASSERT_VALID = new AssertValidCheck();
    protected Boolean applyFieldConstraintsToSetters;
    protected Boolean applyFieldConstraintsToConstructors;

    public Boolean getApplyFieldConstraintsToConstructors() {
        return this.applyFieldConstraintsToConstructors;
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration config = new ClassConfiguration();
        config.type = clazz;
        config.applyFieldConstraintsToConstructors = this.applyFieldConstraintsToConstructors;
        config.applyFieldConstraintsToSetters = this.applyFieldConstraintsToSetters;
        Field[] fieldArray = config.type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            List<Check> checks = Validator.getCollectionFactory().createList(4);
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                if (annotation instanceof Basic) {
                    this.initializeChecks((Basic)annotation, checks, field);
                } else if (annotation instanceof Column) {
                    this.initializeChecks((Column)annotation, checks, field);
                } else if (annotation instanceof OneToOne) {
                    this.initializeChecks((OneToOne)annotation, checks, field);
                } else if (annotation instanceof ManyToOne) {
                    this.initializeChecks((ManyToOne)annotation, checks, field);
                } else if (annotation instanceof ManyToMany) {
                    this.initializeChecks((ManyToMany)annotation, checks, field);
                } else if (annotation instanceof OneToMany) {
                    this.initializeChecks((OneToMany)annotation, checks, field);
                }
                ++n4;
            }
            if (checks.size() > 0) {
                if (config.fieldConfigurations == null) {
                    config.fieldConfigurations = Validator.getCollectionFactory().createSet(8);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                config.fieldConfigurations.add(fc);
            }
            ++n2;
        }
        return config;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected void initializeChecks(Basic annotation, Collection<Check> checks, Field field) {
        assert (annotation != null);
        assert (checks != null);
        if (!annotation.optional()) {
            checks.add(NOT_NULL);
        }
    }

    protected void initializeChecks(Column annotation, Collection<Check> checks, Field field) {
        assert (annotation != null);
        assert (checks != null);
        if (!(annotation.nullable() || field.isAnnotationPresent(GeneratedValue.class) || field.isAnnotationPresent(Version.class))) {
            checks.add(NOT_NULL);
        }
        if (!field.isAnnotationPresent(Lob.class)) {
            LengthCheck lengthCheck = new LengthCheck();
            lengthCheck.setMax(annotation.length());
            checks.add(lengthCheck);
        }
        if (annotation.precision() > 0 && Number.class.isAssignableFrom(field.getType())) {
            RangeCheck rangeCheck = new RangeCheck();
            rangeCheck.setMax(Math.pow(10.0, annotation.precision() - annotation.scale()) - Math.pow(0.1, annotation.scale()));
            rangeCheck.setMin(-1.0 * rangeCheck.getMax());
            checks.add(rangeCheck);
        }
    }

    protected void initializeChecks(ManyToMany annotation, Collection<Check> checks, Field field) {
        assert (annotation != null);
        assert (checks != null);
        checks.add(ASSERT_VALID);
    }

    protected void initializeChecks(ManyToOne annotation, Collection<Check> checks, Field field) {
        assert (annotation != null);
        assert (checks != null);
        if (!annotation.optional()) {
            checks.add(NOT_NULL);
        }
        checks.add(ASSERT_VALID);
    }

    protected void initializeChecks(OneToMany annotation, Collection<Check> checks, Field field) {
        assert (annotation != null);
        assert (checks != null);
        checks.add(ASSERT_VALID);
    }

    protected void initializeChecks(OneToOne annotation, Collection<Check> checks, Field field) {
        assert (annotation != null);
        assert (checks != null);
        if (!annotation.optional()) {
            checks.add(NOT_NULL);
        }
        checks.add(ASSERT_VALID);
    }

    public Boolean isApplyFieldConstraintsToSetter() {
        return this.applyFieldConstraintsToSetters;
    }

    public void setApplyFieldConstraintsToConstructors(Boolean applyFieldConstraintsToConstructors) {
        this.applyFieldConstraintsToConstructors = applyFieldConstraintsToConstructors;
    }

    public void setApplyFieldConstraintsToSetters(Boolean applyFieldConstraintsToSetters) {
        this.applyFieldConstraintsToSetters = applyFieldConstraintsToSetters;
    }
}

