/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver.gateways;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.smslib.smpp.AbstractSMPPGateway;
import org.smslib.smpp.Address;
import org.smslib.smpp.BindAttributes;
import org.smslib.smsserver.SMSServer;
import org.smslib.smsserver.gateways.AGateway;

public class SMPPGateway
extends AGateway {
    public SMPPGateway(String myGatewayId, Properties myProps, SMSServer myServer) {
        super(myGatewayId, myProps, myServer);
        this.setDescription(myGatewayId + " SMPP Gateway.");
    }

    @Override
    public void create() throws Exception {
        String ton;
        String implClass = this.getProperty("impl");
        Class<?> clazz = Class.forName(implClass);
        Class[] classArgs = new Class[]{String.class, String.class, Integer.TYPE, BindAttributes.class};
        Constructor<?> con = clazz.getConstructor(classArgs);
        String host = this.getProperty("host");
        Integer port = Integer.parseInt(this.getProperty("port"));
        Object[] args = new Object[]{this.getGatewayId(), host, port, this.getBindAttributes()};
        AbstractSMPPGateway gateway = (AbstractSMPPGateway)con.newInstance(args);
        String enquireLink = this.getProperty("enquirelink");
        if (enquireLink != null && !enquireLink.isEmpty()) {
            gateway.setEnquireLink(Integer.parseInt(enquireLink));
        }
        Address.TypeOfNumber typeOfNumber = (ton = this.getProperty("sourceton")) == null ? Address.TypeOfNumber.UNKNOWN : Address.TypeOfNumber.valueOf(Byte.parseByte(ton));
        String npi = this.getProperty("sourcenpi");
        Address.NumberingPlanIndicator numberingPlanIndicator = npi == null ? Address.NumberingPlanIndicator.UNKNOWN : Address.NumberingPlanIndicator.valueOf(Byte.parseByte(npi));
        gateway.setSourceAddress(new Address(typeOfNumber, numberingPlanIndicator));
        ton = this.getProperty("destton");
        typeOfNumber = ton == null ? Address.TypeOfNumber.UNKNOWN : Address.TypeOfNumber.valueOf(Byte.parseByte(ton));
        npi = this.getProperty("destnpi");
        numberingPlanIndicator = npi == null ? Address.NumberingPlanIndicator.UNKNOWN : Address.NumberingPlanIndicator.valueOf(Byte.parseByte(npi));
        gateway.setDestinationAddress(new Address(typeOfNumber, numberingPlanIndicator));
        this.setGateway(gateway);
    }

    private BindAttributes getBindAttributes() {
        String systemId = this.getProperty("systemid");
        String password = this.getProperty("password");
        String systemType = this.getProperty("systemtype");
        BindAttributes.BindType bindType = BindAttributes.BindType.getByShortName(this.getProperty("bindtype"));
        String ton = this.getProperty("bindton");
        Address.TypeOfNumber typeOfNumber = ton == null ? Address.TypeOfNumber.UNKNOWN : Address.TypeOfNumber.valueOf(Byte.parseByte(ton));
        String npi = this.getProperty("bindnpi");
        Address.NumberingPlanIndicator numberingPlanIndicator = npi == null ? Address.NumberingPlanIndicator.UNKNOWN : Address.NumberingPlanIndicator.valueOf(Byte.parseByte(npi));
        return new BindAttributes(systemId, password, systemType, bindType, new Address(typeOfNumber, numberingPlanIndicator));
    }

    private String getProperty(String name) {
        String propertyValue = this.getProperties().getProperty(this.getGatewayId() + "." + name);
        if (propertyValue != null) {
            return propertyValue.trim();
        }
        return propertyValue;
    }
}

