/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smsserver;

import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.smslib.ICallNotification;
import org.smslib.IInboundMessageNotification;
import org.smslib.IOrphanedMessageNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.IQueueSendingNotification;
import org.smslib.InboundMessage;
import org.smslib.Library;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.balancing.LoadBalancer;
import org.smslib.helper.Logger;
import org.smslib.routing.Router;
import org.smslib.smsserver.gateways.AGateway;
import org.smslib.smsserver.interfaces.Interface;

public class SMSServer {
    Properties props;
    boolean shutdown = false;
    List<Interface<? extends Object>> infList = new ArrayList<Interface<? extends Object>>();
    InboundNotification inboundNotification;
    OutboundNotification outboundNotification;
    CallNotification callNotification;
    QueueSendingNotification queueSendingNotification;
    OrphanedMessageNotification orphanedMessageNotification;
    InboundPollingThread inboundPollingThread;
    OutboundPollingThread outboundPollingThread;
    boolean optRunOnce = false;

    public SMSServer() {
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        this.inboundNotification = new InboundNotification();
        this.outboundNotification = new OutboundNotification();
        this.callNotification = new CallNotification();
        this.queueSendingNotification = new QueueSendingNotification();
        this.orphanedMessageNotification = new OrphanedMessageNotification();
        this.inboundPollingThread = null;
        this.outboundPollingThread = null;
        Service.getInstance().setOutboundMessageNotification(this.outboundNotification);
        Service.getInstance().setCallNotification(this.callNotification);
        Service.getInstance().setQueueSendingNotification(this.queueSendingNotification);
        Service.getInstance().setOrphanedMessageNotification(this.orphanedMessageNotification);
    }

    public List<Interface<? extends Object>> getInfList() {
        return this.infList;
    }

    public boolean getShutdown() {
        return this.shutdown;
    }

    public Properties getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() throws Exception {
        try (FileInputStream f = null;){
            StringTokenizer tokens;
            String propValue;
            String propName;
            int i;
            Constructor<?> constructor;
            Class<?> c;
            this.props = new Properties();
            f = System.getProperty("smsserver.configdir") != null ? new FileInputStream(System.getProperty("smsserver.configdir") + "SMSServer.conf") : (System.getProperty("smsserver.configfile") != null ? new FileInputStream(System.getProperty("smsserver.configfile")) : new FileInputStream("SMSServer.conf"));
            this.getProperties().load(f);
            if (this.getProperties().getProperty("smsserver.balancer", "").length() > 0) {
                try {
                    c = Class.forName((this.getProperties().getProperty("smsserver.balancer", "").indexOf(46) == -1 ? "org.smslib.balancing." : "") + this.getProperties().getProperty("smsserver.balancer", ""));
                    constructor = c.getConstructor(new Class[0]);
                    LoadBalancer balancer = (LoadBalancer)constructor.newInstance(new Object[0]);
                    Service.getInstance().setLoadBalancer(balancer);
                    Logger.getInstance().logInfo("SMSServer: set balancer to: " + this.getProperties().getProperty("smsserver.balancer", ""), null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.getInstance().logError("SMSServer: error setting custom balancer!", null, null);
                }
            }
            if (this.getProperties().getProperty("smsserver.router", "").length() > 0) {
                try {
                    c = Class.forName((this.getProperties().getProperty("smsserver.router", "").indexOf(46) == -1 ? "org.smslib.routing." : "") + this.getProperties().getProperty("smsserver.router", ""));
                    constructor = c.getConstructor(new Class[0]);
                    Router router = (Router)constructor.newInstance(new Object[0]);
                    Service.getInstance().setRouter(router);
                    Logger.getInstance().logInfo("SMSServer: set router to: " + this.getProperties().getProperty("smsserver.router", ""), null, null);
                }
                catch (Exception e) {
                    Logger.getInstance().logError("SMSServer: error setting custom balancer!", null, null);
                }
            }
            for (i = 0; i < Integer.MAX_VALUE; ++i) {
                try {
                    propName = "gateway." + i;
                    propValue = this.getProperties().getProperty(propName, "");
                    if (propValue.length() == 0) break;
                    tokens = new StringTokenizer(propValue, ",");
                    String gtwId = tokens.nextToken().trim();
                    String gtwClass = tokens.nextToken().trim();
                    Object[] args = new Object[]{gtwId, this.getProperties(), this};
                    Class[] argsClass = new Class[]{String.class, Properties.class, SMSServer.class};
                    Class<?> c2 = Class.forName((gtwClass.indexOf(46) == -1 ? "org.smslib.smsserver.gateways." : "") + gtwClass);
                    Constructor<?> constructor2 = c2.getConstructor(argsClass);
                    AGateway gtw = (AGateway)constructor2.newInstance(args);
                    gtw.create();
                    Service.getInstance().addGateway(gtw.getGateway());
                    Logger.getInstance().logInfo("SMSServer: added gateway " + gtwId + " / " + gtw.getDescription(), null, null);
                    continue;
                }
                catch (Exception e) {
                    Logger.getInstance().logError("SMSServer: Unknown Gateway in configuration file!", null, null);
                }
            }
            for (i = 0; i < Integer.MAX_VALUE; ++i) {
                try {
                    propName = "interface." + i;
                    propValue = this.getProperties().getProperty(propName, "");
                    if (propValue.length() == 0) {
                        break;
                    }
                    tokens = new StringTokenizer(propValue, ",");
                    String infId = tokens.nextToken().trim();
                    String infClass = tokens.nextToken().trim();
                    Interface.InterfaceTypes infType = null;
                    String sinfType = tokens.hasMoreTokens() ? tokens.nextToken() : "inoutbound";
                    infType = "inbound".equalsIgnoreCase(sinfType = sinfType.trim()) ? Interface.InterfaceTypes.INBOUND : ("outbound".equalsIgnoreCase(sinfType) ? Interface.InterfaceTypes.OUTBOUND : Interface.InterfaceTypes.INOUTBOUND);
                    Object[] args = new Object[]{infId, this.getProperties(), this, infType};
                    Class[] argsClass = new Class[]{String.class, Properties.class, SMSServer.class, Interface.InterfaceTypes.class};
                    Class<?> c3 = Class.forName((infClass.indexOf(46) == -1 ? "org.smslib.smsserver.interfaces." : "") + infClass);
                    Constructor<?> constructor3 = c3.getConstructor(argsClass);
                    Interface inf = (Interface)constructor3.newInstance(args);
                    this.getInfList().add(inf);
                    Logger.getInstance().logInfo("SMSServer: added interface " + infId + " / " + inf.getDescription() + " / " + (Object)((Object)inf.getType()), null, null);
                    continue;
                }
                catch (InvocationTargetException e) {
                    Logger.getInstance().logError("SMSServer: Illegal Interface configuration: " + e.getCause().getMessage(), null, null);
                    continue;
                }
                catch (Exception e) {
                    Logger.getInstance().logError("SMSServer: Unknown Interface in configuration file!", null, null);
                }
            }
        }
    }

    private void process() throws Exception {
        this.inboundPollingThread = new InboundPollingThread();
        this.inboundPollingThread.setName("SMSServer - InboundPollingThread");
        this.inboundPollingThread.start();
        this.outboundPollingThread = new OutboundPollingThread();
        this.outboundPollingThread.setName("SMSServer - OutboundPollingThread");
        this.outboundPollingThread.start();
        while (!this.shutdown) {
            Thread.sleep(1000L);
        }
    }

    void startInterfaces() throws Exception {
        for (Interface<? extends Object> inf : this.getInfList()) {
            inf.start();
        }
    }

    void stopInterfaces() throws Exception {
        for (Interface<? extends Object> inf : this.getInfList()) {
            inf.stop();
        }
    }

    private void run() throws Exception {
        block3: {
            this.loadConfiguration();
            try {
                this.startInterfaces();
                Service.getInstance().startService();
                this.process();
            }
            catch (Exception e) {
                Logger.getInstance().logError("SMSServer error!", e, null);
                this.stopInterfaces();
                Service.getInstance().stopService();
                if (this.inboundPollingThread != null) {
                    this.inboundPollingThread.interrupt();
                    this.inboundPollingThread.join();
                }
                if (this.outboundPollingThread == null) break block3;
                this.outboundPollingThread.interrupt();
                this.outboundPollingThread.join();
            }
        }
    }

    void readMessages() {
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        try {
            Service.getInstance().readMessages(msgList, InboundMessage.MessageClasses.ALL);
            if (msgList.size() > 0) {
                for (Interface<? extends Object> inf : this.getInfList()) {
                    if (!inf.isInbound()) continue;
                    inf.messagesReceived(msgList);
                }
                if (this.getProperties().getProperty("settings.delete_after_processing", "no").equalsIgnoreCase("yes")) {
                    for (InboundMessage msg : msgList) {
                        Service.getInstance().deleteMessage(msg);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getInstance().logError("SMSServer: reading messages exception!", e, null);
        }
    }

    void sendMessages() {
        block17: {
            boolean foundOutboundGateway = false;
            for (org.smslib.AGateway gtw : Service.getInstance().getGateways()) {
                if (!gtw.isOutbound()) continue;
                foundOutboundGateway = true;
                break;
            }
            if (!foundOutboundGateway) break block17;
            ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
            try {
                for (Interface<? extends Object> inf : this.getInfList()) {
                    if (!inf.isOutbound()) continue;
                    msgList.addAll(inf.getMessagesToSend());
                }
            }
            catch (Exception e) {
                Logger.getInstance().logError("SMSServer: sending messages exception!", e, null);
            }
            if (this.getProperties().getProperty("settings.send_mode", "sync").equalsIgnoreCase("sync")) {
                Logger.getInstance().logInfo("SMSServer: sending synchronously...", null, null);
                for (OutboundMessage msg : msgList) {
                    try {
                        Service.getInstance().sendMessage(msg);
                        for (Interface<? extends Object> inf : this.getInfList()) {
                            if (!inf.isOutbound()) continue;
                            inf.markMessage(msg);
                        }
                    }
                    catch (Exception e) {
                        Logger.getInstance().logError("SMSServer: sending messages exception!", e, null);
                        try {
                            for (Interface<? extends Object> inf : this.getInfList()) {
                                if (!inf.isOutbound()) continue;
                                inf.markMessage(msg);
                            }
                        }
                        catch (Exception e1) {
                            Logger.getInstance().logError("SMSServer: sending messages exception!", e1, null);
                        }
                    }
                }
            } else {
                Logger.getInstance().logInfo("SMSServer: sending asynchronously... [" + msgList.size() + "]", null, null);
                for (OutboundMessage msg : msgList) {
                    if (Service.getInstance().queueMessage(msg)) continue;
                    try {
                        for (Interface<? extends Object> inf : this.getInfList()) {
                            if (!inf.isOutbound()) continue;
                            inf.markMessage(msg);
                        }
                    }
                    catch (Exception e) {
                        Logger.getInstance().logError("SMSServer: sending messages exception!", e, null);
                    }
                }
            }
        }
    }

    public boolean checkPriorityTimeFrame(int priority) {
        Calendar cal = Calendar.getInstance();
        String timeFrame = priority < 0 ? this.getProperties().getProperty("settings.timeframe.low", "0000-2359") : (priority == 0 ? this.getProperties().getProperty("settings.timeframe.normal", "0000-2359") : (priority >= 0 ? this.getProperties().getProperty("settings.timeframe.high", "0000-2359") : "0000-2359"));
        String from = timeFrame.substring(0, 4);
        String to = timeFrame.substring(5, 9);
        cal.setTime(new Date());
        String current = cal.get(11) < 10 ? "0" + cal.get(11) : "" + cal.get(11);
        current = current + (cal.get(12) < 10 ? "0" + cal.get(12) : "" + cal.get(12));
        return Integer.parseInt(current) >= Integer.parseInt(from) && Integer.parseInt(current) < Integer.parseInt(to);
    }

    public static void main(String[] args) {
        System.out.println(Library.getLibraryDescription());
        System.out.println("\nSMSLib API version: " + Library.getLibraryVersion());
        System.out.println("SMSServer version: " + Library.getLibraryVersion());
        SMSServer app = new SMSServer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-runonce")) {
                app.optRunOnce = true;
                continue;
            }
            System.out.println("Invalid argument: " + args[i]);
        }
        try {
            app.run();
            Logger.getInstance().logInfo("SMSServer exiting normally.", null, null);
        }
        catch (Exception e) {
            Logger.getInstance().logError("SMSServer Error: ", e, null);
            try {
                Service.getInstance().stopService();
            }
            catch (Exception e1) {
                Logger.getInstance().logError("SMSServer error while shutting down: ", e1, null);
            }
        }
    }

    class OrphanedMessageNotification
    implements IOrphanedMessageNotification {
        OrphanedMessageNotification() {
        }

        @Override
        public boolean process(org.smslib.AGateway gateway, InboundMessage msg) {
            System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
            System.out.println("&&&&&&&&&&&&&&&&& ORPHANED INFO &&&&&&&&&&&&&&&&&");
            System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
            System.out.println(msg);
            System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
            System.out.println("&&&&&&&&&&&&&&&&& ORPHANED INFO &&&&&&&&&&&&&&&&&");
            System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
            return false;
        }
    }

    class QueueSendingNotification
    implements IQueueSendingNotification {
        QueueSendingNotification() {
        }

        @Override
        public void process(org.smslib.AGateway gateway, OutboundMessage msg) {
            Logger.getInstance().logInfo("**** >>>> Now Sending: " + msg.getRecipient(), null, gateway.getGatewayId());
        }
    }

    class CallNotification
    implements ICallNotification {
        CallNotification() {
        }

        @Override
        public void process(org.smslib.AGateway gateway, String callerId) {
            try {
                for (Interface<? extends Object> inf : SMSServer.this.getInfList()) {
                    inf.callReceived(gateway.getGatewayId(), callerId);
                }
            }
            catch (Exception e) {
                Logger.getInstance().logError("ICallNotification error.", e, null);
            }
        }
    }

    class OutboundNotification
    implements IOutboundMessageNotification {
        OutboundNotification() {
        }

        @Override
        public void process(org.smslib.AGateway gateway, OutboundMessage msg) {
            try {
                for (Interface<? extends Object> inf : SMSServer.this.getInfList()) {
                    if (!inf.isOutbound()) continue;
                    inf.markMessage(msg);
                }
            }
            catch (Exception e) {
                Logger.getInstance().logError("IOutboundMessageNotification error.", e, null);
            }
        }
    }

    class InboundNotification
    implements IInboundMessageNotification {
        InboundNotification() {
        }

        @Override
        public void process(org.smslib.AGateway gateway, Message.MessageTypes msgType, InboundMessage msg) {
            ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
            msgList.add(msg);
            for (Interface<? extends Object> inf : SMSServer.this.getInfList()) {
                if (!inf.isInbound()) continue;
                try {
                    inf.messagesReceived(msgList);
                }
                catch (Exception e) {
                    Logger.getInstance().logError("Error receiving message!", e, null);
                }
            }
            if (SMSServer.this.getProperties().getProperty("settings.delete_after_processing", "no").equalsIgnoreCase("yes")) {
                try {
                    Service.getInstance().deleteMessage(msg);
                }
                catch (Exception e) {
                    Logger.getInstance().logError("Error deleting received message!", e, null);
                }
            }
            msgList.clear();
        }
    }

    class OutboundPollingThread
    extends Thread {
        OutboundPollingThread() {
        }

        @Override
        public void run() {
            try {
                while (!SMSServer.this.shutdown) {
                    Logger.getInstance().logDebug("OutboundPollingThread() run.", null, null);
                    SMSServer.this.sendMessages();
                    if (!SMSServer.this.optRunOnce) {
                        Thread.sleep(Integer.parseInt(SMSServer.this.getProperties().getProperty("settings.outbound_interval", "60")) * 1000);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Logger.getInstance().logDebug("OutboundPollingThread() interrupted.", null, null);
            }
            catch (Exception e) {
                Logger.getInstance().logDebug("Error in OutboundPollingThread()", e, null);
            }
        }
    }

    class InboundPollingThread
    extends Thread {
        InboundPollingThread() {
        }

        @Override
        public void run() {
            try {
                while (!SMSServer.this.shutdown) {
                    Logger.getInstance().logDebug("InboundPollingThread() run.", null, null);
                    SMSServer.this.readMessages();
                    if (SMSServer.this.optRunOnce) {
                        SMSServer.this.shutdown = true;
                        new Shutdown().start();
                        break;
                    }
                    Thread.sleep(Integer.parseInt(SMSServer.this.getProperties().getProperty("settings.inbound_interval", "60")) * 1000);
                }
            }
            catch (InterruptedException e) {
                Logger.getInstance().logDebug("InboundPollingThread() interrupted.", null, null);
            }
            catch (Exception e) {
                Logger.getInstance().logDebug("Error in InboundPollingThread()", e, null);
            }
        }
    }

    class Shutdown
    extends Thread {
        Shutdown() {
        }

        @Override
        public void run() {
            Logger.getInstance().logInfo("SMSServer shutting down, please wait...", null, null);
            SMSServer.this.shutdown = true;
            try {
                SMSServer.this.stopInterfaces();
                if (Service.getInstance().getQueueManager() != null) {
                    Service.getInstance().getQueueManager().removeAllPendingMessages();
                }
                if (Service.getInstance().getQueueManager() != null) {
                    Service.getInstance().getQueueManager().removeAllDelayedMessages();
                }
                Service.getInstance().stopService();
                if (SMSServer.this.inboundPollingThread != null) {
                    SMSServer.this.inboundPollingThread.interrupt();
                    SMSServer.this.inboundPollingThread.join();
                }
                if (SMSServer.this.outboundPollingThread != null) {
                    SMSServer.this.outboundPollingThread.interrupt();
                    SMSServer.this.outboundPollingThread.join();
                }
            }
            catch (Exception e) {
                Logger.getInstance().logError("Shutdown hook error.", e, null);
                e.printStackTrace();
            }
        }
    }
}

