/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.smpp;

import org.smslib.smpp.Address;

public class BindAttributes {
    private String systemId;
    private String password;
    private String systemType;
    private BindType bindType;
    private Address bindAddress;

    public BindAttributes(String systemId, String password, String systemType, BindType bindType) {
        this(systemId, password, systemType, bindType, new Address());
    }

    public BindAttributes(String systemId, String password, String systemType, BindType bindType, Address bindAddress) {
        this.systemId = systemId;
        this.password = password;
        this.systemType = systemType;
        this.bindType = bindType;
        this.bindAddress = bindAddress;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public BindType getBindType() {
        return this.bindType;
    }

    public Address getBindAddress() {
        return this.bindAddress;
    }

    public static enum BindType {
        RECEIVER("r"),
        TRANSMITTER("t"),
        TRANSCEIVER("tr");

        private String value;

        private BindType(String value) {
            this.value = value;
        }

        public static BindType getByShortName(String value) throws IllegalArgumentException {
            for (BindType item : BindType.values()) {
                if (!item.value().equals(value)) continue;
                return item;
            }
            throw new IllegalArgumentException("No enum const BindType with value " + value);
        }

        public String value() {
            return this.value;
        }
    }
}

