/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.smslib.SMSLibException;
import org.smslib.crypto.AKey;
import org.smslib.crypto.ASymmetricKey;

public class KeyManager {
    private static KeyManager _instance = null;
    HashMap<String, AKey> keys = new HashMap();

    private KeyManager() {
    }

    public static KeyManager getInstance() {
        if (_instance == null) {
            _instance = new KeyManager();
        }
        return _instance;
    }

    public void registerKey(String mobileNumber, AKey key) {
        this.keys.put(mobileNumber.charAt(0) == '+' ? mobileNumber.substring(1) : mobileNumber, key);
    }

    public AKey unregisterKey(String mobileNumber) {
        return this.keys.remove(mobileNumber.charAt(0) == '+' ? mobileNumber.substring(1) : mobileNumber);
    }

    public void unregisterAllKeys() {
        this.keys.clear();
    }

    public AKey getKey(String mobileNumber) {
        if (mobileNumber == null) {
            return null;
        }
        return this.keys.get(mobileNumber.charAt(0) == '+' ? mobileNumber.substring(1) : mobileNumber);
    }

    public byte[] encrypt(String mobileNumber, byte[] message) throws SMSLibException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        AKey k = this.getKey(mobileNumber);
        if (k == null) {
            throw new SMSLibException("Could not find Encryption Key for the specific number.");
        }
        if (k instanceof ASymmetricKey) {
            return ((ASymmetricKey)k).encrypt(message);
        }
        return new byte[0];
    }

    public byte[] decrypt(String mobileNumber, byte[] message) throws SMSLibException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        AKey k = this.getKey(mobileNumber);
        if (k == null) {
            throw new SMSLibException("Could not find Encryption Key for the specific number.");
        }
        if (k instanceof ASymmetricKey) {
            return ((ASymmetricKey)k).decrypt(message);
        }
        return new byte[0];
    }
}

