/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.gsm3040.ie;

import org.ajwcc.pduUtils.gsm3040.ie.InformationElement;

public class PortInformationElement
extends InformationElement {
    public static final int PORT_16BIT = 5;

    PortInformationElement(byte id, byte[] data) {
        super(id, data);
        if (this.getIdentifier() != 5) {
            throw new RuntimeException("Invalid identifier " + this.getIdentifier() + " in data in: " + this.getClass().getSimpleName());
        }
        if (data.length != 4) {
            throw new RuntimeException("Invalid data length in: " + this.getClass().getSimpleName());
        }
    }

    PortInformationElement(int identifier, int destPort, int srcPort) {
        byte[] data = null;
        switch (identifier) {
            case 5: {
                data = new byte[]{(byte)((destPort & 0xFF00) >>> 8), (byte)(destPort & 0xFF), (byte)((srcPort & 0xFF00) >>> 8), (byte)(srcPort & 0xFF)};
                break;
            }
            default: {
                throw new RuntimeException("Invalid identifier for " + this.getClass().getSimpleName());
            }
        }
        this.initialize((byte)(identifier & 0xFF), data);
    }

    public int getDestPort() {
        byte[] data = this.getData();
        return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
    }

    public int getSrcPort() {
        byte[] data = this.getData();
        return (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("[Dst Port: ");
        sb.append(this.getDestPort());
        sb.append(", Src Port: ");
        sb.append(this.getSrcPort());
        sb.append("]");
        return sb.toString();
    }
}

