/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryParser.surround.query.DistanceSubQuery;
import org.apache.lucene.queryParser.surround.query.SpanNearClauseFactory;
import org.apache.lucene.queryParser.surround.query.SrndBooleanQuery;
import org.apache.lucene.queryParser.surround.query.SrndQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleTerm
extends SrndQuery
implements DistanceSubQuery,
Comparable<SimpleTerm> {
    private boolean quoted;

    public SimpleTerm(boolean q) {
        this.quoted = q;
    }

    boolean isQuoted() {
        return this.quoted;
    }

    public String getQuote() {
        return "\"";
    }

    public String getFieldOperator() {
        return "/";
    }

    public abstract String toStringUnquoted();

    @Override
    public int compareTo(SimpleTerm ost) {
        return this.toStringUnquoted().compareTo(ost.toStringUnquoted());
    }

    protected void suffixToString(StringBuilder r) {
    }

    @Override
    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.isQuoted()) {
            r.append(this.getQuote());
        }
        r.append(this.toStringUnquoted());
        if (this.isQuoted()) {
            r.append(this.getQuote());
        }
        this.suffixToString(r);
        this.weightToString(r);
        return r.toString();
    }

    public abstract void visitMatchingTerms(IndexReader var1, String var2, MatchingTermVisitor var3) throws IOException;

    @Override
    public String distanceSubQueryNotAllowed() {
        return null;
    }

    @Override
    public Query makeLuceneQueryFieldNoBoost(final String fieldName, final BasicQueryFactory qf) {
        return new Query(){

            public String toString(String fn) {
                return ((Object)((Object)this)).getClass().toString() + " " + fieldName + " (" + fn + "?)";
            }

            public Query rewrite(IndexReader reader) throws IOException {
                final ArrayList<Query> luceneSubQueries = new ArrayList<Query>();
                SimpleTerm.this.visitMatchingTerms(reader, fieldName, new MatchingTermVisitor(){

                    public void visitMatchingTerm(Term term) throws IOException {
                        luceneSubQueries.add(qf.newTermQuery(term));
                    }
                });
                return luceneSubQueries.size() == 0 ? SrndQuery.theEmptyLcnQuery : (luceneSubQueries.size() == 1 ? (Query)luceneSubQueries.get(0) : SrndBooleanQuery.makeBooleanQuery(luceneSubQueries, BooleanClause.Occur.SHOULD));
            }
        };
    }

    @Override
    public void addSpanQueries(final SpanNearClauseFactory sncf) throws IOException {
        this.visitMatchingTerms(sncf.getIndexReader(), sncf.getFieldName(), new MatchingTermVisitor(){

            public void visitMatchingTerm(Term term) throws IOException {
                sncf.addTermWeighted(term, SimpleTerm.this.getWeight());
            }
        });
    }

    public static interface MatchingTermVisitor {
        public void visitMatchingTerm(Term var1) throws IOException;
    }
}

