/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.util.List;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.config.QueryConfigHandler;
import org.apache.lucene.queryParser.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.standard.config.FuzzyConfig;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof FuzzyQueryNode) {
            FuzzyQueryNode fuzzyNode = (FuzzyQueryNode)node;
            QueryConfigHandler config = this.getQueryConfigHandler();
            FuzzyConfig fuzzyConfig = null;
            if (config != null && (fuzzyConfig = config.get(StandardQueryConfigHandler.ConfigurationKeys.FUZZY_CONFIG)) != null) {
                fuzzyNode.setPrefixLength(fuzzyConfig.getPrefixLength());
                if (fuzzyNode.getSimilarity() < 0.0f) {
                    fuzzyNode.setSimilarity(fuzzyConfig.getMinSimilarity());
                }
            } else if (fuzzyNode.getSimilarity() < 0.0f) {
                throw new IllegalArgumentException("No FUZZY_CONFIG set in the config");
            }
        }
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

