/*
 * Decompiled with CFR 0.152.
 */
package org.smslib;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import org.smslib.InboundBinaryMessage;
import org.smslib.InboundEncryptedMessage;
import org.smslib.Message;
import org.smslib.StatusReportMessage;

public class InboundMessage
extends Message {
    private static final long serialVersionUID = 2L;
    private String originator;
    private int memIndex;
    private String memLocation;
    private int mpRefNo;
    private int mpMaxNo;
    private int mpSeqNo;
    private String mpMemIndex;
    protected String ud;
    protected String udh;
    protected String smscNumber;
    private boolean endsWithMultiChar;

    public InboundMessage(Date date, String myOriginator, String text, int myMemIndex, String myMemLocation) {
        super(Message.MessageTypes.INBOUND, date, text);
        this.setOriginator(myOriginator);
        this.setMemIndex(myMemIndex);
        this.setMemLocation(myMemLocation);
        this.setMpRefNo(0);
        this.setMpMaxNo(0);
        this.setMpSeqNo(0);
        this.setMpMemIndex(-1);
        this.setSmscNumber(null);
    }

    public InboundMessage(Message.MessageTypes type, int myMemIndex, String myMemLocation) {
        super(type, null, null);
        this.setOriginator("");
        this.setMemIndex(myMemIndex);
        this.setMemLocation(myMemLocation);
        this.setMpRefNo(0);
        this.setMpMaxNo(0);
        this.setMpSeqNo(0);
        this.setMpMemIndex(-1);
        this.setSmscNumber(null);
    }

    public InboundMessage(SmsDeliveryPdu pdu, int myMemIndex, String myMemLocation) {
        super(Message.MessageTypes.INBOUND, null, null);
        this.setMemIndex(myMemIndex);
        this.setMemLocation(myMemLocation);
        this.setMpRefNo(0);
        this.setMpMaxNo(0);
        this.setMpSeqNo(0);
        this.setMpMemIndex(-1);
        int dcsEncoding = PduUtils.extractDcsEncoding(pdu.getDataCodingScheme());
        switch (dcsEncoding) {
            case 0: {
                this.setEncoding(Message.MessageEncodings.ENC7BIT);
                break;
            }
            case 4: {
                this.setEncoding(Message.MessageEncodings.ENC8BIT);
                break;
            }
            case 8: {
                this.setEncoding(Message.MessageEncodings.ENCUCS2);
                break;
            }
            default: {
                throw new RuntimeException("Unknown encoding value: " + dcsEncoding);
            }
        }
        if ((pdu.getAddressType() & 0x50) == 80) {
            this.setOriginator(pdu.getAddress());
        } else if ((pdu.getAddressType() & 0x10) == 16) {
            this.setOriginator("+" + pdu.getAddress());
        } else {
            this.setOriginator(pdu.getAddress());
        }
        this.setDate(pdu.getTimestamp());
        this.setSmscNumber(pdu.getSmscAddress());
        this.extractData(pdu);
        if (pdu.isConcatMessage()) {
            this.setMpRefNo(pdu.getMpRefNo());
            this.setMpMaxNo(pdu.getMpMaxNo());
            this.setMpSeqNo(pdu.getMpSeqNo());
        }
        if (pdu.isPortedMessage()) {
            this.setDstPort(pdu.getDestPort());
            this.setSrcPort(pdu.getSrcPort());
        }
        if (pdu.hasTpUdhi()) {
            this.udh = PduUtils.bytesToPdu(pdu.getUDHData());
        }
        this.ud = PduUtils.bytesToPdu(pdu.getUserDataAsBytes());
        if (this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
            byte[] temp = PduUtils.encodedSeptetsToUnencodedSeptets(pdu.getUDData());
            if (temp.length == 0) {
                this.endsWithMultiChar = false;
            } else if (temp[temp.length - 1] == 27) {
                this.endsWithMultiChar = true;
            }
        }
    }

    public void setEndsWithMultiChar(boolean b) {
        this.endsWithMultiChar = b;
    }

    public boolean getEndsWithMultiChar() {
        return this.endsWithMultiChar;
    }

    public String getOriginator() {
        return this.originator;
    }

    void setOriginator(String myOriginator) {
        this.originator = myOriginator;
    }

    public int getMemIndex() {
        return this.memIndex;
    }

    public void setMemIndex(int myMemIndex) {
        this.memIndex = myMemIndex;
    }

    public String getMemLocation() {
        return this.memLocation;
    }

    public void setMemLocation(String myMemLocation) {
        this.memLocation = myMemLocation;
    }

    public int getMpMaxNo() {
        return this.mpMaxNo;
    }

    public void setMpMaxNo(int myMpMaxNo) {
        this.mpMaxNo = myMpMaxNo;
    }

    public String getMpMemIndex() {
        return this.mpMemIndex;
    }

    public void setMpMemIndex(int myMpMemIndex) {
        this.mpMemIndex = myMpMemIndex == -1 ? "" : this.mpMemIndex + (this.mpMemIndex.length() == 0 ? "" : ",") + myMpMemIndex;
    }

    public int getMpRefNo() {
        return this.mpRefNo;
    }

    public void setMpRefNo(int myMpRefNo) {
        this.mpRefNo = myMpRefNo;
    }

    public int getMpSeqNo() {
        return this.mpSeqNo;
    }

    public void setMpSeqNo(int myMpSeqNo) {
        this.mpSeqNo = myMpSeqNo;
    }

    public String toString() {
        String str = "\n";
        str = str + "===============================================================================";
        str = str + "\n";
        str = str + "<< " + this.getClass().getSimpleName() + " >>";
        str = str + "\n";
        str = str + "-------------------------------------------------------------------------------";
        str = str + "\n";
        str = str + " Gateway Id: " + this.getGatewayId();
        str = str + "\n";
        str = str + " Message UUID: " + this.getUuid();
        str = str + "\n";
        str = str + " Encoding: " + (this.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (this.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        str = str + "\n";
        str = str + " Date: " + this.getDate();
        str = str + "\n";
        str = str + " Dispatched via SMSC: " + this.getSmscNumber();
        str = str + "\n";
        if (this instanceof InboundBinaryMessage) {
            InboundBinaryMessage binaryMessage = (InboundBinaryMessage)this;
            if (binaryMessage.getDataBytes() != null) {
                String binaryString = PduUtils.bytesToPdu(binaryMessage.getDataBytes());
                str = str + " Binary: " + binaryString;
                str = str + "\n";
            } else {
                str = str + " Binary: null";
                str = str + "\n";
            }
            if (this instanceof InboundEncryptedMessage) {
                try {
                    InboundEncryptedMessage encryptedMessage = (InboundEncryptedMessage)this;
                    str = str + " Message is **encrypted**, decrypted text: " + encryptedMessage.getDecryptedText() + "\n";
                }
                catch (Exception e) {
                    str = str + " Could not decrypt message: " + e.getMessage() + "\n";
                }
            }
        } else {
            str = str + " Text: " + this.getText();
            str = str + "\n";
            try {
                str = str + " PDU data: " + this.getPduUserData();
                str = str + "\n";
            }
            catch (Exception e) {
                str = str + " PDU data: <cannot extract properly, udh present>";
                str = str + "\n";
            }
        }
        str = str + " Originator: " + this.originator;
        str = str + "\n";
        if (this instanceof StatusReportMessage) {
            str = str + " Original Recipient: " + ((StatusReportMessage)this).getRecipient();
            str = str + "\n";
            str = str + " Delivery Status: " + (Object)((Object)((StatusReportMessage)this).getStatus());
            str = str + "\n";
            str = str + " SMSC Ref No: " + ((StatusReportMessage)this).getRefNo();
            str = str + "\n";
            str = str + " Sent Date: " + ((StatusReportMessage)this).getSent();
            str = str + "\n";
            str = str + " Delivered Date: " + ((StatusReportMessage)this).getReceived();
            str = str + "\n";
        }
        str = str + " Memory Index: " + this.getMemIndex();
        str = str + "\n";
        str = str + " Multi-part Memory Index: " + this.getMpMemIndex();
        str = str + "\n";
        str = str + " Memory Location: " + this.getMemLocation();
        str = str + "\n";
        str = str + " Source / Destination Ports: " + this.getSrcPort() + " / " + this.getDstPort();
        str = str + "\n";
        str = str + "===============================================================================";
        str = str + "\n";
        return str;
    }

    protected void extractData(SmsDeliveryPdu pdu) {
        if (pdu.isBinary()) {
            throw new RuntimeException("Trying to apply a binary pdu to an InboundMessage");
        }
        this.setText(pdu.getDecodedText());
    }

    @Override
    public String getPduUserData() {
        if (this.udh != null && this.getEncoding() == Message.MessageEncodings.ENC7BIT) {
            throw new RuntimeException("getPduUserData() not supported for 7-bit messages with UDH");
        }
        return this.ud;
    }

    @Override
    public String getPduUserDataHeader() {
        return this.udh;
    }

    @Override
    public void addText(String s) throws UnsupportedEncodingException {
        super.addText(s);
        if (this.getEncoding() == Message.MessageEncodings.ENCUCS2) {
            this.ud = this.ud + PduUtils.bytesToPdu(s.getBytes("UTF-16BE"));
        }
    }

    public String getSmscNumber() {
        return this.smscNumber;
    }

    private void setSmscNumber(String mySmscNumber) {
        this.smscNumber = mySmscNumber;
    }

    public static enum MessageClasses {
        READ,
        UNREAD,
        ALL;

    }
}

