/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.AbstractBorder;

public class SVBorder
extends AbstractBorder {
    private Color northColor = null;
    private Color eastColor = null;
    private Color southColor = null;
    private Color westColor = null;
    private int northBorderType = 0;
    private int eastBorderType = 0;
    private int southBorderType = 0;
    private int westBorderType = 0;
    private boolean northBorder = false;
    private boolean eastBorder = false;
    private boolean southBorder = false;
    private boolean westBorder = false;
    private boolean selected = false;

    public void setBorder(Color northColor, Color eastColor, Color southColor, Color westColor, int northBorderType, int eastBorderType, int southBorderType, int westBorderType, boolean selected) {
        this.eastColor = eastColor;
        this.southColor = southColor;
        this.westColor = westColor;
        this.northBorderType = northBorderType;
        this.eastBorderType = eastBorderType;
        this.southBorderType = southBorderType;
        this.westBorderType = westBorderType;
        this.northBorder = northBorderType != 0;
        this.eastBorder = eastBorderType != 0;
        this.southBorder = southBorderType != 0;
        this.westBorder = westBorderType != 0;
        this.selected = selected;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        this.paintSelectedBorder(g, x, y, width, height);
        this.paintNormalBorders(g, x, y, width, height);
        this.paintDottedBorders(g, x, y, width, height);
        this.paintDashedBorders(g, x, y, width, height);
        this.paintDoubleBorders(g, x, y, width, height);
        this.paintDashDotDotBorders(g, x, y, width, height);
        g.setColor(oldColor);
    }

    private void paintSelectedBorder(Graphics g, int x, int y, int width, int height) {
        if (this.selected) {
            g.setColor(Color.black);
            g.drawRect(x, y, width - 1, height - 1);
            g.fillRect(x + width - 5, y + height - 5, 5, 5);
        }
    }

    private void paintNormalBorders(Graphics g, int x, int y, int width, int height) {
        int k;
        int thickness;
        if (this.northBorder && (this.northBorderType == 1 || this.northBorderType == 2 || this.northBorderType == 5)) {
            thickness = this.getThickness(this.northBorderType);
            g.setColor(this.northColor);
            for (k = 0; k < thickness; ++k) {
                g.drawLine(x, y + k, width, y + k);
            }
        }
        if (this.eastBorder && (this.eastBorderType == 1 || this.eastBorderType == 2 || this.eastBorderType == 5)) {
            thickness = this.getThickness(this.eastBorderType);
            g.setColor(this.eastColor);
            for (k = 0; k < thickness; ++k) {
                g.drawLine(width - k, y, width - k, height);
            }
        }
        if (this.southBorder && (this.southBorderType == 1 || this.southBorderType == 2 || this.southBorderType == 5)) {
            thickness = this.getThickness(this.southBorderType);
            g.setColor(this.southColor);
            for (k = 0; k < thickness; ++k) {
                g.drawLine(x, height - k, width, height - k);
            }
        }
        if (this.westBorder && (this.westBorderType == 1 || this.westBorderType == 2 || this.westBorderType == 5)) {
            thickness = this.getThickness(this.westBorderType);
            g.setColor(this.westColor);
            for (k = 0; k < thickness; ++k) {
                g.drawLine(x + k, y, x + k, height);
            }
        }
    }

    private void paintDottedBorders(Graphics g, int x, int y, int width, int height) {
        int yc;
        int xc;
        int k;
        int thickness;
        if (this.northBorder && this.northBorderType == 7) {
            thickness = this.getThickness(this.northBorderType);
            g.setColor(this.northColor);
            for (k = 0; k < thickness; ++k) {
                for (xc = x; xc < width; xc += 2) {
                    g.drawLine(xc, y + k, xc, y + k);
                }
            }
        }
        if (this.eastBorder && this.eastBorderType == 7) {
            thickness = this.getThickness(this.eastBorderType);
            ++thickness;
            g.setColor(this.eastColor);
            for (k = 0; k < thickness; ++k) {
                for (yc = y; yc < height; yc += 2) {
                    g.drawLine(width - k, yc, width - k, yc);
                }
            }
        }
        if (this.southBorder && this.southBorderType == 7) {
            thickness = this.getThickness(this.southBorderType);
            ++thickness;
            g.setColor(this.southColor);
            for (k = 0; k < thickness; ++k) {
                for (xc = x; xc < width; xc += 2) {
                    g.drawLine(xc, height - k, xc, height - k);
                }
            }
        }
        if (this.westBorder && this.westBorderType == 7) {
            thickness = this.getThickness(this.westBorderType);
            g.setColor(this.westColor);
            for (k = 0; k < thickness; ++k) {
                for (yc = y; yc < height; yc += 2) {
                    g.drawLine(x + k, yc, x + k, yc);
                }
            }
        }
    }

    private void paintDashedBorders(Graphics g, int x, int y, int width, int height) {
        int yc;
        int xc;
        int k;
        int dashlength;
        int thickness;
        if (this.northBorder && (this.northBorderType == 3 || this.northBorderType == 4)) {
            thickness = this.getThickness(this.northBorderType);
            dashlength = 1;
            if (this.northBorderType == 3) {
                dashlength = 2;
            }
            g.setColor(this.northColor);
            for (k = 0; k < thickness; ++k) {
                for (xc = x; xc < width; xc += 5) {
                    g.drawLine(xc, y + k, xc + dashlength, y + k);
                }
            }
        }
        if (this.eastBorder && (this.eastBorderType == 3 || this.eastBorderType == 4)) {
            thickness = this.getThickness(this.eastBorderType);
            ++thickness;
            dashlength = 1;
            if (this.eastBorderType == 3) {
                dashlength = 2;
            }
            g.setColor(this.eastColor);
            for (k = 0; k < thickness; ++k) {
                for (yc = y; yc < height; yc += 5) {
                    g.drawLine(width - k, yc, width - k, yc + dashlength);
                }
            }
        }
        if (this.southBorder && (this.southBorderType == 3 || this.southBorderType == 4)) {
            thickness = this.getThickness(this.southBorderType);
            ++thickness;
            dashlength = 1;
            if (this.southBorderType == 3) {
                dashlength = 2;
            }
            g.setColor(this.southColor);
            for (k = 0; k < thickness; ++k) {
                for (xc = x; xc < width; xc += 5) {
                    g.drawLine(xc, height - k, xc + dashlength, height - k);
                }
            }
        }
        if (this.westBorder && (this.westBorderType == 3 || this.westBorderType == 4)) {
            thickness = this.getThickness(this.westBorderType);
            dashlength = 1;
            if (this.westBorderType == 3) {
                dashlength = 2;
            }
            g.setColor(this.westColor);
            for (k = 0; k < thickness; ++k) {
                for (yc = y; yc < height; yc += 5) {
                    g.drawLine(x + k, yc, x + k, yc + dashlength);
                }
            }
        }
    }

    private void paintDoubleBorders(Graphics g, int x, int y, int width, int height) {
        int bottomy;
        int topy;
        int thickness;
        int rightx;
        int leftx;
        if (this.northBorder && this.northBorderType == 6) {
            g.setColor(this.northColor);
            leftx = x;
            rightx = width;
            if (this.westBorder) {
                leftx = x + 3;
            }
            if (this.eastBorder) {
                rightx = width - 3;
            }
            g.drawLine(x, y, width, y);
            g.drawLine(leftx, y + 2, rightx, y + 2);
        }
        if (this.eastBorder && this.eastBorderType == 6) {
            thickness = this.getThickness(this.eastBorderType);
            ++thickness;
            g.setColor(this.eastColor);
            topy = y;
            bottomy = height;
            if (this.northBorder) {
                topy = y + 3;
            }
            if (this.southBorder) {
                bottomy = height - 3;
            }
            g.drawLine(width - 1, y, width - 1, height);
            g.drawLine(width - 3, topy, width - 3, bottomy);
        }
        if (this.southBorder && this.southBorderType == 6) {
            g.setColor(this.southColor);
            leftx = y;
            rightx = width;
            if (this.westBorder) {
                leftx = x + 3;
            }
            if (this.eastBorder) {
                rightx = width - 3;
            }
            g.drawLine(x, height - 1, width, height - 1);
            g.drawLine(leftx, height - 3, rightx, height - 3);
        }
        if (this.westBorder && this.westBorderType == 6) {
            thickness = this.getThickness(this.westBorderType);
            g.setColor(this.westColor);
            topy = y;
            bottomy = height - 3;
            if (this.northBorder) {
                topy = y + 2;
            }
            if (this.southBorder) {
                bottomy = height - 3;
            }
            g.drawLine(x, y, x, height);
            g.drawLine(x + 2, topy, x + 2, bottomy);
        }
    }

    private void paintDashDotDotBorders(Graphics g, int x, int y, int width, int height) {
        int l;
        int thickness;
        if (this.northBorder && (this.northBorderType == 11 || this.northBorderType == 12)) {
            thickness = this.getThickness(this.northBorderType);
            g.setColor(this.northColor);
            for (l = x; l < width; l += this.drawDashDotDot(g, l, y, thickness, true, true)) {
            }
        }
        if (this.eastBorder && (this.eastBorderType == 11 || this.eastBorderType == 12)) {
            thickness = this.getThickness(this.eastBorderType);
            g.setColor(this.eastColor);
            for (l = y; l < height; l += this.drawDashDotDot(g, width - 1, l, thickness, false, false)) {
            }
        }
        if (this.southBorder && (this.southBorderType == 11 || this.southBorderType == 12)) {
            thickness = this.getThickness(this.southBorderType);
            g.setColor(this.southColor);
            for (l = x; l < width; l += this.drawDashDotDot(g, l, height - 1, thickness, true, false)) {
            }
        }
        if (this.westBorder && (this.westBorderType == 11 || this.westBorderType == 12)) {
            thickness = this.getThickness(this.westBorderType);
            g.setColor(this.westColor);
            for (l = y; l < height; l += this.drawDashDotDot(g, x, l, thickness, false, true)) {
            }
        }
    }

    private int drawDashDotDot(Graphics g, int x, int y, int thickness, boolean horizontal, boolean rightBottom) {
        for (int t = 0; t < thickness; ++t) {
            if (!rightBottom) {
                t = 0 - t;
            }
            if (horizontal) {
                g.drawLine(x, y + t, x + 5, y + t);
                g.drawLine(x + 8, y + t, x + 10, y + t);
                g.drawLine(x + 13, y + t, x + 15, y + t);
                continue;
            }
            g.drawLine(x + t, y, x + t, y + 5);
            g.drawLine(x + t, y + 8, x + t, y + 10);
            g.drawLine(x + t, y + 13, x + t, y + 15);
        }
        return 18;
    }

    private int getThickness(int thickness) {
        int retval = 1;
        switch (thickness) {
            case 1: {
                retval = 2;
                break;
            }
            case 2: {
                retval = 3;
                break;
            }
            case 5: {
                retval = 4;
                break;
            }
            case 3: {
                retval = 1;
                break;
            }
            case 11: {
                retval = 1;
                break;
            }
            case 12: {
                retval = 3;
                break;
            }
            case 4: {
                retval = 1;
                break;
            }
            default: {
                retval = 1;
            }
        }
        return retval;
    }
}

