/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.conversion.ConversionFileProcessor;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.TypeConverterCreator;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConversionFileProcessor
implements ConversionFileProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConversionFileProcessor.class);
    private FileManager fileManager;
    private TypeConverterCreator converterCreator;

    @Inject
    public void setFileManagerFactory(FileManagerFactory factory) {
        this.fileManager = factory.getFileManager();
    }

    @Inject
    public void setTypeConverterCreator(TypeConverterCreator converterCreator) {
        this.converterCreator = converterCreator;
    }

    @Override
    public void process(Map<String, Object> mapping, Class clazz, String converterFilename) {
        block14: {
            try {
                InputStream is = this.fileManager.loadFile(ClassLoaderUtil.getResource(converterFilename, clazz));
                if (is != null) {
                    Map.Entry<Object, Object> entry;
                    String key;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing conversion file [#0] for class [#1]", converterFilename, clazz);
                    }
                    Properties prop = new Properties();
                    prop.load(is);
                    Iterator<Map.Entry<Object, Object>> i$ = prop.entrySet().iterator();
                    while (i$.hasNext() && !mapping.containsKey(key = (String)(entry = i$.next()).getKey())) {
                        if (key.startsWith("KeyProperty_") || key.startsWith("CreateIfNull_")) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as String]", new String[0]);
                            }
                            mapping.put(key, entry.getValue());
                            continue;
                        }
                        if (!(key.startsWith("Element_") || key.startsWith("Key_") || key.startsWith("Collection_"))) {
                            TypeConverter _typeConverter = this.converterCreator.createTypeConverter((String)entry.getValue());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as TypeConverter " + _typeConverter + "]", new String[0]);
                            }
                            mapping.put(key, _typeConverter);
                            continue;
                        }
                        if (key.startsWith("Key_")) {
                            Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                            if (converterClass.isAssignableFrom(TypeConverter.class)) {
                                TypeConverter _typeConverter = this.converterCreator.createTypeConverter((String)entry.getValue());
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as TypeConverter " + _typeConverter + "]", new String[0]);
                                }
                                mapping.put(key, _typeConverter);
                                continue;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as Class " + converterClass + "]", new String[0]);
                            }
                            mapping.put(key, converterClass);
                            continue;
                        }
                        Class<?> _c = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\t" + key + ":" + entry.getValue() + "[treated as Class " + _c + "]", new String[0]);
                        }
                        mapping.put(key, _c);
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block14;
                LOG.error("Problem loading properties for #0", ex, clazz.getName());
            }
        }
    }
}

