/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.navigation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.sojo.core.reflect.Property;
import net.sf.sojo.core.reflect.ReflectionPropertyHelper;
import net.sf.sojo.navigation.PathAction;
import net.sf.sojo.navigation.PathExecuteException;
import net.sf.sojo.navigation.PathParser;

public class PathExecuter {
    public static void setNestedProperty(Object pvRootObject, String pvPath, Object pvValue) {
        Object lvRootObject = pvRootObject;
        PathAction[] lvAction = PathParser.parse(pvPath);
        int l = lvAction.length - 1;
        for (int i = 0; i < lvAction.length; ++i) {
            if (l == 0 && lvAction[i].getProperty() != null) {
                lvAction[i].setType(0);
                lvRootObject = PathExecuter.getNestedProperty(lvRootObject, lvAction[i]);
            } else if (i < l) {
                lvRootObject = PathExecuter.getNestedProperty(lvRootObject, lvAction[i]);
            }
            if (i != l) continue;
            if (lvRootObject instanceof Collection || lvRootObject.getClass().isArray()) {
                lvAction[i].setType(1);
            } else if (lvRootObject instanceof Map) {
                lvAction[i].setType(2);
            }
            PathExecuter.setNestedProperty(lvRootObject, lvAction[i], pvValue);
        }
    }

    public static void setNestedProperty(Object pvRootObject, PathAction pvPathAction, Object pvValue) {
        switch (pvPathAction.getType()) {
            case 0: {
                PathExecuter.setSimpleProperty(pvRootObject, pvPathAction.getPath(), pvValue);
                break;
            }
            case 1: {
                PathExecuter.setIndexProperty(pvRootObject, pvPathAction.getIndex(), pvValue);
                break;
            }
            case 2: {
                PathExecuter.setKeyProperty(pvRootObject, pvPathAction.getKey(), pvValue);
                break;
            }
            default: {
                throw new PathExecuteException("Invalide action type: " + pvPathAction.getType());
            }
        }
    }

    public static Object getNestedProperty(Object pvRootObject, String pvPath) {
        Object lvResult = pvRootObject;
        PathAction[] lvAction = PathParser.parse(pvPath);
        for (int i = 0; i < lvAction.length; ++i) {
            lvResult = PathExecuter.getNestedProperty(lvResult, lvAction[i]);
        }
        return lvResult;
    }

    public static Object getNestedProperty(Object pvRootObject, PathAction pvPathAction) {
        Object lvReturn = null;
        Object lvRootObject = pvRootObject;
        switch (pvPathAction.getType()) {
            case 0: {
                lvReturn = PathExecuter.getSimpleProperty(lvRootObject, pvPathAction.getProperty());
                break;
            }
            case 1: {
                if (pvPathAction.getProperty() != null) {
                    lvRootObject = PathExecuter.getSimpleProperty(lvRootObject, pvPathAction.getProperty());
                }
                lvReturn = PathExecuter.getIndexProperty(lvRootObject, pvPathAction.getIndex());
                break;
            }
            case 2: {
                if (pvPathAction.getProperty() != null) {
                    lvRootObject = PathExecuter.getSimpleProperty(lvRootObject, pvPathAction.getProperty());
                }
                lvReturn = PathExecuter.getKeyProperty(lvRootObject, pvPathAction.getKey());
                break;
            }
            default: {
                throw new PathExecuteException("Invalide action type: " + pvPathAction.getType());
            }
        }
        return lvReturn;
    }

    public static Object getSimpleProperty(Object pvRootObject, String pvPath) {
        Object lvReturn = null;
        if (pvPath == null) {
            throw new PathExecuteException("The property-path must be different from null.");
        }
        if (pvPath.length() == 0) {
            return pvRootObject;
        }
        if (pvPath.equals("class")) {
            return pvRootObject.getClass();
        }
        if (pvRootObject instanceof Map) {
            lvReturn = ((Map)pvRootObject).get(pvPath);
        } else {
            Map<?, ?> lvAllGetterMethod = ReflectionPropertyHelper.getAllGetterProperties(pvRootObject.getClass(), null);
            AccessibleObject lvAccessibleObject = (AccessibleObject)lvAllGetterMethod.get(pvPath);
            if (lvAccessibleObject == null) {
                throw new PathExecuteException("No such method find for path: " + pvPath + " and class: " + pvRootObject.getClass().getName());
            }
            try {
                lvReturn = new Property(lvAccessibleObject).executeGetValue(pvRootObject);
            }
            catch (Exception e) {
                throw new PathExecuteException("Can't execute property " + lvAccessibleObject + " for path: " + pvPath, e);
            }
        }
        return lvReturn;
    }

    public static void setSimpleProperty(Object pvRootObject, String pvPath, Object pvValue) {
        if (pvPath == null) {
            throw new PathExecuteException("The property-path must be different from null.");
        }
        if (pvPath.length() > 0) {
            if (pvRootObject instanceof Map) {
                ((Map)pvRootObject).put(pvPath, pvValue);
            } else {
                Map<?, ?> lvAllSetterMethod = ReflectionPropertyHelper.getAllSetterProperties(pvRootObject.getClass(), null);
                AccessibleObject lvAccessibleObject = (AccessibleObject)lvAllSetterMethod.get(pvPath);
                if (lvAccessibleObject == null) {
                    throw new PathExecuteException("No such method find for path: " + pvPath + " and class: " + pvRootObject.getClass().getName());
                }
                try {
                    new Property(lvAccessibleObject).executeSetValue(pvRootObject, pvValue);
                }
                catch (Exception e) {
                    throw new PathExecuteException("Can't execute property " + lvAccessibleObject + " for path: " + pvPath, e);
                }
            }
        }
    }

    public static Object getIndexProperty(Object pvRootObject, int pvIndex) {
        Object lvReturn = null;
        if (pvIndex < 0) {
            lvReturn = pvRootObject;
        } else if (pvRootObject instanceof List) {
            lvReturn = ((List)pvRootObject).get(pvIndex);
        } else if (pvRootObject instanceof Collection) {
            Collection lvColl = (Collection)pvRootObject;
            Iterator lvIterator = lvColl.iterator();
            int lvConter = 0;
            while (lvIterator.hasNext()) {
                Object lvObject = lvIterator.next();
                if (lvConter == pvIndex) {
                    lvReturn = lvObject;
                    break;
                }
                ++lvConter;
            }
        } else if (pvRootObject.getClass().isArray()) {
            lvReturn = ((Object[])pvRootObject)[pvIndex];
        } else {
            throw new PathExecuteException("The object must be a Collection: " + pvRootObject);
        }
        return lvReturn;
    }

    public static void setIndexProperty(Object pvRootObject, Object pvValue) {
        PathExecuter.setIndexProperty(pvRootObject, -1, pvValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setIndexProperty(Object pvRootObject, int pvIndex, Object pvValue) {
        if (pvRootObject instanceof List) {
            if (pvIndex >= 0) {
                ((List)pvRootObject).add(pvIndex, pvValue);
                return;
            } else {
                ((List)pvRootObject).add(pvValue);
            }
            return;
        } else if (pvRootObject instanceof Collection) {
            ((Collection)pvRootObject).add(pvValue);
            return;
        } else {
            if (!pvRootObject.getClass().isArray()) throw new PathExecuteException("The object must be a Collection: " + pvRootObject);
            if (pvIndex < 0) throw new PathExecuteException("Can't set the value: " + pvValue + " by a array, without a valid index.");
            Array.set(pvRootObject, pvIndex, pvValue);
        }
    }

    public static Object getKeyProperty(Object pvRootObject, Object pvKey) {
        Object lvReturn = null;
        if (pvKey.toString().length() == 0) {
            lvReturn = pvRootObject;
        } else if (pvRootObject instanceof Map) {
            Map lvMap = (Map)pvRootObject;
            lvReturn = lvMap.get(pvKey);
            if (lvReturn == null) {
                lvReturn = PathExecuter.findKeyIfKeyIsNotStringType(lvMap, pvKey);
            }
        } else {
            throw new PathExecuteException("The object must be a Map: " + pvRootObject);
        }
        return lvReturn;
    }

    public static void setKeyProperty(Object pvRootObject, Object pvKey, Object pvValue) {
        if (!(pvRootObject instanceof Map)) {
            throw new PathExecuteException("The object must be a Map: " + pvRootObject);
        }
        ((Map)pvRootObject).put(pvKey, pvValue);
    }

    protected static Object findKeyIfKeyIsNotStringType(Map<?, ?> pvMap, Object pvKey) {
        for (Map.Entry<?, ?> lvEntry : pvMap.entrySet()) {
            if (!lvEntry.getKey().toString().equals(pvKey)) continue;
            return lvEntry.getValue();
        }
        return null;
    }
}

