/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.reflect;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sf.sojo.core.reflect.ClassPropertiesCache;
import net.sf.sojo.util.Util;

public final class ReflectionFieldHelper {
    private static final ClassPropertiesCache classFieldCache = new ClassPropertiesCache();

    public static Field[] getAllFieldsByClass(Class<?> pvClass) {
        Map<Object, Object> lvFieldMap = ReflectionFieldHelper.getAllFieldMapsByClassIntern(pvClass, null);
        return lvFieldMap.values().toArray(new Field[lvFieldMap.size()]);
    }

    public static Map<Object, Object> getAllGetFieldMapsByClass(Class<?> pvClass, String[] pvFilter) {
        TreeMap<Object, Object> lvFieldMap = new TreeMap<Object, Object>(ReflectionFieldHelper.getAllFieldMapsByClassIntern(pvClass, pvFilter));
        lvFieldMap.put(Util.getKeyWordClass(), pvClass.getName());
        return Collections.unmodifiableMap(lvFieldMap);
    }

    public static Map<Object, Object> getAllSetFieldMapsByClass(Class<?> pvClass, String[] pvFilter) {
        Map<Object, Object> lvFieldMap = ReflectionFieldHelper.getAllFieldMapsByClassIntern(pvClass, pvFilter);
        return Collections.unmodifiableMap(lvFieldMap);
    }

    private static Map<Object, Object> getAllFieldMapsByClassIntern(Class<?> pvClass, String[] pvFilter) {
        Map<Object, Object> lvFieldMap = classFieldCache.getClassPropertiesMapByClass(pvClass);
        if (lvFieldMap == null) {
            lvFieldMap = ReflectionFieldHelper.getAllFieldsByClassIntern(pvClass, new TreeMap<Object, Object>());
        }
        lvFieldMap = Util.filterMapByKeys(lvFieldMap, pvFilter);
        return lvFieldMap;
    }

    public static void addAllFields2MapByClass(Class<?> pvClass, String[] pvFilter) {
        if (!classFieldCache.containsClass(pvClass)) {
            Map<Object, Object> lvFieldMap = ReflectionFieldHelper.getAllSetFieldMapsByClass(pvClass, pvFilter);
            classFieldCache.addClassPropertiesMap(pvClass, lvFieldMap);
        }
    }

    public static void removePropertiesByClass(Class<?> pvClass) {
        classFieldCache.removePropertiesByClass(pvClass);
    }

    public static boolean containsClass(Class<?> pvClass) {
        return classFieldCache.containsClass(pvClass);
    }

    private static Map<Object, Object> getAllFieldsByClassIntern(Class<?> pvClass, Map<Object, Object> pvFieldsMap) {
        ReflectionFieldHelper.putAllFieldsIntern(pvClass.getFields(), pvFieldsMap);
        ReflectionFieldHelper.putAllFieldsIntern(pvClass.getDeclaredFields(), pvFieldsMap);
        if (!pvClass.getSuperclass().equals(Object.class)) {
            ReflectionFieldHelper.getAllFieldsByClassIntern(pvClass.getSuperclass(), pvFieldsMap);
        }
        return pvFieldsMap;
    }

    private static void putAllFieldsIntern(Field[] pvAllFields, Map<Object, Object> pvFieldsMap) {
        for (Field field : pvAllFields) {
            pvFieldsMap.put(field.getName(), field);
        }
    }
}

