/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core;

import java.util.Iterator;
import net.sf.sojo.core.AbstractConversion;
import net.sf.sojo.core.ConversionContext;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.IConverter;
import net.sf.sojo.core.IConverterExtension;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.filter.ClassPropertyFilterHelper;
import net.sf.sojo.util.CycleDetector;
import net.sf.sojo.util.Util;

public abstract class ConversionIterator
extends AbstractConversion {
    private boolean ignoreNullValues = false;
    private boolean withCycleDetection = false;
    protected CycleDetector cycleDetector = new CycleDetector();
    protected ClassPropertyFilterHandler classPropertyFilterHandler = null;

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean pvIgnoreNullValues) {
        this.ignoreNullValues = pvIgnoreNullValues;
    }

    public boolean getWithCycleDetection() {
        return this.withCycleDetection;
    }

    public void setWithCycleDetection(boolean pvWithCycleDetection) {
        this.withCycleDetection = pvWithCycleDetection;
    }

    public void setClassPropertyFilterHandler(ClassPropertyFilterHandler pvClassPropertyFilterHandler) {
        this.classPropertyFilterHandler = pvClassPropertyFilterHandler;
    }

    protected abstract Object[] doTransformIteratorObject2KeyValuePair(Object var1);

    protected abstract Object[] doConvert(Object var1, Object var2, Object var3, Object var4, IConverter var5);

    protected abstract void doAddObject(Object var1, Object var2, Object var3, Object var4, int var5);

    protected final Object iterate(Object pvSourceObject, Object pvNewTargetObject, Iterator<?> pvIterator, IConverterExtension pvConverter) {
        int pos = 0;
        if (this.getWithCycleDetection() && this.cycleDetector.cycleDetection(pvSourceObject)) {
            throw new ConversionException("Detec cycle in Collection.");
        }
        Iterator<?> iter = pvIterator;
        while (iter.hasNext()) {
            Object lvIteratorObject = iter.next();
            Object[] lvKeyValue = this.doTransformIteratorObject2KeyValuePair(lvIteratorObject);
            if (!ClassPropertyFilterHelper.isPropertyToFiltering(this.classPropertyFilterHandler, pvSourceObject.getClass(), lvKeyValue[0])) {
                String lvKey;
                Object o;
                Object lvValue;
                ConversionContext lvContext = this.fireBeforeConvertRecursion(pos + 1, lvKeyValue[0], lvKeyValue[1]);
                if (!lvContext.cancelConvert && (lvValue = (lvKeyValue = this.doConvert(pvSourceObject, pvNewTargetObject, lvContext.key, lvContext.value, pvConverter))[1]) != null && lvValue.toString() != null && lvValue.toString().startsWith("~unique-id~") && (o = pvConverter.getObjectByUniqueId(lvKey = lvValue.toString().substring("~unique-id~".length()))) != null) {
                    lvKeyValue[1] = o;
                }
                lvContext = this.fireAfterConvertRecursion(lvContext, lvKeyValue[0], lvKeyValue[1]);
                if (!lvContext.cancelConvert && (lvKeyValue[1] != null || !this.getIgnoreNullValues() || lvKeyValue[0] != null && lvKeyValue[0].equals(Util.getKeyWordClass()))) {
                    this.doAddObject(pvSourceObject, pvNewTargetObject, lvKeyValue[0], lvKeyValue[1], pos);
                }
            }
            ++pos;
        }
        return pvNewTargetObject;
    }

    private ConversionContext fireBeforeConvertRecursion(int pvNumberOfIteration, Object pvKey, Object pvValue) {
        ConversionContext lvContext = new ConversionContext(pvNumberOfIteration, pvKey, pvValue);
        this.getConverterInterceptorHandler().fireBeforeConvertRecursion(lvContext);
        return lvContext;
    }

    private ConversionContext fireAfterConvertRecursion(ConversionContext pvContext, Object pvKey, Object pvValue) {
        pvContext.key = pvKey;
        pvContext.value = pvValue;
        this.getConverterInterceptorHandler().fireAfterConvertRecursion(pvContext);
        return pvContext;
    }
}

