/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoRegion;
import com.supermap.data.Point2D;
import com.supermap.mapping.ChartObjectInfo;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerChartNative;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.Selection;
import java.util.ArrayList;

public class LayerChart
extends Layer {
    private DatasetGroup _$11;
    private ArrayList<Selection> _$10;
    private GeoRegion _$9 = null;
    private ChartObjectInfo[] _$8 = null;

    protected LayerChart(long l, Layers layers, Map map, DatasetGroup datasetGroup) {
        super(l, layers, map);
        this._$11 = datasetGroup;
        int n = LayerChartNative.jni_GetSubLayersCount(l);
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        LayerChartNative.jni_GetSubLayersAndDatasets(l, lArray, lArray2);
        this._$10 = new ArrayList();
        for (int i = 0; i < lArray2.length; ++i) {
            DatasetVector datasetVector = (DatasetVector)InternalToolkitMapping.toManageDataset(this.m_map.getWorkspace(), lArray2[i]);
            Layer layer = new Layer(lArray[i], this.m_layers, this.m_map);
            if (datasetVector == null || layer == null) continue;
            long l2 = LayerNative.jni_GetSelection(lArray[i]);
            Selection selection = new Selection(l2, layer);
            this._$10.add(selection);
        }
    }

    protected void clearHandle() {
        super.clearHandle();
        if (this._$8 != null) {
            for (ChartObjectInfo chartObjectInfo : this._$8) {
                if (chartObjectInfo == null) continue;
                chartObjectInfo.clearHandle();
            }
            this._$8 = null;
        }
        this.setHandle(0L);
    }

    public DatasetGroup getDatasetGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$11;
    }

    public Selection[] getSelections() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelections()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Selection[] selectionArray = new Selection[this._$10.size()];
        this._$10.toArray(selectionArray);
        return selectionArray;
    }

    public ChartObjectInfo[] getSelectionInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelectionInfos()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<ChartObjectInfo> arrayList = new ArrayList<ChartObjectInfo>();
        for (int i = 0; i < this._$10.size(); ++i) {
            if (this._$10.get(i) == null) continue;
            long[] lArray = LayerChartNative.jni_GetSelectionInfosBySelectionHandle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$10.get(i)));
            for (int j = 0; j < lArray.length; ++j) {
                ChartObjectInfo chartObjectInfo = ChartObjectInfo.createInstance(lArray[j], this._$10.get(i));
                arrayList.add(chartObjectInfo);
            }
        }
        if (this._$8 != null) {
            for (ChartObjectInfo chartObjectInfo : this._$8) {
                if (chartObjectInfo == null) continue;
                chartObjectInfo.clearHandle();
            }
            this._$8 = null;
        }
        if (this._$8 == null) {
            this._$8 = new ChartObjectInfo[arrayList.size()];
            arrayList.toArray(this._$8);
        }
        return this._$8;
    }

    public void clearSelections() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearSelections()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerChartNative.jni_ClearSelections(this.getHandle());
    }

    public boolean hitTestExtend(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTestExtend()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LayerChartNative.jni_HitTestExtend(this.getHandle(), point2D.getX(), point2D.getY(), d);
    }

    public void highlightObject(long l, int n, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("highlightObject()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerChartNative.jni_HighlightObject(this.getHandle(), l, n, bl);
        if (bl) {
            this.m_map.refresh();
        } else {
            this.m_map.refreshTrackingLayer();
        }
    }

    protected boolean deleteSubLayer(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteSubLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            return false;
        }
        boolean bl = true;
        bl = LayerChartNative.jni_DeleteSubLayer(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset));
        if (bl) {
            DatasetVector datasetVector = (DatasetVector)dataset;
            for (int i = 0; i < this._$10.size(); ++i) {
                if (datasetVector != this._$10.get(i).getDataset()) continue;
                this._$10.remove(i);
                break;
            }
        }
        return bl;
    }

    public void setAttributeModifiedFlag() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAttributeModifiedFlag()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerChartNative.jni_SetEditAttributeCompleted(this.getHandle(), true);
    }

    public GeoRegion getTextClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextClipRegion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 == null && (l = LayerChartNative.jni_GetTextClipRegion(this.getHandle())) != 0L) {
            this._$9 = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this._$9, false);
            if (this._$9.isEmpty()) {
                this._$9 = null;
            }
        }
        return this._$9;
    }

    public void setTextClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextClipRegion(GeoRegion region)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            LayerChartNative.jni_SetTextClipRegion(this.getHandle(), 0L);
            this._$9 = null;
        } else {
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            LayerChartNative.jni_SetTextClipRegion(this.getHandle(), l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
    }
}

