/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.JoinItem;
import com.supermap.data.JoinItemsNative;
import java.util.ArrayList;

public class JoinItems
extends InternalHandleDisposable {
    private ArrayList _$3 = null;

    public JoinItems() {
        this._$3 = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
    }

    public JoinItems(JoinItem[] joinItemArray) {
        if (joinItemArray == null) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this._$3 = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
        for (int i = 0; i < joinItemArray.length; ++i) {
            this.add(joinItemArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItemArray);
    }

    public JoinItems(JoinItems joinItems) {
        if (joinItems == null) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (joinItems.getHandle() == 0L) {
            String string = InternalResource.loadString("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = JoinItemsNative.jni_Clone(joinItems.getHandle());
        this._$3 = new ArrayList();
        this.setHandle(l, true);
        int n = joinItems.getCount();
        for (int i = 0; i < n; ++i) {
            this.add(joinItems.get(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItems);
    }

    JoinItems(long l) {
        this.setHandle(l, false);
        this._$3 = new ArrayList();
        int n = JoinItemsNative.jni_GetCount(this.getHandle());
        long[] lArray = new long[n];
        JoinItemsNative.jni_GetHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            this._$3.add(new JoinItem(lArray[i]));
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3.size();
    }

    public JoinItem get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (JoinItem)this._$3.get(n);
    }

    public void set(int n, JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        JoinItemsNative.jni_Set(this.get(n).getHandle(), joinItem.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(joinItem);
    }

    public JoinItems clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new JoinItems(this);
    }

    public int add(JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("joinItem", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = JoinItemsNative.jni_Add(this.getHandle(), joinItem.getHandle());
        if (l != 0L) {
            JoinItem joinItem2 = new JoinItem(l);
            this._$3.add(joinItem2);
            InternalHandleDisposable.makeSureNativeObjectLive(joinItem);
            return this.getCount() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItem);
        return -1;
    }

    public int addRange(JoinItem[] joinItemArray) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = 0;
        int n3 = joinItemArray.length;
        for (n = 0; n < n3; ++n) {
            JoinItem joinItem = joinItemArray[n];
            if (joinItem == null) {
                String string = InternalResource.loadString("joinItems[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("joinItems[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < n3; ++n) {
            this.add(joinItemArray[n]);
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItemArray);
        return n2;
    }

    public boolean insert(int n, JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, JoinItem joinItem)", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n == this.getCount()) {
            return this.add(joinItem) != -1;
        }
        long l = JoinItemsNative.jni_Insert(this.getHandle(), n, joinItem.getHandle());
        if (l == 0L) {
            return false;
        }
        JoinItem joinItem2 = new JoinItem(l);
        this._$3.add(n, joinItem2);
        InternalHandleDisposable.makeSureNativeObjectLive(joinItem);
        return true;
    }

    public int insertRange(int n, JoinItem[] joinItemArray) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = joinItemArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            JoinItem joinItem = joinItemArray[n2];
            if (joinItem == null) {
                String string = InternalResource.loadString("joinItems[" + n2 + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("joinItems[" + n2 + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            bl = this.insert(n + n2, joinItemArray[i]);
            if (!bl) continue;
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItemArray);
        return n2;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        JoinItemsNative.jni_Remove(this.getHandle(), n);
        JoinItem joinItem = this.get(n);
        joinItem.clearHandle();
        this._$3.remove(n);
        return true;
    }

    public int removeRange(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < 0 || n2 > this.getCount() - n) {
            String string = InternalResource.loadString("count", "JoinItems_RemoveRangeCountInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = n + n2 - 1; i >= n; --i) {
            try {
                bl = this.remove(i);
                if (!bl) continue;
                ++n3;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n3;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        for (int i = n - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public JoinItem[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$3.size();
        JoinItem[] joinItemArray = new JoinItem[n];
        for (int i = 0; i < n; ++i) {
            joinItemArray[i] = new JoinItem(this.get(i));
        }
        return joinItemArray;
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            JoinItemsNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this._$3 != null) {
            int n = this._$3.size();
            for (int i = 0; i < n; ++i) {
                JoinItem joinItem = this.get(i);
                joinItem.clearHandle();
            }
            this._$3.clear();
            this._$3 = null;
        }
        this.setHandle(0L);
    }
}

