/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoSphereNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoSphere
extends Geometry3D {
    public GeoSphere() {
        this.setHandle(GeoSphereNative.jni_New(), true);
        this.setRadius(1.0);
        this.setPosition(new Point3D(0.0, 0.0, 0.0));
    }

    public GeoSphere(GeoSphere geoSphere) {
        if (geoSphere == null) {
            String string = InternalResource.loadString("GeoSphere", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoSphere);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoSphere", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoSphereNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoSphere);
    }

    public GeoSphere(Point3D point3D, double d) {
        this();
        this.setPosition(point3D);
        this.setRadius(d);
    }

    GeoSphere(long l) {
        this.setHandle(l, false);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoSphereNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoSphereNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setRadius()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoSphereNative.jni_SetRadius(this.getHandle(), d);
    }

    public GeoSphere clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoSphere(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoSphereNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

