/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoMapGridLineType;
import com.supermap.data.GeoMapGridNative;
import com.supermap.data.GeoMapGridType;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.HorizontalTextPositionType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.TextStyle;
import com.supermap.data.VerticalTextPositionType;

public class GeoMapGrid
extends Geometry {
    private GeoStyle _$9;
    private GeoStyle _$8;
    private GeoStyle _$7;
    private GeoStyle _$6;
    private TextStyle _$5;

    public GeoMapGrid() {
        long l = GeoMapGridNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoMapGrid(GeoMapGrid geoMapGrid) {
        if (geoMapGrid == null) {
            String string = InternalResource.loadString("GeoMapGrid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMapGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoMapGrid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMapGridNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoMapGrid);
    }

    GeoMapGrid(long l) {
        this.setHandle(l, false);
    }

    public GeoMapGridType getGridType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetGridType(this.getHandle());
        return (GeoMapGridType)Enum.parseUGCValue(GeoMapGridType.class, n);
    }

    public void setGridType(GeoMapGridType geoMapGridType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridType(GeoMapGridType gridType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapGridType == null) {
            String string = InternalResource.loadString("gridType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoMapGridType.value();
        GeoMapGridNative.jni_SetGridType(this.getHandle(), n);
    }

    public double getVerticalGridDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalGridDistance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetVerticalGridDistance(this.getHandle());
    }

    public void setVerticalGridDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalGridDistance(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_VerticalDistanceShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getGridType() == GeoMapGridType.REFERENCEGRID) {
            String string = InternalResource.loadString("Type should not be REFERENCEGRID", "GeoMapGrid_TypeForbidden", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoMapGridNative.jni_SetVerticalGridDistance(this.getHandle(), d);
    }

    public double getHorizontalGridDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalGridDistance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetHorizontalGridDistance(this.getHandle());
    }

    public void setHorizontalGridDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalGridDistance(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_HorizontalDistanceShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getGridType() == GeoMapGridType.REFERENCEGRID) {
            String string = InternalResource.loadString("Type should not be REFERENCEGRID", "GeoMapGrid_TypeForbidden", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        GeoMapGridNative.jni_SetHorizontalGridDistance(this.getHandle(), d);
    }

    public GeoStyle getGridLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 == null && (l = GeoMapGridNative.jni_GetGridLineStyle(this.getHandle())) != 0L) {
            this._$9 = new GeoStyle(l);
        }
        return this._$9;
    }

    public void setGridLineStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineStyle(GeoStyle lineStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("lineStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("lineStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetGridLineStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public GeoStyle getBorderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBorderLineStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null && (l = GeoMapGridNative.jni_GetBorderLineStyle(this.getHandle())) != 0L) {
            this._$8 = new GeoStyle(l);
        }
        return this._$8;
    }

    public void setBorderLineStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderLineStyle(GeoStyle lineStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("lineStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("lineStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetBorderLineStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public GeoMapGridLineType getGridLineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetGridLineType(this.getHandle());
        return (GeoMapGridLineType)Enum.parseUGCValue(GeoMapGridLineType.class, n);
    }

    public void setGridLineType(GeoMapGridLineType geoMapGridLineType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineType(GeoMapGridLineType gridLineType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoMapGridLineType == null) {
            String string = InternalResource.loadString("GeoMapGridLineType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = geoMapGridLineType.value();
        GeoMapGridNative.jni_SetGridLineType(this.getHandle(), n);
    }

    public boolean isMajorDivisionTicksVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMajorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_IsMajorDivisionTicksVisible(this.getHandle());
    }

    public void setMajorDivisionTicksVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMajorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetMajorDivisionTicksVisible(this.getHandle(), bl);
    }

    public GeoStyle getMajorDivisionTicksStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMajorDivisionTicksStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null && (l = GeoMapGridNative.jni_GetMajorDivisionTicksStyle(this.getHandle())) != 0L) {
            this._$7 = new GeoStyle(l);
        }
        return this._$7;
    }

    public void setMajorDivisionTicksStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMajorDivisionTicksStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMajorDivisionTicksStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public boolean isMinorDivisionTicksVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isMinorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_IsMinorDivisionTicksVisible(this.getHandle());
    }

    public void setMinorDivisionTicksVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksVisible(this.getHandle(), bl);
    }

    public GeoStyle getMinorDivisionTicksStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinorDivisionTicksStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$6 == null && (l = GeoMapGridNative.jni_GetMinorDivisionTicksStyle(this.getHandle())) != 0L) {
            this._$6 = new GeoStyle(l);
        }
        return this._$6;
    }

    public void setMinorDivisionTicksStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksStyle(GeoStyle geoStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("geoStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoStyle);
    }

    public double getMinorDivisionTicksCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinorDivisionTicksCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMapGridNative.jni_GetMinorDivisionTicksCount(this.getHandle());
    }

    public void setMinorDivisionTicksCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinorDivisionTicksCount(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "GeoMapGrid_MinorDivisionTicksCountShouldNotBeNeagtive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetMinorDivisionTicksCount(this.getHandle(), n);
    }

    public HorizontalTextPositionType getHorizontalTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalTextPositionType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetHorizontalTextPositionType(this.getHandle());
        return (HorizontalTextPositionType)Enum.parseUGCValue(HorizontalTextPositionType.class, n);
    }

    public void setHorizontalTextPosition(HorizontalTextPositionType horizontalTextPositionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalTextPositionType(HorizontalTextPositionType positionType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (horizontalTextPositionType == null) {
            String string = InternalResource.loadString("positionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = horizontalTextPositionType.value();
        GeoMapGridNative.jni_SetHorizontalTextPositionType(this.getHandle(), n);
    }

    public VerticalTextPositionType getVerticalTextPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalTextPositionType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoMapGridNative.jni_GetVerticalTextPositionType(this.getHandle());
        return (VerticalTextPositionType)Enum.parseUGCValue(VerticalTextPositionType.class, n);
    }

    public void setVerticalTextPosition(VerticalTextPositionType verticalTextPositionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalTextPositionType(VerticalTextPositionType positionType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (verticalTextPositionType == null) {
            String string = InternalResource.loadString("positionType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = verticalTextPositionType.value();
        GeoMapGridNative.jni_SetVerticalTextPositionType(this.getHandle(), n);
    }

    public TextStyle getGridLineTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridLineTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = GeoMapGridNative.jni_GetGridLineTextStyle(this.getHandle())) != 0L) {
            this._$5 = new TextStyle(l);
        }
        return this._$5;
    }

    public void setGridLineTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGridLineTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoMapGridNative.jni_SetGridLineTextStyle(this.getHandle(), textStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    public GeoMapGrid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMapGrid(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMapGridNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this._$9 != null) {
            this._$9.clearHandle();
            this._$9 = null;
        }
        if (this._$8 != null) {
            this._$8.clearHandle();
            this._$8 = null;
        }
        if (this._$7 != null) {
            this._$7.clearHandle();
            this._$7 = null;
        }
        if (this._$6 != null) {
            this._$6.clearHandle();
            this._$6 = null;
        }
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        this.setHandle(0L);
    }
}

