/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CodeInfoNative;
import com.supermap.data.Enum;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;

public class CodeInfo
extends InternalHandleDisposable {
    public CodeInfo() {
        long l = CodeInfoNative.jni_New();
        this.setHandle(l, true);
    }

    protected CodeInfo(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, true);
    }

    public CodeInfo(FieldType fieldType, Object object, String string) {
        if (null == object || null == string || string.isEmpty()) {
            String string2 = InternalResource.loadString("codeinfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = 0L;
        String string3 = object.toString();
        if (fieldType.equals(FieldType.INT16)) {
            l = CodeInfoNative.jni_New1(Short.valueOf(string3), string);
        } else if (fieldType.equals(FieldType.INT32)) {
            l = CodeInfoNative.jni_New2(Integer.valueOf(string3), string);
        } else if (fieldType.equals(FieldType.INT64)) {
            l = CodeInfoNative.jni_New7(Long.valueOf(string3), string);
        } else if (fieldType.equals(FieldType.SINGLE)) {
            l = CodeInfoNative.jni_New3(Float.valueOf(string3).floatValue(), string);
        } else if (fieldType.equals(FieldType.DOUBLE)) {
            l = CodeInfoNative.jni_New4(Double.valueOf(string3), string);
        } else if (fieldType.equals(FieldType.TEXT)) {
            l = CodeInfoNative.jni_New6(String.valueOf(string3), string);
        } else if (fieldType.equals(FieldType.DATETIME)) {
            Serializable serializable;
            Date date = null;
            if (object instanceof String) {
                String string4;
                serializable = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                if (((Pattern)serializable).matcher(string4 = (String)object).matches()) {
                    String string5 = System.getProperty("os.name").toLowerCase();
                    if (string5.equals("aix")) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            date = simpleDateFormat.parse(string4);
                        }
                        catch (ParseException parseException) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                date = simpleDateFormat.parse(string4);
                            }
                            catch (ParseException parseException2) {}
                        }
                    } else {
                        try {
                            date = DateFormat.getDateInstance().parse(string4);
                        }
                        catch (ParseException parseException) {}
                    }
                }
            } else {
                date = (Date)object;
            }
            serializable = new GregorianCalendar(Locale.getDefault());
            ((Calendar)serializable).setTime(date);
            int n = ((Calendar)serializable).get(1);
            int n2 = ((Calendar)serializable).get(2) + 1;
            int n3 = ((Calendar)serializable).get(5);
            int n4 = ((Calendar)serializable).get(11);
            int n5 = ((Calendar)serializable).get(12);
            int n6 = ((Calendar)serializable).get(13);
            l = CodeInfoNative.jni_New5(n, n2, n3, n4, n5, n6, string);
        }
        this.setHandle(l, true);
    }

    public CodeInfo(CodeInfo codeInfo) {
        if (codeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("codeinfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = CodeInfoNative.jni_Clone(codeInfo.getHandle());
        this.setHandle(l, true);
    }

    public FieldType getValueType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = CodeInfoNative.jni_GetValueType(this.getHandle());
        return (FieldType)Enum.parseUGCValue(FieldType.class, n);
    }

    public void setValueType(FieldType fieldType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetValueType(this.getHandle(), fieldType.value());
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (null == string || string.isEmpty()) {
            String string2 = InternalResource.loadString("codeinfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        CodeInfoNative.jni_SetDescription(this.getHandle(), string);
    }

    public Object getValue() {
        FieldType fieldType = this.getValueType();
        if (fieldType.equals(FieldType.INT16)) {
            Short s = this.getInt16();
            return s;
        }
        if (fieldType.equals(FieldType.INT32)) {
            Integer n = this.getInt32();
            return n;
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f = Float.valueOf(this.getSingle());
            return f;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d = this.getDouble();
            return d;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime();
            return date;
        }
        if (fieldType.equals(FieldType.TEXT)) {
            String string = this.getString();
            return string;
        }
        return null;
    }

    public void setValue(Object object) {
        FieldType fieldType = this.getValueType();
        if (fieldType.equals(FieldType.INT16)) {
            this.setInt16(Short.valueOf(object.toString()));
        } else if (fieldType.equals(FieldType.INT32)) {
            this.setInt32(Integer.valueOf(object.toString()));
        } else if (fieldType.equals(FieldType.SINGLE)) {
            this.setSingle(Float.valueOf(object.toString()).floatValue());
        } else if (fieldType.equals(FieldType.DOUBLE)) {
            this.setDouble(Double.valueOf(object.toString()));
        } else if (fieldType.equals(FieldType.TEXT)) {
            this.setString(object.toString());
        } else if (fieldType.equals(FieldType.DATETIME)) {
            Date date = null;
            if (object instanceof String) {
                String string;
                Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                if (pattern.matcher(string = (String)object).matches()) {
                    String string2 = System.getProperty("os.name").toLowerCase();
                    if (string2.equals("aix")) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            date = simpleDateFormat.parse(string);
                        }
                        catch (ParseException parseException) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                date = simpleDateFormat.parse(string);
                            }
                            catch (ParseException parseException2) {}
                        }
                    } else {
                        try {
                            date = DateFormat.getDateInstance().parse(string);
                        }
                        catch (ParseException parseException) {}
                    }
                }
            } else {
                date = (Date)object;
            }
            this.setDateTime(date);
        }
    }

    public short getInt16() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetInt16(this.getHandle());
    }

    public int getInt32() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetInt32(this.getHandle());
    }

    public float getSingle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetSingle(this.getHandle());
    }

    public double getDouble() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetDouble(this.getHandle());
    }

    public Date getDateTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = CodeInfoNative.jni_GetDateTime(this.getHandle());
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                date = DateFormat.getDateTimeInstance().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public String getString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return CodeInfoNative.jni_GetString(this.getHandle());
    }

    public void setInt16(short s) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetInt16(this.getHandle(), s);
    }

    public void setInt32(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetInt32(this.getHandle(), n);
    }

    public void setSingle(float f) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetSingle(this.getHandle(), f);
    }

    public void setDouble(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        CodeInfoNative.jni_SetDouble(this.getHandle(), d);
    }

    public void setDateTime(Date date) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        CodeInfoNative.jni_SetDateTime(this.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public void setString(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("CodeInfo", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (null == string || string.isEmpty()) {
            String string3 = InternalResource.loadString("codeinfo", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        CodeInfoNative.jni_SetString(this.getHandle(), string);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CodeInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

