/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.impl;

import com.googlecode.ehcache.annotations.impl.CacheNameMatcher;
import com.googlecode.ehcache.annotations.impl.Vote;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpiredElementEvictor
extends TimerTask
implements InitializingBean,
DisposableBean {
    private static final long MILLIS_PER_MINUTE = 60000L;
    private CacheManager cacheManager;
    private List<CacheNameMatcher> cacheNameMatchers = new ArrayList<CacheNameMatcher>();
    private Timer timer;
    private long interval;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheNameMatchers(List<CacheNameMatcher> cacheNameMatchers) {
        this.cacheNameMatchers = cacheNameMatchers;
    }

    public void setInterval(int interval) {
        this.interval = (long)interval * 60000L;
    }

    public List<CacheNameMatcher> getCacheNameMatchers() {
        return this.cacheNameMatchers;
    }

    public int getInterval() {
        return (int)(this.interval / 60000L);
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        String[] cacheNames = this.cacheManager.getCacheNames();
        Set<String> evictableCacheNames = this.calculateEvictableCacheNames(cacheNames);
        long evictedTotal = 0L;
        for (String cacheName : evictableCacheNames) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (null != cache) {
                long preEvictSize = cache.getMemoryStoreSize();
                long evictStart = System.currentTimeMillis();
                cache.evictExpiredElements();
                if (!this.logger.isDebugEnabled()) continue;
                long evicted = preEvictSize - cache.getMemoryStoreSize();
                evictedTotal += evicted;
                this.logger.debug("Evicted " + evicted + " elements from cache '" + cacheName + "' in " + (System.currentTimeMillis() - evictStart) + " ms");
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("no cache found with name " + cacheName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Evicted " + evictedTotal + " elements from " + evictableCacheNames.size() + " caches  in " + (System.currentTimeMillis() - startTime) + " ms");
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.cacheManager) {
            throw new IllegalStateException("cacheManager reference must be set");
        }
        this.timer = new Timer(this.cacheManager.getName() + "expiredElementEvictorTimer", true);
        this.timer.schedule((TimerTask)this, this.interval, this.interval);
    }

    public void destroy() throws Exception {
        this.timer.cancel();
    }

    protected Set<String> calculateEvictableCacheNames(String[] cacheManagerCacheNames) {
        HashSet<String> result = new HashSet<String>();
        for (String cacheManagerCacheName : cacheManagerCacheNames) {
            Vote vote = null;
            for (CacheNameMatcher matcher : this.cacheNameMatchers) {
                vote = matcher.matches(cacheManagerCacheName);
                if (Vote.ABSTAIN.equals((Object)vote)) continue;
                if (Vote.YEA.equals((Object)vote)) {
                    result.add(cacheManagerCacheName);
                    continue;
                }
                result.remove(cacheManagerCacheName);
            }
        }
        return result;
    }
}

