/*
 * Decompiled with CFR 0.152.
 */
package com.liandi.sun.qrcode;

import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class QrcodeFactory {
    private static Qrcode qrcodeHandler = new Qrcode();
    private int IMG_WIDTH;
    private int IMG_HEIGHT;
    private int ICON_WIDTH;
    private int ICON_HEIGHT;

    static {
        qrcodeHandler.setQrcodeErrorCorrect('M');
        qrcodeHandler.setQrcodeEncodeMode('B');
        qrcodeHandler.setQrcodeVersion(7);
    }

    public QrcodeFactory(int imgWidth, int imgHeight) {
        this.IMG_WIDTH = imgWidth;
        this.IMG_HEIGHT = imgHeight;
    }

    public QrcodeFactory(int imgWidth, int imgHeight, int iconWidth, int iconHeight) {
        this.IMG_WIDTH = imgWidth;
        this.IMG_HEIGHT = imgHeight;
        this.ICON_WIDTH = iconWidth;
        this.ICON_HEIGHT = iconHeight;
    }

    public int createQrcode(String content, String imgPath) {
        Graphics2D gs;
        BufferedImage bufImg;
        block7: {
            try {
                byte[] contentBytes = content.getBytes("gb2312");
                bufImg = new BufferedImage(this.IMG_WIDTH, this.IMG_HEIGHT, 1);
                gs = bufImg.createGraphics();
                gs.setBackground(Color.WHITE);
                gs.clearRect(0, 0, 140, 140);
                gs.setColor(Color.BLACK);
                int pixoff = 2;
                if (contentBytes.length > 0 && contentBytes.length < 120) {
                    boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                    int i = 0;
                    while (i < codeOut.length) {
                        int j = 0;
                        while (j < codeOut.length) {
                            if (codeOut[j][i]) {
                                gs.fillRect(j * 3 + pixoff, i * 3 + pixoff, 3, 3);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block7;
                }
                System.err.println("QRCode content bytes length = " + contentBytes.length + " not in [ 0,120 ]. ");
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        gs.dispose();
        bufImg.flush();
        File imgFile = new File(imgPath);
        ImageIO.write((RenderedImage)bufImg, "png", imgFile);
        return 1;
    }

    public int createQrcode(String content, String imgPath, String iconPath) {
        Graphics2D gs;
        BufferedImage bufImg;
        block7: {
            try {
                byte[] contentBytes = content.getBytes("gb2312");
                bufImg = new BufferedImage(140, 140, 1);
                gs = bufImg.createGraphics();
                gs.setBackground(Color.WHITE);
                gs.clearRect(0, 0, this.IMG_WIDTH, this.IMG_HEIGHT);
                gs.setColor(Color.BLACK);
                int pixoff = 2;
                if (contentBytes.length > 0 && contentBytes.length < 120) {
                    boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
                    int i = 0;
                    while (i < codeOut.length) {
                        int j = 0;
                        while (j < codeOut.length) {
                            if (codeOut[j][i]) {
                                gs.fillRect(j * 3 + pixoff, i * 3 + pixoff, 3, 3);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block7;
                }
                System.err.println("QRCode content bytes length = " + contentBytes.length + " not in [ 0,120 ]. ");
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        BufferedImage iconImg = ImageIO.read(new File(iconPath));
        iconImg = QrcodeFactory.zoomImage(this.ICON_WIDTH, this.ICON_HEIGHT, iconImg);
        gs.drawImage((Image)iconImg, (this.IMG_WIDTH - this.ICON_WIDTH) / 2, (this.IMG_HEIGHT - this.ICON_HEIGHT) / 2, null);
        gs.dispose();
        bufImg.flush();
        File imgFile = new File(imgPath);
        ImageIO.write((RenderedImage)bufImg, "png", imgFile);
        return 1;
    }

    public static BufferedImage zoomImage(int x, int y, BufferedImage target) {
        Image scaleImage = target.getScaledInstance(x, y, 1);
        BufferedImage result = new BufferedImage(x, y, 1);
        Graphics2D g = result.createGraphics();
        g.drawImage(scaleImage, 0, 0, null);
        g.dispose();
        return result;
    }
}

