/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.local;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.TransactionController;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.transaction.AbstractTransactionStore;
import net.sf.ehcache.transaction.DeadLockException;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionAwareAttributeExtractor;
import net.sf.ehcache.transaction.TransactionException;
import net.sf.ehcache.transaction.TransactionInterruptedException;
import net.sf.ehcache.transaction.TransactionTimeoutException;
import net.sf.ehcache.transaction.local.LocalTransactionContext;
import net.sf.ehcache.transaction.local.TransactionListener;
import net.sf.ehcache.util.LargeSet;
import net.sf.ehcache.util.SetWrapperList;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransactionStore
extends AbstractTransactionStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)LocalTransactionStore.class.getName());
    private final TransactionController transactionController;
    private final SoftLockFactory softLockFactory;
    private final Ehcache cache;
    private final String cacheName;
    private final ElementValueComparator comparator;

    public LocalTransactionStore(TransactionController transactionController, SoftLockFactory softLockFactory, Ehcache cache, Store store, ReadWriteCopyStrategy<Element> copyStrategy) {
        super(store, copyStrategy);
        this.transactionController = transactionController;
        this.softLockFactory = softLockFactory;
        this.cache = cache;
        this.comparator = cache.getCacheConfiguration().getElementValueComparatorConfiguration().getElementComparatorInstance(cache.getCacheConfiguration());
        this.cacheName = cache.getName();
    }

    Ehcache getCache() {
        return this.cache;
    }

    private LocalTransactionContext getCurrentTransactionContext() {
        LocalTransactionContext currentTransactionContext = this.transactionController.getCurrentTransactionContext();
        if (currentTransactionContext == null) {
            throw new TransactionException("transaction not started");
        }
        return currentTransactionContext;
    }

    private void assertNotTimedOut(Object key, boolean wasPinned) {
        if (this.getCurrentTransactionContext().timedOut()) {
            if (!wasPinned) {
                this.underlyingStore.setPinned(key, false);
            }
            throw new TransactionTimeoutException("transaction [" + this.getCurrentTransactionContext().getTransactionId() + "] timed out");
        }
        if (Thread.interrupted()) {
            if (!wasPinned) {
                this.underlyingStore.setPinned(key, false);
            }
            throw new TransactionInterruptedException("transaction [" + this.getCurrentTransactionContext().getTransactionId() + "] interrupted");
        }
    }

    private void assertNotTimedOut() {
        this.assertNotTimedOut(null, true);
    }

    private long timeBeforeTimeout() {
        return Math.max(0L, this.getCurrentTransactionContext().getExpirationTimestamp() - System.currentTimeMillis());
    }

    private Element createElement(Object key, SoftLock softLock, boolean isPinned) {
        Element element = new Element(key, (Object)softLock);
        element.setEternal(true);
        if (!isPinned) {
            this.underlyingStore.setPinned(softLock.getKey(), true);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupExpiredSoftLock(Element oldElement, SoftLock softLock) {
        if (softLock.isExpired()) {
            softLock.lock();
            softLock.freeze();
            try {
                Element frozenElement = softLock.getFrozenElement();
                if (frozenElement != null) {
                    this.underlyingStore.replace(oldElement, frozenElement, this.comparator);
                } else {
                    this.underlyingStore.removeElement(oldElement, this.comparator);
                }
                if (!softLock.wasPinned()) {
                    this.underlyingStore.setPinned(softLock.getKey(), false);
                }
            }
            finally {
                softLock.unfreeze();
                softLock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean put(Element e) throws CacheException {
        if (e == null) {
            return true;
        }
        Element element = this.copyElementForWrite(e);
        Object key = element.getObjectKey();
        while (true) {
            SoftLock softLock;
            boolean isPinned = this.underlyingStore.isPinned(key);
            this.assertNotTimedOut(key, isPinned);
            Element oldElement = this.underlyingStore.getQuiet(key);
            if (oldElement == null) {
                SoftLock softLock2 = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, element, null, isPinned);
                softLock2.lock();
                Element newElement = this.createElement(key, softLock2, isPinned);
                oldElement = this.underlyingStore.putIfAbsent(newElement);
                if (oldElement == null) {
                    this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock2);
                    LOG.debug("put: cache [{}] key [{}] was not in, soft lock inserted", (Object)this.cacheName, key);
                    return true;
                }
                softLock2.unlock();
                LOG.debug("put: cache [{}] key [{}] was not in, soft lock insertion failed, retrying...", (Object)this.cacheName, key);
                continue;
            }
            Object value = oldElement.getObjectValue();
            if (value instanceof SoftLock) {
                softLock = (SoftLock)value;
                if (this.cleanupExpiredSoftLock(oldElement, softLock)) {
                    LOG.debug("put: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
                    continue;
                }
                if (softLock.getTransactionID().equals(this.getCurrentTransactionContext().getTransactionId())) {
                    softLock.updateElement(element);
                    this.underlyingStore.put(oldElement);
                    this.getCurrentTransactionContext().updateSoftLock(this.cacheName, softLock);
                    LOG.debug("put: cache [{}] key [{}] soft locked in current transaction, replaced old value with new one under soft lock", (Object)this.cacheName, key);
                    return false;
                }
                LOG.debug("put: cache [{}] key [{}] soft locked in foreign transaction, waiting {}ms for soft lock to die...", new Object[]{this.cacheName, key, this.timeBeforeTimeout()});
                try {
                    boolean locked = softLock.tryLock(this.timeBeforeTimeout());
                    if (!locked) {
                        LOG.debug("put: cache [{}] key [{}] soft locked in foreign transaction and not released before current transaction timeout", (Object)this.cacheName, key);
                        if (!this.getCurrentTransactionContext().hasLockedAnything()) continue;
                        throw new DeadLockException("deadlock detected in cache [" + this.cacheName + "] on key [" + key + "]" + " between current transaction [" + this.getCurrentTransactionContext().getTransactionId() + "]" + " and foreign transaction [" + softLock.getTransactionID() + "]");
                    }
                    softLock.clearTryLock();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                LOG.debug("put: cache [{}] key [{}] soft locked in foreign transaction, soft lock died, retrying...", (Object)this.cacheName, key);
                continue;
            }
            softLock = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, element, oldElement, isPinned);
            softLock.lock();
            Element newElement = this.createElement(key, softLock, isPinned);
            boolean replaced = this.underlyingStore.replace(oldElement, newElement, this.comparator);
            if (replaced) {
                this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock);
                LOG.debug("put: cache [{}] key [{}] was in, replaced with soft lock", (Object)this.cacheName, key);
                return false;
            }
            softLock.unlock();
            LOG.debug("put: cache [{}] key [{}] was in, replacement by soft lock failed, retrying... ", (Object)this.cacheName, key);
        }
    }

    @Override
    public Element getQuiet(Object key) {
        Element oldElement;
        block3: {
            SoftLock softLock;
            if (key == null) {
                return null;
            }
            while (true) {
                this.assertNotTimedOut();
                oldElement = this.underlyingStore.getQuiet(key);
                if (oldElement == null) {
                    LOG.debug("getQuiet: cache [{}] key [{}] is not present", (Object)this.cacheName, key);
                    return null;
                }
                Object value = oldElement.getObjectValue();
                if (!(value instanceof SoftLock)) break block3;
                softLock = (SoftLock)value;
                if (!this.cleanupExpiredSoftLock(oldElement, softLock)) break;
                LOG.debug("getQuiet: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
            }
            LOG.debug("getQuiet: cache [{}] key [{}] soft locked, returning soft locked element", (Object)this.cacheName, key);
            return this.copyElementForRead(softLock.getElement(this.getCurrentTransactionContext().getTransactionId()));
        }
        LOG.debug("getQuiet: cache [{}] key [{}] not soft locked, returning underlying element", (Object)this.cacheName, key);
        return this.copyElementForRead(oldElement);
    }

    @Override
    public Element get(Object key) {
        Element oldElement;
        block3: {
            SoftLock softLock;
            if (key == null) {
                return null;
            }
            while (true) {
                this.assertNotTimedOut();
                oldElement = this.underlyingStore.get(key);
                if (oldElement == null) {
                    LOG.debug("get: cache [{}] key [{}] is not present", (Object)this.cacheName, key);
                    return null;
                }
                Object value = oldElement.getObjectValue();
                if (!(value instanceof SoftLock)) break block3;
                softLock = (SoftLock)value;
                if (!this.cleanupExpiredSoftLock(oldElement, softLock)) break;
                LOG.debug("get: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
            }
            LOG.debug("get: cache [{}] key [{}] soft locked, returning soft locked element", (Object)this.cacheName, key);
            return this.copyElementForRead(softLock.getElement(this.getCurrentTransactionContext().getTransactionId()));
        }
        LOG.debug("get: cache [{}] key [{}] not soft locked, returning underlying element", (Object)this.cacheName, key);
        return this.copyElementForRead(oldElement);
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        while (true) {
            SoftLock softLock;
            boolean isPinned = this.underlyingStore.isPinned(key);
            this.assertNotTimedOut(key, isPinned);
            Element oldElement = this.underlyingStore.getQuiet(key);
            if (oldElement == null) {
                SoftLock softLock2 = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, null, null, isPinned);
                softLock2.lock();
                Element newElement = this.createElement(key, softLock2, isPinned);
                oldElement = this.underlyingStore.putIfAbsent(newElement);
                if (oldElement == null) {
                    this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock2);
                    LOG.debug("remove: cache [{}] key [{}] was not in, soft lock inserted", (Object)this.cacheName, key);
                    return null;
                }
                softLock2.unlock();
                LOG.debug("remove: cache [{}] key [{}] was not in, soft lock insertion failed, retrying...", (Object)this.cacheName, key);
                continue;
            }
            Object value = oldElement.getObjectValue();
            if (value instanceof SoftLock) {
                softLock = (SoftLock)value;
                if (this.cleanupExpiredSoftLock(oldElement, softLock)) {
                    LOG.debug("remove: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
                    continue;
                }
                if (softLock.getTransactionID().equals(this.getCurrentTransactionContext().getTransactionId())) {
                    Element removed = softLock.updateElement(null);
                    this.underlyingStore.put(oldElement);
                    this.getCurrentTransactionContext().updateSoftLock(this.cacheName, softLock);
                    LOG.debug("remove: cache [{}] key [{}] soft locked in current transaction, replaced old value with new one under soft lock", (Object)this.cacheName, key);
                    return this.copyElementForRead(removed);
                }
                try {
                    LOG.debug("remove: cache [{}] key [{}] soft locked in foreign transaction, waiting {}ms for soft lock to die...", new Object[]{this.cacheName, key, this.timeBeforeTimeout()});
                    boolean locked = softLock.tryLock(this.timeBeforeTimeout());
                    if (!locked) {
                        LOG.debug("remove: cache [{}] key [{}] soft locked in foreign transaction and not released before current transaction timeout", (Object)this.cacheName, key);
                        if (!this.getCurrentTransactionContext().hasLockedAnything()) continue;
                        throw new DeadLockException("deadlock detected in cache [" + this.cacheName + "] on key [" + key + "]" + " between current transaction [" + this.getCurrentTransactionContext().getTransactionId() + "]" + " and foreign transaction [" + softLock.getTransactionID() + "]");
                    }
                    softLock.clearTryLock();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                LOG.debug("remove: cache [{}] key [{}] soft locked in foreign transaction, soft lock died, retrying...", (Object)this.cacheName, key);
                continue;
            }
            softLock = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, null, oldElement, isPinned);
            softLock.lock();
            Element newElement = this.createElement(key, softLock, isPinned);
            boolean replaced = this.underlyingStore.replace(oldElement, newElement, this.comparator);
            if (replaced) {
                this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock);
                LOG.debug("remove: cache [{}] key [{}] was in, replaced with soft lock", (Object)this.cacheName, key);
                return this.copyElementForRead(oldElement);
            }
            softLock.unlock();
            LOG.debug("remove: cache [{}] key [{}] was in, replacement by soft lock failed, retrying...", (Object)this.cacheName, key);
        }
    }

    @Override
    public List getKeys() {
        this.assertNotTimedOut();
        LargeSet<Object> keys = new LargeSet<Object>(){

            @Override
            public int sourceSize() {
                return LocalTransactionStore.this.underlyingStore.getSize();
            }

            @Override
            public Iterator<Object> sourceIterator() {
                Iterator<Object> iterator = LocalTransactionStore.this.underlyingStore.getKeys().iterator();
                return iterator;
            }
        };
        keys.removeAll(this.softLockFactory.getKeysInvisibleInContext(this.getCurrentTransactionContext()));
        return new SetWrapperList(keys);
    }

    @Override
    public int getSize() {
        this.assertNotTimedOut();
        int sizeModifier = 0;
        return this.underlyingStore.getSize() + (sizeModifier -= this.softLockFactory.getKeysInvisibleInContext(this.getCurrentTransactionContext()).size());
    }

    @Override
    public int getTerracottaClusteredSize() {
        if (this.transactionController.getCurrentTransactionContext() == null) {
            return this.underlyingStore.getTerracottaClusteredSize();
        }
        int sizeModifier = 0;
        return this.underlyingStore.getTerracottaClusteredSize() + (sizeModifier -= this.softLockFactory.getKeysInvisibleInContext(this.getCurrentTransactionContext()).size());
    }

    @Override
    public boolean containsKey(Object key) {
        this.assertNotTimedOut();
        return this.getKeys().contains(key);
    }

    @Override
    public void removeAll() throws CacheException {
        this.assertNotTimedOut();
        List keys = this.getKeys();
        for (Object key : keys) {
            this.remove(key);
        }
    }

    @Override
    public boolean putWithWriter(final Element element, final CacheWriterManager writerManager) throws CacheException {
        if (element == null) {
            return true;
        }
        this.assertNotTimedOut();
        boolean put = this.put(element);
        this.getCurrentTransactionContext().addListener(new TransactionListener(){

            public void beforeCommit() {
                if (writerManager != null) {
                    writerManager.put(element);
                } else {
                    LocalTransactionStore.this.cache.getWriterManager().put(element);
                }
            }

            public void afterCommit() {
            }

            public void afterRollback() {
            }
        });
        return put;
    }

    @Override
    public Element removeWithWriter(Object key, final CacheWriterManager writerManager) throws CacheException {
        if (key == null) {
            return null;
        }
        this.assertNotTimedOut();
        Element removed = this.remove(key);
        final CacheEntry cacheEntry = new CacheEntry(key, this.getQuiet(key));
        this.getCurrentTransactionContext().addListener(new TransactionListener(){

            public void beforeCommit() {
                if (writerManager != null) {
                    writerManager.remove(cacheEntry);
                } else {
                    LocalTransactionStore.this.cache.getWriterManager().remove(cacheEntry);
                }
            }

            public void afterCommit() {
            }

            public void afterRollback() {
            }
        });
        return removed;
    }

    @Override
    public Element putIfAbsent(Element e) throws NullPointerException {
        if (e == null) {
            throw new NullPointerException("element cannot be null");
        }
        if (e.getObjectKey() == null) {
            throw new NullPointerException("element key cannot be null");
        }
        Element element = this.copyElementForWrite(e);
        Object key = element.getObjectKey();
        while (true) {
            SoftLock softLock;
            boolean isPinned = this.underlyingStore.isPinned(key);
            this.assertNotTimedOut(key, isPinned);
            Element oldElement = this.underlyingStore.getQuiet(key);
            if (oldElement == null || !(oldElement.getObjectValue() instanceof SoftLock)) {
                softLock = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, element, oldElement, isPinned);
                softLock.lock();
                Element newElement = this.createElement(key, softLock, isPinned);
                oldElement = this.underlyingStore.putIfAbsent(newElement);
                if (oldElement == null) {
                    this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock);
                    LOG.debug("putIfAbsent: cache [{}] key [{}] was not in, soft lock inserted", (Object)this.cacheName, key);
                    return null;
                }
                softLock.unlock();
                LOG.debug("putIfAbsent: cache [{}] key [{}] was not in, soft lock insertion failed", (Object)this.cacheName, key);
                Object oldElementObjectValue = oldElement.getObjectValue();
                if (oldElementObjectValue instanceof SoftLock) {
                    SoftLock oldElementSoftLock = (SoftLock)oldElementObjectValue;
                    return this.copyElementForRead(oldElementSoftLock.getElement(this.getCurrentTransactionContext().getTransactionId()));
                }
                return this.copyElementForRead(oldElement);
            }
            softLock = (SoftLock)oldElement.getObjectValue();
            if (this.cleanupExpiredSoftLock(oldElement, softLock)) {
                LOG.debug("putIfAbsent: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
                continue;
            }
            if (softLock.getTransactionID().equals(this.getCurrentTransactionContext().getTransactionId())) {
                Element currentElement = softLock.getElement(this.getCurrentTransactionContext().getTransactionId());
                if (currentElement == null) {
                    softLock.updateElement(element);
                    this.underlyingStore.put(oldElement);
                    this.getCurrentTransactionContext().updateSoftLock(this.cacheName, softLock);
                    LOG.debug("putIfAbsent: cache [{}] key [{}] soft locked in current transaction, replaced null with new element under soft lock", (Object)this.cacheName, key);
                    return null;
                }
                LOG.debug("putIfAbsent: cache [{}] key [{}] soft locked in current transaction, old element is not null", (Object)this.cacheName, key);
                return this.copyElementForRead(currentElement);
            }
            LOG.debug("putIfAbsent: cache [{}] key [{}] soft locked in foreign transaction, waiting {}ms for soft lock to die...", new Object[]{this.cacheName, key, this.timeBeforeTimeout()});
            try {
                boolean locked = softLock.tryLock(this.timeBeforeTimeout());
                if (!locked) {
                    LOG.debug("putIfAbsent: cache [{}] key [{}] soft locked in foreign transaction and not released before current transaction timeout", (Object)this.cacheName, key);
                    if (!this.getCurrentTransactionContext().hasLockedAnything()) continue;
                    throw new DeadLockException("deadlock detected in cache [" + this.cacheName + "] on key [" + key + "]" + " between current transaction [" + this.getCurrentTransactionContext().getTransactionId() + "]" + " and foreign transaction [" + softLock.getTransactionID() + "]");
                }
                softLock.clearTryLock();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            LOG.debug("putIfAbsent: cache [{}] key [{}] soft locked in foreign transaction, soft lock died, retrying...", (Object)this.cacheName, key);
        }
    }

    @Override
    public Element removeElement(Element e, ElementValueComparator comparator) throws NullPointerException {
        SoftLock softLock;
        Element oldElement;
        boolean isPinned;
        if (e == null) {
            throw new NullPointerException("element cannot be null");
        }
        if (e.getObjectKey() == null) {
            throw new NullPointerException("element key cannot be null");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator cannot be null");
        }
        Element element = this.copyElementForWrite(e);
        Object key = element.getObjectKey();
        while (true) {
            isPinned = this.underlyingStore.isPinned(key);
            this.assertNotTimedOut(key, isPinned);
            oldElement = this.underlyingStore.getQuiet(key);
            if (oldElement == null) {
                LOG.debug("removeElement: cache [{}] key [{}] was not in, nothing removed", (Object)this.cacheName, key);
                return null;
            }
            Object value = oldElement.getObjectValue();
            if (!(value instanceof SoftLock)) break;
            softLock = (SoftLock)value;
            if (this.cleanupExpiredSoftLock(oldElement, softLock)) {
                LOG.debug("removeElement: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
                continue;
            }
            if (softLock.getTransactionID().equals(this.getCurrentTransactionContext().getTransactionId())) {
                Element currentElement = softLock.getElement(this.getCurrentTransactionContext().getTransactionId());
                if (comparator.equals(element, currentElement)) {
                    Element removed = softLock.updateElement(null);
                    this.underlyingStore.put(oldElement);
                    this.getCurrentTransactionContext().updateSoftLock(this.cacheName, softLock);
                    LOG.debug("removeElement: cache [{}] key [{}] soft locked in current transaction, replaced old element with null under soft lock", (Object)this.cacheName, key);
                    return this.copyElementForRead(removed);
                }
                LOG.debug("removeElement: cache [{}] key [{}] soft locked in current transaction, old element did not match element to remove", (Object)this.cacheName, key);
                return null;
            }
            try {
                LOG.debug("removeElement: cache [{}] key [{}] soft locked in foreign transaction, waiting {}ms for soft lock to die...", new Object[]{this.cacheName, key, this.timeBeforeTimeout()});
                boolean locked = softLock.tryLock(this.timeBeforeTimeout());
                if (!locked) {
                    LOG.debug("removeElement: cache [{}] key [{}] soft locked in foreign transaction and not released before current transaction timeout", (Object)this.cacheName, key);
                    if (!this.getCurrentTransactionContext().hasLockedAnything()) continue;
                    throw new DeadLockException("deadlock detected in cache [" + this.cacheName + "] on key [" + key + "]" + " between current transaction [" + this.getCurrentTransactionContext().getTransactionId() + "]" + " and foreign transaction [" + softLock.getTransactionID() + "]");
                }
                softLock.clearTryLock();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            LOG.debug("removeElement: cache [{}] key [{}] soft locked in foreign transaction, soft lock died, retrying...", (Object)this.cacheName, key);
        }
        softLock = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, null, oldElement, isPinned);
        softLock.lock();
        Element newElement = this.createElement(key, softLock, isPinned);
        boolean replaced = this.underlyingStore.replace(oldElement, newElement, comparator);
        if (replaced) {
            this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock);
            LOG.debug("removeElement: cache [{}] key [{}] was in, replaced with soft lock", (Object)this.cacheName, key);
            return this.copyElementForRead(oldElement);
        }
        softLock.unlock();
        LOG.debug("removeElement: cache [{}] key [{}] was in, replacement by soft lock failed", (Object)this.cacheName, key);
        return null;
    }

    @Override
    public boolean replace(Element oe, Element ne, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        SoftLock softLock;
        Element oldElement;
        boolean isPinned;
        if (oe == null) {
            throw new NullPointerException("old cannot be null");
        }
        if (oe.getObjectKey() == null) {
            throw new NullPointerException("old key cannot be null");
        }
        if (ne == null) {
            throw new NullPointerException("element cannot be null");
        }
        if (ne.getObjectKey() == null) {
            throw new NullPointerException("element key cannot be null");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator cannot be null");
        }
        if (!oe.getKey().equals(ne.getKey())) {
            throw new IllegalArgumentException("old and element keys are not equal");
        }
        Element old = this.copyElementForWrite(oe);
        Element element = this.copyElementForWrite(ne);
        Object key = element.getObjectKey();
        while (true) {
            isPinned = this.underlyingStore.isPinned(key);
            this.assertNotTimedOut(key, isPinned);
            oldElement = this.underlyingStore.getQuiet(key);
            if (oldElement == null) {
                LOG.debug("replace: cache [{}] key [{}] was not in, nothing replaced", (Object)this.cacheName, key);
                return false;
            }
            Object value = oldElement.getObjectValue();
            if (!(value instanceof SoftLock)) break;
            softLock = (SoftLock)value;
            if (this.cleanupExpiredSoftLock(oldElement, softLock)) {
                LOG.debug("replace: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
                continue;
            }
            if (softLock.getTransactionID().equals(this.getCurrentTransactionContext().getTransactionId())) {
                Element currentElement = softLock.getElement(this.getCurrentTransactionContext().getTransactionId());
                if (comparator.equals(old, currentElement)) {
                    softLock.updateElement(element);
                    this.underlyingStore.put(oldElement);
                    this.getCurrentTransactionContext().updateSoftLock(this.cacheName, softLock);
                    LOG.debug("replace: cache [{}] key [{}] soft locked in current transaction, replaced old element with new one under soft lock", (Object)this.cacheName, key);
                    return true;
                }
                LOG.debug("replace: cache [{}] key [{}] soft locked in current transaction, old element did not match element to replace", (Object)this.cacheName, key);
                return false;
            }
            try {
                LOG.debug("replace: cache [{}] key [{}] soft locked in foreign transaction, waiting {}ms for soft lock to die...", new Object[]{this.cacheName, key, this.timeBeforeTimeout()});
                boolean locked = softLock.tryLock(this.timeBeforeTimeout());
                if (!locked) {
                    LOG.debug("replace: cache [{}] key [{}] soft locked in foreign transaction and not released before current transaction timeout", (Object)this.cacheName, key);
                    if (!this.getCurrentTransactionContext().hasLockedAnything()) continue;
                    throw new DeadLockException("deadlock detected in cache [" + this.cacheName + "] on key [" + key + "]" + " between current transaction [" + this.getCurrentTransactionContext().getTransactionId() + "]" + " and foreign transaction [" + softLock.getTransactionID() + "]");
                }
                softLock.clearTryLock();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            LOG.debug("replace: cache [{}] key [{}] soft locked in foreign transaction, soft lock died, retrying...", (Object)this.cacheName, key);
        }
        softLock = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, element, oldElement, isPinned);
        softLock.lock();
        Element newElement = this.createElement(key, softLock, isPinned);
        boolean replaced = this.underlyingStore.replace(oldElement, newElement, comparator);
        if (replaced) {
            this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock);
            LOG.debug("replace: cache [{}] key [{}] was in, replaced with soft lock", (Object)this.cacheName, key);
            return true;
        }
        softLock.unlock();
        LOG.debug("replace: cache [{}] key [{}] was in, replacement by soft lock failed", (Object)this.cacheName, key);
        return false;
    }

    @Override
    public Element replace(Element e) throws NullPointerException {
        SoftLock softLock;
        Element oldElement;
        boolean isPinned;
        if (e == null) {
            throw new NullPointerException("element cannot be null");
        }
        Element element = this.copyElementForWrite(e);
        Object key = element.getObjectKey();
        if (key == null) {
            throw new NullPointerException("element key cannot be null");
        }
        while (true) {
            isPinned = this.underlyingStore.isPinned(key);
            this.assertNotTimedOut(key, isPinned);
            oldElement = this.underlyingStore.getQuiet(key);
            if (oldElement == null) {
                LOG.debug("replace: cache [{}] key [{}] was not in, nothing replaced", (Object)this.cacheName, key);
                return null;
            }
            Object value = oldElement.getObjectValue();
            if (!(value instanceof SoftLock)) break;
            softLock = (SoftLock)value;
            if (this.cleanupExpiredSoftLock(oldElement, softLock)) {
                LOG.debug("replace: cache [{}] key [{}] guarded by expired soft lock, cleaned up {}", new Object[]{this.cacheName, key, softLock});
                continue;
            }
            if (softLock.getTransactionID().equals(this.getCurrentTransactionContext().getTransactionId())) {
                Element currentElement = softLock.getElement(this.getCurrentTransactionContext().getTransactionId());
                if (currentElement != null) {
                    Element replaced = softLock.updateElement(element);
                    this.underlyingStore.put(oldElement);
                    this.getCurrentTransactionContext().updateSoftLock(this.cacheName, softLock);
                    LOG.debug("replace: cache [{}] key [{}] soft locked in current transaction, replaced old element with new one under soft lock", (Object)this.cacheName, key);
                    return this.copyElementForRead(replaced);
                }
                LOG.debug("replace: cache [{}] key [{}] soft locked in current transaction, old element was null, not replaced", (Object)this.cacheName, key);
                return null;
            }
            try {
                LOG.debug("replace: cache [{}] key [{}] soft locked in foreign transaction, waiting {}ms for soft lock to die...", new Object[]{this.cacheName, key, this.timeBeforeTimeout()});
                boolean locked = softLock.tryLock(this.timeBeforeTimeout());
                if (!locked) {
                    LOG.debug("replace: cache [{}] key [{}] soft locked in foreign transaction and not released before current transaction timeout", (Object)this.cacheName, key);
                    if (!this.getCurrentTransactionContext().hasLockedAnything()) continue;
                    throw new DeadLockException("deadlock detected in cache [" + this.cacheName + "] on key [" + key + "]" + " between current transaction [" + this.getCurrentTransactionContext().getTransactionId() + "]" + " and foreign transaction [" + softLock.getTransactionID() + "]");
                }
                softLock.clearTryLock();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            LOG.debug("replace: cache [{}] key [{}] soft locked in foreign transaction, soft lock died, retrying...", (Object)this.cacheName, key);
        }
        softLock = this.softLockFactory.createSoftLock(this.getCurrentTransactionContext().getTransactionId(), key, element, oldElement, isPinned);
        softLock.lock();
        Element newElement = this.createElement(key, softLock, isPinned);
        Element replaced = this.underlyingStore.replace(newElement);
        if (replaced != null) {
            this.getCurrentTransactionContext().registerSoftLock(this.cacheName, this, softLock);
            LOG.debug("replace: cache [{}] key [{}] was in, replaced with soft lock", (Object)this.cacheName, key);
            return this.copyElementForRead(replaced);
        }
        softLock.unlock();
        LOG.debug("replace: cache [{}] key [{}] was in, replacement by soft lock failed", (Object)this.cacheName, key);
        return null;
    }

    void commit(List<SoftLock> softLocks) {
        LOG.debug("committing {} soft lock(s) in cache {}", (Object)softLocks.size(), (Object)this.cache.getName());
        for (SoftLock softLock : softLocks) {
            Element element = softLock.getFrozenElement();
            if (element != null) {
                this.underlyingStore.put(element);
            } else {
                this.underlyingStore.remove(softLock.getKey());
            }
            if (softLock.wasPinned()) continue;
            this.underlyingStore.setPinned(softLock.getKey(), false);
        }
    }

    void rollback(List<SoftLock> softLocks) {
        LOG.debug("rolling back {} soft lock(s) in cache {}", (Object)softLocks.size(), (Object)this.cache.getName());
        for (SoftLock softLock : softLocks) {
            Element element = softLock.getFrozenElement();
            if (element != null) {
                this.underlyingStore.put(element);
            } else {
                this.underlyingStore.remove(softLock.getKey());
            }
            if (softLock.wasPinned()) continue;
            this.underlyingStore.setPinned(softLock.getKey(), false);
        }
    }

    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        HashMap<String, AttributeExtractor> wrappedExtractors = new HashMap<String, AttributeExtractor>(extractors.size());
        for (Map.Entry<String, AttributeExtractor> e : extractors.entrySet()) {
            wrappedExtractors.put(e.getKey(), new TransactionAwareAttributeExtractor(this.copyStrategy, e.getValue()));
        }
        this.underlyingStore.setAttributeExtractors(wrappedExtractors);
    }
}

