/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;

public class Statistics
implements Serializable {
    public static final int STATISTICS_ACCURACY_NONE = 0;
    public static final int STATISTICS_ACCURACY_BEST_EFFORT = 1;
    public static final int STATISTICS_ACCURACY_GUARANTEED = 2;
    private static final long serialVersionUID = 3606940454221918725L;
    private transient Ehcache cache;
    private final String cacheName;
    private final int statisticsAccuracy;
    private final long cacheHits;
    private final long onDiskHits;
    private final long offHeapHits;
    private final long inMemoryHits;
    private final long misses;
    private final long onDiskMisses;
    private final long offHeapMisses;
    private final long inMemoryMisses;
    private final long size;
    private final long memoryStoreSize;
    private final long offHeapStoreSize;
    private final long diskStoreSize;
    private final float averageGetTime;
    private final long evictionCount;
    private final long searchesPerSecond;
    private final long averageSearchTime;
    private long writerQueueLength;

    public Statistics(Ehcache cache, int statisticsAccuracy, long cacheHits, long onDiskHits, long offHeapHits, long inMemoryHits, long misses, long onDiskMisses, long offHeapMisses, long inMemoryMisses, long size, float averageGetTime, long evictionCount, long memoryStoreSize, long offHeapStoreSize, long diskStoreSize, long searchesPerSecond, long averageSearchTime, long writerQueueLength) {
        this.cacheName = cache.getName();
        this.statisticsAccuracy = statisticsAccuracy;
        this.cacheHits = cacheHits;
        this.onDiskHits = onDiskHits;
        this.offHeapHits = offHeapHits;
        this.inMemoryHits = inMemoryHits;
        this.misses = misses;
        this.onDiskMisses = onDiskMisses;
        this.offHeapMisses = offHeapMisses;
        this.inMemoryMisses = inMemoryMisses;
        this.cache = cache;
        this.size = size;
        this.averageGetTime = averageGetTime;
        this.evictionCount = evictionCount;
        this.memoryStoreSize = memoryStoreSize;
        this.offHeapStoreSize = offHeapStoreSize;
        this.diskStoreSize = diskStoreSize;
        this.searchesPerSecond = searchesPerSecond;
        this.averageSearchTime = averageSearchTime;
        this.writerQueueLength = writerQueueLength;
    }

    public void clearStatistics() {
        if (this.cache == null) {
            throw new IllegalStateException("This statistics object no longer references a Cache.");
        }
        this.cache.clearStatistics();
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getInMemoryHits() {
        return this.inMemoryHits;
    }

    public long getOffHeapHits() {
        return this.offHeapHits;
    }

    public long getOnDiskHits() {
        return this.onDiskHits;
    }

    public long getCacheMisses() {
        return this.misses;
    }

    public long getInMemoryMisses() {
        return this.inMemoryMisses;
    }

    public long getOffHeapMisses() {
        return this.offHeapMisses;
    }

    public long getOnDiskMisses() {
        return this.onDiskMisses;
    }

    public long getObjectCount() {
        return this.size;
    }

    public long getMemoryStoreObjectCount() {
        return this.memoryStoreSize;
    }

    public long getOffHeapStoreObjectCount() {
        return this.offHeapStoreSize;
    }

    public long getDiskStoreObjectCount() {
        return this.diskStoreSize;
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public String getStatisticsAccuracyDescription() {
        if (this.statisticsAccuracy == 0) {
            return "None";
        }
        if (this.statisticsAccuracy == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }

    public String getAssociatedCacheName() {
        if (this.cache != null) {
            return this.cache.getName();
        }
        return this.cacheName;
    }

    public Ehcache getAssociatedCache() {
        if (this.cache != null) {
            return this.cache;
        }
        return null;
    }

    public final String toString() {
        StringBuilder dump = new StringBuilder();
        dump.append("[ ").append(" name = ").append(this.getAssociatedCacheName()).append(" cacheHits = ").append(this.cacheHits).append(" onDiskHits = ").append(this.onDiskHits).append(" offHeapHits = ").append(this.offHeapHits).append(" inMemoryHits = ").append(this.inMemoryHits).append(" misses = ").append(this.misses).append(" onDiskMisses = ").append(this.onDiskMisses).append(" offHeapMisses = ").append(this.offHeapMisses).append(" inMemoryMisses = ").append(this.inMemoryMisses).append(" size = ").append(this.size).append(" averageGetTime = ").append(this.averageGetTime).append(" evictionCount = ").append(this.evictionCount).append(" ]");
        return dump.toString();
    }

    public float getAverageGetTime() {
        return this.averageGetTime;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }

    public long getAverageSearchTime() {
        return this.averageSearchTime;
    }

    public long getSearchesPerSecond() {
        return this.searchesPerSecond;
    }

    public static boolean isValidStatisticsAccuracy(int statisticsAccuracy) {
        return statisticsAccuracy == 0 || statisticsAccuracy == 1 || statisticsAccuracy == 2;
    }

    public long getWriterQueueSize() {
        return this.writerQueueLength;
    }
}

