/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.common.api;

import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.RequestUtil;
import org.restlet.data.Form;

public abstract class AbstractPaginateList {
    public DataResponse paginateList(Form form, Query query, String defaultSort, Map<String, QueryProperty> properties) {
        String order;
        int start = RequestUtil.getInteger(form, "start", 0);
        int size = RequestUtil.getInteger(form, "size", 10);
        String sort = form.getValues("sort");
        if (sort == null) {
            sort = defaultSort;
        }
        if ((order = form.getValues("order")) == null) {
            order = "asc";
        }
        if (sort != null && properties.size() > 0) {
            QueryProperty qp = properties.get(sort);
            if (qp == null) {
                throw new ActivitiIllegalArgumentException("Value for param 'sort' is not valid, '" + sort + "' is not a valid property");
            }
            ((AbstractQuery)query).orderBy(qp);
            if (order.equals("asc")) {
                query.asc();
            } else if (order.equals("desc")) {
                query.desc();
            } else {
                throw new ActivitiIllegalArgumentException("Value for param 'order' is not valid : '" + order + "', must be 'asc' or 'desc'");
            }
        }
        List list = this.processList(query.listPage(start, size));
        DataResponse response = new DataResponse();
        response.setStart(start);
        response.setSize(list.size());
        response.setSort(sort);
        response.setOrder(order);
        response.setTotal(query.count());
        response.setData(list);
        return response;
    }

    protected abstract List processList(List var1);
}

