/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.child.TextAnnotationTextParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.TextAnnotation;
import org.apache.commons.lang3.StringUtils;

public class TextAnnotationXMLConverter
extends BaseBpmnXMLConverter {
    public TextAnnotationXMLConverter() {
        TextAnnotationTextParser annotationTextParser = new TextAnnotationTextParser();
        this.childElementParsers.put(annotationTextParser.getElementName(), annotationTextParser);
    }

    public static String getXMLType() {
        return "textAnnotation";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return TextAnnotation.class;
    }

    @Override
    protected String getXMLElementName() {
        return "textAnnotation";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        TextAnnotation textAnnotation = new TextAnnotation();
        BpmnXMLUtil.addXMLLocation((BaseElement)textAnnotation, xtr);
        textAnnotation.setTextFormat(xtr.getAttributeValue(null, "textFormat"));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)textAnnotation, xtr);
        return textAnnotation;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
        TextAnnotation textAnnotation = (TextAnnotation)element;
        this.writeDefaultAttribute("textFormat", textAnnotation.getTextFormat(), xtw);
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        TextAnnotation textAnnotation = (TextAnnotation)element;
        if (StringUtils.isNotEmpty((CharSequence)textAnnotation.getText())) {
            xtw.writeStartElement("text");
            xtw.writeCharacters(textAnnotation.getText());
            xtw.writeEndElement();
        }
    }
}

