/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.binding.expression.ExpressionVariable;
import org.springframework.binding.expression.ParserContext;

public class FluentParserContext
implements ParserContext {
    private Class evaluationContextType;
    private Class evaluationResultType;
    private List expressionVariables;
    private boolean template;

    public FluentParserContext() {
        this.init();
    }

    public Class getEvaluationContextType() {
        return this.evaluationContextType;
    }

    public Class getExpectedEvaluationResultType() {
        return this.evaluationResultType;
    }

    public ExpressionVariable[] getExpressionVariables() {
        return this.expressionVariables.toArray(new ExpressionVariable[this.expressionVariables.size()]);
    }

    public boolean isTemplate() {
        return this.template;
    }

    public FluentParserContext evaluate(Class contextType) {
        this.evaluationContextType = contextType;
        return this;
    }

    public FluentParserContext expectResult(Class resultType) {
        this.evaluationResultType = resultType;
        return this;
    }

    public FluentParserContext variable(ExpressionVariable variable) {
        this.expressionVariables.add(variable);
        return this;
    }

    public FluentParserContext variables(ExpressionVariable[] variables) {
        this.expressionVariables.addAll((Collection)Arrays.asList(variables));
        return this;
    }

    public FluentParserContext template() {
        this.template = true;
        return this;
    }

    private void init() {
        this.expressionVariables = new ArrayList();
    }
}

