/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Enum;
import com.supermap.realspace.FlyEventType;
import com.supermap.realspace.FlyManagerNative;
import com.supermap.realspace.FlyStatus;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.PropertiesChangedEvent;
import com.supermap.realspace.PropertiesChangedListener;
import com.supermap.realspace.Routes;
import com.supermap.realspace.Scene;
import com.supermap.realspace.StatusChangedEvent;
import com.supermap.realspace.StatusChangedListener;
import com.supermap.realspace.StopArrivedEvent;
import com.supermap.realspace.StopArrivedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Timer;

public class FlyManager
extends InternalHandleDisposable {
    transient Vector<StopArrivedListener> m_stopArrivedListeners;
    transient Vector<StatusChangedListener> m_statusChangedListener;
    transient Vector<PropertiesChangedListener> m_propertiesChangedListener;
    private Routes _$3;
    private Scene _$2;
    private Timer _$1;

    static void flyStatusChangedCallBack(FlyManager flyManager, int n, int n2) {
        if (flyManager.getHandle() == 0L) {
            String string = InternalResource.loadString("fly()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        StatusChangedEvent statusChangedEvent = new StatusChangedEvent((Object)flyManager, (FlyStatus)Enum.parse(FlyStatus.class, (int)n), (FlyStatus)Enum.parse(FlyStatus.class, (int)n2));
        flyManager.fireStatusChanged(statusChangedEvent);
    }

    public FlyManager() {
        long l = FlyManagerNative.jni_New();
        this.setHandle(l, true);
        this._$2();
    }

    protected FlyManager(long l) {
        this.setHandle(l, false);
        this._$2();
    }

    public void dispose() {
        this._$1.stop();
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FlyManagerNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    private void _$2() {
        this._$1 = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlyManager.this._$1();
            }
        });
        this._$3 = new Routes(this);
        FlyManagerNative.jni_NewSelfEventHandle(this.getHandle(), this);
    }

    public Routes getRoutes() {
        return this._$3;
    }

    public Scene getScene() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScene()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    public void setScene(Scene scene) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScene(Scene scene)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)scene) == 0L) {
            String string = InternalResource.loadString("the param has no handle!", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this._$2 = scene;
        FlyManagerNative.jni_SetScene(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)scene));
    }

    private void _$1() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fly()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n2 = FlyManagerNative.jni_GetNewArrivedStopIndex(this.getHandle());
        if (n2 != -1 && n2 < (n = this._$3.getCurrentRoute().getStops().getCount()) && n2 >= 0) {
            StopArrivedEvent stopArrivedEvent = new StopArrivedEvent((Object)this, this._$3.getCurrentRoute(), this._$3.getCurrentRoute().getStops().get(n2));
            this.fireStopArrived(stopArrivedEvent);
        }
    }

    public void play() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("play()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Play(this.getHandle());
        this._$1.start();
    }

    public void stop() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("stop()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Stop(this.getHandle());
        this._$1.stop();
    }

    public void pause() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pause()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Pause(this.getHandle());
        this._$1.stop();
    }

    public void update() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("update()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_Update(this.getHandle());
    }

    public double getDuration() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDuration()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetDuration(this.getHandle());
    }

    public void setDuration(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDuration(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetDuration(this.getHandle(), d);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public double getProgress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProgress()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetProgress(this.getHandle());
    }

    public void setProgress(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProgress(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetProgress(this.getHandle(), d);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public double getPlayRate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPlayRate()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetPlayRate(this.getHandle());
    }

    public void setPlayRate(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPlayRate(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetPlayRate(this.getHandle(), d);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public int getCurrentStopIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentStopIndex()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return FlyManagerNative.jni_GetCurrentStopIndex(this.getHandle());
    }

    public void setCurrentStopIndex(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentStopIndex(int value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        FlyManagerNative.jni_SetCurrentStopIndex(this.getHandle(), n);
        PropertiesChangedEvent propertiesChangedEvent = new PropertiesChangedEvent((Object)this, FlyEventType.FLYMANAGER_PROPERTIES_CHANGED);
        this.firePropertiesChanged(propertiesChangedEvent);
    }

    public FlyStatus getStatus() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFlyStatus()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = FlyManagerNative.jni_GetFlyStatus(this.getHandle());
        return (FlyStatus)Enum.parse(FlyStatus.class, (int)n);
    }

    protected void clearHandle() {
        this.setHandle(0L);
        this._$3.clearHandle();
    }

    public synchronized void addStopArrivedListener(StopArrivedListener stopArrivedListener) {
        if (this.m_stopArrivedListeners == null) {
            this.m_stopArrivedListeners = new Vector();
        }
        if (!this.m_stopArrivedListeners.contains(stopArrivedListener)) {
            this.m_stopArrivedListeners.add(stopArrivedListener);
        }
    }

    public synchronized void removeStopArrivedListener(StopArrivedListener stopArrivedListener) {
        if (this.m_stopArrivedListeners != null && this.m_stopArrivedListeners.contains(stopArrivedListener)) {
            this.m_stopArrivedListeners.remove(stopArrivedListener);
        }
    }

    protected void fireStopArrived(StopArrivedEvent stopArrivedEvent) {
        if (this.m_stopArrivedListeners != null) {
            Vector<StopArrivedListener> vector = this.m_stopArrivedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stopArrived(stopArrivedEvent);
            }
        }
    }

    public synchronized void addStatusChangedListener(StatusChangedListener statusChangedListener) {
        if (this.m_statusChangedListener == null) {
            this.m_statusChangedListener = new Vector();
        }
        if (!this.m_statusChangedListener.contains(statusChangedListener)) {
            this.m_statusChangedListener.add(statusChangedListener);
        }
    }

    public synchronized void removeStatusChangedListener(StatusChangedListener statusChangedListener) {
        if (this.m_statusChangedListener != null && this.m_statusChangedListener.contains(statusChangedListener)) {
            this.m_statusChangedListener.remove(statusChangedListener);
        }
    }

    protected void fireStatusChanged(StatusChangedEvent statusChangedEvent) {
        if (this.m_statusChangedListener != null) {
            Vector<StatusChangedListener> vector = this.m_statusChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).statusChanged(statusChangedEvent);
            }
        }
    }

    public synchronized void addPropertiesChangedListener(PropertiesChangedListener propertiesChangedListener) {
        if (this.m_propertiesChangedListener == null) {
            this.m_propertiesChangedListener = new Vector();
        }
        if (!this.m_propertiesChangedListener.contains(propertiesChangedListener)) {
            this.m_propertiesChangedListener.add(propertiesChangedListener);
        }
    }

    public synchronized void removePropertiesChangedListener(PropertiesChangedListener propertiesChangedListener) {
        if (this.m_propertiesChangedListener != null && this.m_propertiesChangedListener.contains(propertiesChangedListener)) {
            this.m_propertiesChangedListener.remove(propertiesChangedListener);
        }
    }

    protected void firePropertiesChanged(PropertiesChangedEvent propertiesChangedEvent) {
        if (this.m_propertiesChangedListener != null) {
            Vector<PropertiesChangedListener> vector = this.m_propertiesChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).propertiesChanged(propertiesChangedEvent);
            }
        }
    }
}

