/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.layout.InternalGeoStyle;
import com.supermap.layout.InternalHandleDisposable;
import com.supermap.layout.InternalResource;
import com.supermap.layout.SelectionNative;

public class LayoutSelection
extends com.supermap.data.InternalHandleDisposable {
    private GeoStyle _$1;

    public LayoutSelection() {
        long l = SelectionNative.jni_New();
        this.setHandle(l, true);
    }

    public LayoutSelection(LayoutSelection layoutSelection) {
        if (layoutSelection == null) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (layoutSelection.getHandle() == 0L) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = SelectionNative.jni_Clone(layoutSelection.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)layoutSelection));
    }

    LayoutSelection(long l) {
        this.setHandle(l, false);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return SelectionNative.jni_GetCount(this.getHandle());
    }

    public int get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_GetItem(this.getHandle(), n);
    }

    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 == null && (l = SelectionNative.jni_GetStyle(this.getHandle())) != 0L) {
            this._$1 = InternalGeoStyle.createInstance(l);
        }
        return this._$1;
    }

    public void setStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("geoStyle", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)geoStyle.clone());
        SelectionNative.jni_SetStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public int add(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(int geometryID)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("geometryID", "Selection_TheArgumentOfGeometryIDShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_Add(this.getHandle(), n);
    }

    public int addRange(int[] nArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange(int[] geometryIDs)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = InternalResource.loadString("geometryIDs", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] > 0) continue;
            String string = InternalResource.loadString("geometryIDs", "Selection_TheArgumentOfGeometryIDShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_AddRange(this.getHandle(), nArray);
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int geometryID)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n2 = SelectionNative.jni_IndexOf(this.getHandle(), n);
        if (n2 == -1) {
            String string = InternalResource.loadString("geometryID", "Selection_TheGeometryIDIsNotInSelection", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_Remove(this.getHandle(), n2);
    }

    public int removeRange(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (n + n2 < n || n + n2 > n3) {
            String string = InternalResource.loadString("count", "Selection_TheArgumentOfCountIsInvalid", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        return SelectionNative.jni_RemoveRange(this.getHandle(), n, n2);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        SelectionNative.jni_Clear(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "layout_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SelectionNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        if (this._$1 != null) {
            InternalGeoStyle.clearHandle(this._$1);
            this._$1 = null;
        }
        this.setHandle(0L);
    }
}

