/*
 * $Id: ExternalEntity.java,v 1.4 1999/04/16 20:24:01 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.parser;

import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;


class ExternalEntity extends EntityDecl
{
    String	systemId;	// resolved URI (not relative)
    String	publicId;	// "-//xyz//....//en"
    String	notation;
    
    public ExternalEntity (Locator l) { }
    
    public InputSource getInputSource (EntityResolver r)
    throws SAXException, IOException
    {
	InputSource	retval;
	
	retval = r.resolveEntity (publicId, systemId);
	// SAX sez if null is returned, use the URI directly
	if (retval == null)
	    retval = Resolver.createInputSource (new URL (systemId), false);
	return retval;
    }
}
