/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.test;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.TimeoutException;
import org.smslib.helper.Logger;
import org.smslib.notify.InboundMessageNotification;

public class TestGateway
extends AGateway {
    private int refCounter = 0;
    private int counter = 0;
    protected int failCycle;
    protected int receiveCycle;
    Thread incomingMessagesThread;

    public TestGateway(String id) {
        super(id);
        this.setAttributes(1);
        this.setInbound(true);
        this.setOutbound(true);
        this.setFailCycle(3000);
        this.receiveCycle = 60000;
    }

    @Override
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    InboundMessage generateIncomingMessage() {
        this.incInboundMessageCount();
        InboundMessage msg = new InboundMessage(new Date(), "+1234567890", "Hello World! #" + this.getInboundMessageCount(), 0, null);
        msg.setGatewayId(this.getGatewayId());
        return msg;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.startGateway();
        this.incomingMessagesThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!TestGateway.this.incomingMessagesThread.isInterrupted()) {
                    Thread thread = TestGateway.this.incomingMessagesThread;
                    synchronized (thread) {
                        try {
                            TestGateway.this.incomingMessagesThread.wait(TestGateway.this.receiveCycle);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    if (TestGateway.this.incomingMessagesThread.isInterrupted()) continue;
                    Logger.getInstance().logInfo("Detecting incoming message", null, TestGateway.this.getGatewayId());
                    Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(TestGateway.this.getMyself(), Message.MessageTypes.INBOUND, TestGateway.this.generateIncomingMessage()));
                }
            }
        }, "IncomingMessagesThread");
        this.incomingMessagesThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.stopGateway();
        if (this.incomingMessagesThread != null) {
            Thread thread = this.incomingMessagesThread;
            synchronized (thread) {
                this.incomingMessagesThread.interrupt();
            }
        }
    }

    @Override
    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ++this.counter;
        if (this.failCycle > 0 && this.counter >= this.failCycle) {
            this.counter = 0;
            throw new GatewayException("*** READ ERROR ***");
        }
        return this.generateIncomingMessage();
    }

    @Override
    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        msgList.add(this.generateIncomingMessage());
    }

    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Sending to: " + msg.getRecipient() + " via: " + msg.getGatewayId(), null, this.getGatewayId());
        ++this.counter;
        if (this.failCycle > 0 && this.counter >= this.failCycle) {
            this.counter = 0;
            if (!this.getGatewayId().equalsIgnoreCase("Test3")) {
                throw new IOException("Dummy Exception!!!");
            }
        }
        msg.setDispatchDate(new Date());
        msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        msg.setRefNo(Integer.toString(++this.refCounter));
        msg.setGatewayId(this.getGatewayId());
        Logger.getInstance().logInfo("Sent to: " + msg.getRecipient() + " via: " + msg.getGatewayId(), null, this.getGatewayId());
        this.incOutboundMessageCount();
        return true;
    }

    public int getFailCycle() {
        return this.failCycle;
    }

    public void setFailCycle(int myFailCycle) {
        this.failCycle = myFailCycle;
    }

    @Override
    public int getQueueSchedulingInterval() {
        return 200;
    }
}

