/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.terracotta.TerracottaClient;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.writer.writebehind.WriteBehind;

public class ClusteredInstanceFactoryWrapper
implements ClusteredInstanceFactory {
    private final TerracottaClient client;
    private final ClusteredInstanceFactory delegate;

    public ClusteredInstanceFactoryWrapper(TerracottaClient client, ClusteredInstanceFactory delegate) {
        this.client = client;
        this.delegate = delegate;
    }

    protected ClusteredInstanceFactory getActualFactory() {
        return this.delegate;
    }

    public CacheCluster getTopology() {
        this.client.waitUntilRejoinComplete();
        return this.client.getCacheCluster();
    }

    public String getUUID() {
        this.client.waitUntilRejoinComplete();
        return this.delegate.getUUID();
    }

    public CacheEventListener createEventReplicator(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createEventReplicator(cache);
    }

    public Store createStore(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createStore(cache);
    }

    public TransactionIDFactory createTransactionIDFactory(String uuid) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createTransactionIDFactory(uuid);
    }

    public WriteBehind createWriteBehind(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.createWriteBehind(cache);
    }

    public SoftLockFactory getOrCreateSoftLockFactory(Ehcache cache) {
        this.client.waitUntilRejoinComplete();
        return this.delegate.getOrCreateSoftLockFactory(cache);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }
}

