/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.data.jpa.util.Jpa21Utils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class SimpleJpaRepository<T, ID extends Serializable>
implements JpaRepository<T, ID>,
JpaSpecificationExecutor<T> {
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager em;
    private final PersistenceProvider provider;
    private CrudMethodMetadata metadata;

    public SimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        Assert.notNull(entityInformation);
        Assert.notNull((Object)entityManager);
        this.entityInformation = entityInformation;
        this.em = entityManager;
        this.provider = PersistenceProvider.fromEntityManager(entityManager);
    }

    public SimpleJpaRepository(Class<T> domainClass, EntityManager em) {
        this(JpaEntityInformationSupport.getMetadata(domainClass, em), em);
    }

    public void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.metadata = crudMethodMetadata;
    }

    protected CrudMethodMetadata getRepositoryMethodMetadata() {
        return this.metadata;
    }

    protected Class<T> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    private String getDeleteAllQueryString() {
        return QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName());
    }

    private String getCountQueryString() {
        String countQuery = String.format("select count(%s) from %s x", this.provider.getCountQueryPlaceholder(), "%s");
        return QueryUtils.getQueryString(countQuery, this.entityInformation.getEntityName());
    }

    @Transactional
    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        T entity = this.findOne(id);
        if (entity == null) {
            throw new EmptyResultDataAccessException(String.format("No %s entity with id %s exists!", this.entityInformation.getJavaType(), id), 1);
        }
        this.delete(entity);
    }

    @Transactional
    public void delete(T entity) {
        Assert.notNull(entity, (String)"The entity must not be null!");
        this.em.remove(this.em.contains(entity) ? entity : this.em.merge(entity));
    }

    @Transactional
    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    @Transactional
    public void deleteInBatch(Iterable<T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        if (!entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind(QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName()), entities, this.em).executeUpdate();
    }

    @Transactional
    public void deleteAll() {
        for (Object element : this.findAll()) {
            this.delete((T)element);
        }
    }

    @Override
    @Transactional
    public void deleteAllInBatch() {
        this.em.createQuery(this.getDeleteAllQueryString()).executeUpdate();
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        Class<T> domainType = this.getDomainClass();
        if (this.metadata == null) {
            return (T)this.em.find(domainType, id);
        }
        LockModeType type = this.metadata.getLockModeType();
        Map<String, Object> hints = this.metadata.getQueryHints();
        return (T)(type == null ? this.em.find(domainType, id, hints) : this.em.find(domainType, id, type, hints));
    }

    @Override
    public T getOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return (T)this.em.getReference(this.getDomainClass(), id);
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        if (this.entityInformation.getIdAttribute() == null) {
            return this.findOne(id) != null;
        }
        String placeholder = this.provider.getCountQueryPlaceholder();
        String entityName = this.entityInformation.getEntityName();
        Iterable<String> idAttributeNames = this.entityInformation.getIdAttributeNames();
        String existsQuery = QueryUtils.getExistsQueryString(entityName, placeholder, idAttributeNames);
        TypedQuery query = this.em.createQuery(existsQuery, Long.class);
        if (!this.entityInformation.hasCompositeId()) {
            query.setParameter(idAttributeNames.iterator().next(), id);
            return (Long)query.getSingleResult() == 1L;
        }
        for (String idAttributeName : idAttributeNames) {
            boolean complexIdParameterValueDiscovered;
            Object idAttributeValue = this.entityInformation.getCompositeIdAttributeValue((Serializable)id, idAttributeName);
            boolean bl = complexIdParameterValueDiscovered = idAttributeValue != null && !query.getParameter(idAttributeName).getParameterType().isAssignableFrom(idAttributeValue.getClass());
            if (complexIdParameterValueDiscovered) {
                return this.findOne(id) != null;
            }
            query.setParameter(idAttributeName, idAttributeValue);
        }
        return (Long)query.getSingleResult() == 1L;
    }

    @Override
    public List<T> findAll() {
        return this.getQuery(null, (Sort)null).getResultList();
    }

    @Override
    public List<T> findAll(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ByIdsSpecification specification = new ByIdsSpecification();
        TypedQuery<T> query = this.getQuery(specification, (Sort)null);
        return query.setParameter(specification.parameter, ids).getResultList();
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.getQuery(null, sort).getResultList();
    }

    public Page<T> findAll(Pageable pageable) {
        if (null == pageable) {
            return new PageImpl((List)this.findAll());
        }
        return this.findAll(null, pageable);
    }

    @Override
    public T findOne(Specification<T> spec) {
        try {
            return (T)this.getQuery(spec, (Sort)null).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<T> findAll(Specification<T> spec) {
        return this.getQuery(spec, (Sort)null).getResultList();
    }

    @Override
    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        TypedQuery<T> query = this.getQuery(spec, pageable);
        return pageable == null ? new Page<T>(query.getResultList()) : this.readPage(query, pageable, spec);
    }

    @Override
    public List<T> findAll(Specification<T> spec, Sort sort) {
        return this.getQuery(spec, sort).getResultList();
    }

    public long count() {
        return (Long)this.em.createQuery(this.getCountQueryString(), Long.class).getSingleResult();
    }

    @Override
    public long count(Specification<T> spec) {
        return (Long)this.getCountQuery(spec).getSingleResult();
    }

    @Transactional
    public <S extends T> S save(S entity) {
        if (this.entityInformation.isNew(entity)) {
            this.em.persist(entity);
            return entity;
        }
        return (S)this.em.merge(entity);
    }

    @Override
    @Transactional
    public <S extends T> S saveAndFlush(S entity) {
        S result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    @Transactional
    public <S extends T> List<S> save(Iterable<S> entities) {
        ArrayList<S> result = new ArrayList<S>();
        if (entities == null) {
            return result;
        }
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    @Transactional
    public void flush() {
        this.em.flush();
    }

    protected Page<T> readPage(TypedQuery<T> query, Pageable pageable, Specification<T> spec) {
        query.setFirstResult(pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        Long total = QueryUtils.executeCountQuery(this.getCountQuery(spec));
        List content = total > (long)pageable.getOffset() ? query.getResultList() : Collections.emptyList();
        return new PageImpl(content, pageable, total.longValue());
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Pageable pageable) {
        Sort sort = pageable == null ? null : pageable.getSort();
        return this.getQuery(spec, sort);
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Sort sort) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.getDomainClass());
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        query.select(root);
        if (sort != null) {
            query.orderBy(QueryUtils.toOrders(sort, root, builder));
        }
        return this.applyRepositoryMethodMetadata(this.em.createQuery(query));
    }

    protected TypedQuery<Long> getCountQuery(Specification<T> spec) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        if (query.isDistinct()) {
            query.select((Selection)builder.countDistinct(root));
        } else {
            query.select((Selection)builder.count(root));
        }
        return this.em.createQuery(query);
    }

    private <S> Root<T> applySpecificationToCriteria(Specification<T> spec, CriteriaQuery<S> query) {
        Assert.notNull(query);
        Root root = query.from(this.getDomainClass());
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private TypedQuery<T> applyRepositoryMethodMetadata(TypedQuery<T> query) {
        if (this.metadata == null) {
            return query;
        }
        LockModeType type = this.metadata.getLockModeType();
        TypedQuery toReturn = type == null ? query : query.setLockMode(type);
        for (Map.Entry<String, Object> hint : this.metadata.getQueryHints().entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
        return Jpa21Utils.tryConfigureFetchGraph(this.em, toReturn, this.metadata.getEntityGraph());
    }

    private final class ByIdsSpecification
    implements Specification<T> {
        ParameterExpression<Iterable> parameter;

        private ByIdsSpecification() {
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            Path path = root.get(SimpleJpaRepository.this.entityInformation.getIdAttribute());
            this.parameter = cb.parameter(Iterable.class);
            return path.in(new Expression[]{this.parameter});
        }
    }
}

