/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Enum;
import com.supermap.data.PixelFormat;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGridUniqueItem;
import com.supermap.mapping.ThemeGridUniqueNative;
import java.awt.Color;
import java.util.ArrayList;

public class ThemeGridUnique
extends Theme {
    private ArrayList _$1 = null;

    public ThemeGridUnique() {
        long l = ThemeGridUniqueNative.jni_New();
        this.setHandle(l, true);
        this.setDefaultColor(Color.black);
        this._$1 = new ArrayList();
    }

    public ThemeGridUnique(ThemeGridUnique themeGridUnique) {
        if (themeGridUnique == null) {
            String string = InternalResource.loadString("themeGridUnique", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGridUnique.getHandle() == 0L) {
            String string = InternalResource.loadString("themeGridUnique", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeGridUniqueNative.jni_Clone(themeGridUnique.getHandle());
        this.setHandle(l, true);
        this._$1 = new ArrayList();
        int n = themeGridUnique.getGridUniqueItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGridUnique));
        for (int i = 0; i < n; ++i) {
            ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(this);
            this._$1.add(themeGridUniqueItem);
        }
    }

    ThemeGridUnique(long l, boolean bl) {
        this.setHandle(l, bl);
        this._$1 = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(this);
            this._$1.add(themeGridUniqueItem);
        }
    }

    public ThemeGridUniqueItem getItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeGridUniqueItem)this._$1.get(n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridUniqueNative.jni_GetCount(this.getHandle());
    }

    public Color getDefaultColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridUniqueNative.jni_GetDefaultColor(this.getHandle());
        return new Color(n);
    }

    public void setDefaultColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultColor(Color color)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = color.getRGB();
        ThemeGridUniqueNative.jni_SetDefaultColor(this.getHandle(), n);
    }

    public int add(ThemeGridUniqueItem themeGridUniqueItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(ThemeGridUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGridUniqueItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeGridUniqueNative.jni_IsExist(this.getHandle(), themeGridUniqueItem.getUnique());
        if (bl) {
            String string = InternalResource.loadString("item.getUnique()", "ThemeGridUnique_TheUniqueIsExist", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGridUniqueItem themeGridUniqueItem2 = new ThemeGridUniqueItem(themeGridUniqueItem);
        int n = ThemeGridUniqueNative.jni_Add(this.getHandle(), themeGridUniqueItem2.getUnique(), themeGridUniqueItem2.isVisible(), themeGridUniqueItem2.getCaption(), themeGridUniqueItem2.getColor().getRGB());
        if (n != -1) {
            ThemeGridUniqueItem themeGridUniqueItem3 = new ThemeGridUniqueItem(this);
            this._$1.add(themeGridUniqueItem3);
        }
        this.m_lock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int n, ThemeGridUniqueItem themeGridUniqueItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, ThemeGridUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n > n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGridUniqueItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeGridUniqueNative.jni_IsExist(this.getHandle(), themeGridUniqueItem.getUnique());
        if (bl) {
            String string = InternalResource.loadString("item.getUnique()", "ThemeGridUnique_TheUniqueIsExist", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl2 = false;
        try {
            this.m_lock.lock();
            ThemeGridUniqueItem themeGridUniqueItem2 = new ThemeGridUniqueItem(themeGridUniqueItem);
            bl2 = false;
            if (n == n2) {
                int n3 = ThemeGridUniqueNative.jni_Add(this.getHandle(), themeGridUniqueItem2.getUnique(), themeGridUniqueItem2.isVisible(), themeGridUniqueItem2.getCaption(), themeGridUniqueItem2.getColor().getRGB());
                if (n3 == n2) {
                    bl2 = true;
                    ThemeGridUniqueItem themeGridUniqueItem3 = new ThemeGridUniqueItem(this);
                    this._$1.add(themeGridUniqueItem3);
                }
            } else {
                bl2 = ThemeGridUniqueNative.jni_Insert(this.getHandle(), n, themeGridUniqueItem2.getUnique(), themeGridUniqueItem2.isVisible(), themeGridUniqueItem2.getCaption(), themeGridUniqueItem2.getColor().getRGB());
                ThemeGridUniqueItem themeGridUniqueItem4 = new ThemeGridUniqueItem(this);
                this._$1.add(n, themeGridUniqueItem4);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl2;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = ThemeGridUniqueNative.jni_Remove(this.getHandle(), n);
        if (bl) {
            this._$1.remove(n);
        }
        this.m_lock.unlock();
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridUniqueNative.jni_Clear(this.getHandle());
        if (this._$1 != null) {
            this._$1.clear();
        }
        this.m_lock.unlock();
    }

    public static ThemeGridUnique makeDefault(DatasetGrid datasetGrid, ColorGradientType colorGradientType) {
        int n;
        long l;
        if (datasetGrid == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        PixelFormat pixelFormat = datasetGrid.getPixelFormat();
        if (pixelFormat == PixelFormat.DOUBLE || pixelFormat == PixelFormat.SINGLE) {
            String string = InternalResource.loadString("pixelFormat", "ThemeGridUnique_PixelFormatOnlyIntegerValid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.TERRAIN;
        }
        if ((l = ThemeGridUniqueNative.jni_MakeDefault(l2, n = InternalEnum.getUGCValue((Enum)colorGradientType))) == 0L) {
            return null;
        }
        return new ThemeGridUnique(l, true);
    }

    public static ThemeGridUnique makeDefault(DatasetGrid datasetGrid) {
        return ThemeGridUnique.makeDefault(datasetGrid, null);
    }

    public int indexOf(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double unique)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridUniqueNative.jni_IndexOf(this.getHandle(), d);
    }

    public void reverseColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridUniqueNative.jni_ReverseColor(this.getHandle());
        this.m_lock.unlock();
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",DefaultColor = ");
        stringBuffer.append(this.getDefaultColor().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGridUniqueNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromXML(String string) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(string);
            if (bl) {
                if (this._$1 != null) {
                    this._$1.clear();
                }
                int n = this.getCount();
                for (int i = 0; i < n; ++i) {
                    ThemeGridUniqueItem themeGridUniqueItem = new ThemeGridUniqueItem(this);
                    this._$1.add(themeGridUniqueItem);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    protected void clearHandle() {
        if (this._$1 != null) {
            this._$1.clear();
            this._$1 = null;
        }
        this.setHandle(0L);
    }

    ArrayList getGridUniqueItemsList() {
        return this._$1;
    }

    public void setSpecialValueTransparent(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGridUniqueNative.jni_SetSpecialValueTransparent(this.getHandle(), bl);
    }

    public boolean isSpecialValueTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridUniqueNative.jni_IsSpecialValueTransparent(this.getHandle());
    }

    public void setSpecialValue(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGridUniqueNative.jni_SetSpecialValue(this.getHandle(), n);
    }

    public int GetSpecialValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridUniqueNative.jni_GetSpecialValue(this.getHandle());
    }
}

