/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.DatasetGroup;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerAddedEvent;
import com.supermap.mapping.LayerAddedListener;
import com.supermap.mapping.LayerChart;
import com.supermap.mapping.LayerChartNative;
import com.supermap.mapping.LayerGroupAddedEvent;
import com.supermap.mapping.LayerGroupNative;
import com.supermap.mapping.LayerGroupRemovedEvent;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerRemovedEvent;
import com.supermap.mapping.LayerRemovedListener;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import java.util.ArrayList;
import java.util.Vector;

public class LayerGroup
extends Layer {
    protected ArrayList<Layer> m_layersList = new ArrayList();
    transient Vector<LayerAddedListener> m_layerAddedListeners;
    transient Vector<LayerRemovedListener> m_layerRemovedListeners;

    protected LayerGroup(long l, LayerGroup layerGroup, Layers layers, Map map) {
        super(l, layers, map);
        this.m_parentGroup = layerGroup;
        this._$1();
    }

    private void _$1() {
        int n = LayerGroupNative.jni_GetCount(this.getHandle());
        for (int i = 0; i < n; ++i) {
            long l = LayerGroupNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l == 0L) continue;
            boolean bl = LayerNative.jni_IsChartLayer(l);
            boolean bl2 = LayerGroupNative.jni_IsLayerGroup(l);
            if (bl) {
                long l2 = LayerChartNative.jni_GetDatasetGroup(l);
                DatasetGroup datasetGroup = InternalToolkitMapping.toMangedDatasetGroup(this.m_map.getWorkspace(), l2);
                LayerChart layerChart = new LayerChart(l, this.m_layers, this.m_map, datasetGroup);
                layerChart.setParentGroup(this);
                this.m_layersList.add(layerChart);
                continue;
            }
            if (bl2) {
                LayerGroup layerGroup = new LayerGroup(l, this, this.m_layers, this.m_map);
                this.m_layersList.add(layerGroup);
                continue;
            }
            Layer layer = new Layer(l, this.m_layers, this.m_map);
            layer.setParentGroup(this);
            this.m_layersList.add(layer);
            layer.getDataset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearHandle() {
        super.clearHandle();
        try {
            this.m_lock.lock();
            if (this.m_layersList != null && this.m_layersList.size() > 0) {
                Layer layer = null;
                for (int i = 0; i < this.m_layersList.size(); ++i) {
                    layer = this.m_layersList.get(i);
                    layer.clearHandle();
                    layer = null;
                }
                this.m_layersList.clear();
                this.m_layersList = null;
            }
            this.m_parentGroup = null;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_layersList.size();
    }

    public Layer get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_layersList.get(n);
    }

    public int indexOf(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_layersList.indexOf((Object)layer);
    }

    public void add(Layer layer) {
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1(-1, layer, l);
    }

    public void insert(int n, Layer layer) {
        if (layer == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this._$1(n, layer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(int n, Layer layer, long l) {
        try {
            this.m_lock.lock();
            if (layer.getParentGroup() != null) {
                layer.getParentGroup().removeLayer(layer, false);
            } else {
                this.m_layers.removeLayer(layer, false);
            }
            boolean bl = LayerGroupNative.jni_Insert(this.getHandle(), l, n);
            if (bl) {
                layer.setParentGroup(this);
                if (layer instanceof LayerGroup) {
                    if (n < 0 || n >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                    } else {
                        this.m_layersList.add(n, layer);
                    }
                    LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this.m_layers, (LayerGroup)layer, this, n);
                    this.m_layers.fireLayerGroupAdded(layerGroupAddedEvent);
                } else {
                    LayerAddedEvent layerAddedEvent = null;
                    if (n < 0 || n >= this.m_layersList.size()) {
                        this.m_layersList.add(layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                    } else {
                        this.m_layersList.add(n, layer);
                        layerAddedEvent = new LayerAddedEvent((Object)this, layer, n);
                    }
                    this.fireLayerAdded(layerAddedEvent);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public boolean remove(Layer layer) {
        return this.removeLayer(layer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeLayer(Layer layer, boolean bl) {
        boolean bl2 = false;
        try {
            this.m_lock.lock();
            if (layer == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle(layer);
            if (l == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            int n = this.m_layersList.indexOf((Object)layer);
            String string = layer.getName();
            bl2 = LayerGroupNative.jni_Remove(this.getHandle(), l, bl);
            if (bl2) {
                this.m_layersList.remove((Object)layer);
                layer.setParentGroup(null);
                if (layer instanceof LayerGroup) {
                    LayerGroupRemovedEvent layerGroupRemovedEvent = new LayerGroupRemovedEvent((Object)this.m_layers, (LayerGroup)layer, this, n);
                    this.m_layers.fireLayerGroupRemoved(layerGroupRemovedEvent);
                } else {
                    LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, n);
                    this.fireLayerRemoved(layerRemovedEvent);
                }
                if (bl) {
                    layer.clearHandle();
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl2;
    }

    public LayerGroup addGroup(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("addGroup(String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return this._$1(-1, string);
    }

    public LayerGroup insertGroup(int n, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("insertGroup(int index, String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n > this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            string = "";
        }
        return this._$1(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayerGroup _$1(int n, String string) {
        LayerGroup layerGroup = null;
        try {
            this.m_lock.lock();
            long l = LayerGroupNative.jni_InsertGroup(this.getHandle(), string, n);
            layerGroup = new LayerGroup(l, this, this.m_layers, this.m_map);
            layerGroup.setMap(this.m_map);
            if (n < 0 || n >= this.m_layersList.size()) {
                this.m_layersList.add(layerGroup);
                n = this.m_layersList.size();
            } else {
                this.m_layersList.add(n, layerGroup);
            }
            LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this, layerGroup, this, n);
            this.m_layers.fireLayerGroupAdded(layerGroupAddedEvent);
        }
        finally {
            this.m_lock.unlock();
        }
        return layerGroup;
    }

    public boolean removeGroup(LayerGroup layerGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.m_layersList.indexOf((Object)layerGroup);
        if (n < 0) {
            return false;
        }
        boolean bl = LayerGroupNative.jni_Remove(this.getHandle(), layerGroup.getHandle(), true);
        if (bl) {
            this.m_layersList.remove((Object)layerGroup);
            LayerGroupRemovedEvent layerGroupRemovedEvent = new LayerGroupRemovedEvent((Object)this, layerGroup, this, n);
            this.m_layers.fireLayerGroupRemoved(layerGroupRemovedEvent);
            layerGroup.clearHandle();
        }
        return bl;
    }

    public boolean ungroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_parentGroup != null) {
            int n = this.m_parentGroup.indexOf(this);
            int n2 = this.getCount();
            Layer layer = null;
            for (int i = n2 - 1; i >= 0; --i) {
                layer = this.get(i);
                this.m_parentGroup.insert(n, layer);
            }
            this.m_parentGroup.remove(this);
        } else {
            int n = this.m_layers.indexOf(this.getName());
            Layer layer = null;
            for (int i = this.m_layersList.size() - 1; i >= 0; --i) {
                layer = this.m_layersList.get(i);
                this.m_layers.addLayer(n, layer);
            }
            this.m_layers.remove(this);
        }
        return true;
    }

    public synchronized void addLayerAddedListener(LayerAddedListener layerAddedListener) {
        if (this.m_layerAddedListeners == null) {
            this.m_layerAddedListeners = new Vector();
        }
        if (!this.m_layerAddedListeners.contains(layerAddedListener)) {
            this.m_layerAddedListeners.add(layerAddedListener);
        }
    }

    public synchronized void removeLayerAddedListener(LayerAddedListener layerAddedListener) {
        if (this.m_layerAddedListeners != null && this.m_layerAddedListeners.contains(layerAddedListener)) {
            this.m_layerAddedListeners.remove(layerAddedListener);
        }
    }

    protected void fireLayerAdded(LayerAddedEvent layerAddedEvent) {
        if (this.m_layerAddedListeners != null) {
            Vector<LayerAddedListener> vector = this.m_layerAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layerAdded(layerAddedEvent);
            }
        }
    }

    public synchronized void addLayerRemovedListener(LayerRemovedListener layerRemovedListener) {
        if (this.m_layerRemovedListeners == null) {
            this.m_layerRemovedListeners = new Vector();
        }
        if (!this.m_layerRemovedListeners.contains(layerRemovedListener)) {
            this.m_layerRemovedListeners.add(layerRemovedListener);
        }
    }

    public synchronized void removeLayerRemovedListener(LayerRemovedListener layerRemovedListener) {
        if (this.m_layerRemovedListeners != null && this.m_layerRemovedListeners.contains(layerRemovedListener)) {
            this.m_layerRemovedListeners.remove(layerRemovedListener);
        }
    }

    protected void fireLayerRemoved(LayerRemovedEvent layerRemovedEvent) {
        if (this.m_layerRemovedListeners != null) {
            Vector<LayerRemovedListener> vector = this.m_layerRemovedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).layerRemoved(layerRemovedEvent);
            }
        }
    }

    protected static LayerGroup createInstance(long l, LayerGroup layerGroup, Layers layers, Map map) {
        return new LayerGroup(l, layerGroup, layers, map);
    }
}

