/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.mapping.ElementDrawingEvent;
import com.supermap.mapping.ElementDrawingListener;
import com.supermap.mapping.FillMarkerOrderMode;
import com.supermap.mapping.InternalDataset;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoCompound;
import com.supermap.mapping.InternalGeoRegion;
import com.supermap.mapping.InternalGeoText;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalQueryParameter;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.LayerCaptionChangedEvent;
import com.supermap.mapping.LayerCaptionChangedListener;
import com.supermap.mapping.LayerEditableChangedEvent;
import com.supermap.mapping.LayerEditableChangedListener;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSelectableChangedEvent;
import com.supermap.mapping.LayerSelectableChangedListener;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingGrid;
import com.supermap.mapping.LayerSettingImage;
import com.supermap.mapping.LayerSettingNetCDF;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.LayerSettingVector;
import com.supermap.mapping.LayerSnapableChangedEvent;
import com.supermap.mapping.LayerSnapableChangedListener;
import com.supermap.mapping.LayerVisibleChangedEvent;
import com.supermap.mapping.LayerVisibleChangedListener;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.Selection;
import com.supermap.mapping.Theme;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer
extends com.supermap.data.InternalHandle {
    protected Layers m_layers = null;
    protected Map m_map = null;
    protected Selection m_selection = null;
    private Dataset _$7 = null;
    private Theme _$6 = null;
    private LayerSetting _$5 = null;
    private QueryParameter _$4 = null;
    private GeoRegion _$3 = null;
    private String[] _$2 = null;
    transient Vector m_elementDrawingListeners;
    @Deprecated
    transient Vector m_layerCaptionChangedListener;
    @Deprecated
    transient Vector m_layerSelectableChangedListener;
    @Deprecated
    transient Vector m_layerEditableChangedListener;
    @Deprecated
    transient Vector m_layerVisibleChangedListener;
    @Deprecated
    transient Vector m_layerSnapableChangedListener;
    private long _$1 = 0L;
    ReentrantLock m_lock;
    LayerGroup m_parentGroup;

    Layer() {
        this._$1 = LayerNative.jni_NewSelfEventHandle(this);
    }

    Layer(long l, Layers layers, Map map) {
        this.setHandle(l);
        this.m_map = map;
        this.m_layers = layers;
        this._$1 = LayerNative.jni_NewSelfEventHandle(this);
        this.m_lock = map.m_lock;
    }

    void setMap(Map map) {
        this.m_map = map;
        this.m_lock = map.m_lock;
    }

    public boolean isCompleteLineSymbolDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCompleteLineSymbolDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsCompleteLineSymbolDisplayed(this.getHandle());
    }

    public void setCompleteLineSymbolDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompleteLineSymbolDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetCompleteLineSymbolDisplayed(this.getHandle(), bl);
    }

    public boolean isClipRegionEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isClipRegionEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsClipRegionEnabled(this.getHandle());
    }

    public void setClipRegionEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegionEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        LayerNative.jni_SetClipRegionEnabled(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetName(this.getHandle());
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setCaption(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (string.indexOf("/") != -1 || string.indexOf("\\") != -1 || string.indexOf("<") != -1 || string.indexOf(">") != -1 || string.indexOf(":") != -1 || string.indexOf("|") != -1 || string.indexOf("\"") != -1 || string.indexOf("?") != -1 || string.indexOf("*") != -1) {
            String string4 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this.getCaption();
        LayerNative.jni_SetCaption(this.getHandle(), string);
        LayerCaptionChangedEvent layerCaptionChangedEvent = new LayerCaptionChangedEvent((Object)this, this, string5, string);
        this.fireCaptionChanged(layerCaptionChangedEvent);
        this.m_layers.fireCaptionChanged(layerCaptionChangedEvent);
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        LayerNative.jni_SetDescription(this.getHandle(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset getDataset() {
        try {
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = LayerNative.jni_GetDataset(this.getHandle());
            Workspace workspace = this.m_map.getWorkspace();
            this._$7 = InternalToolkitMapping.toMangedDataset(workspace, l);
        }
        finally {
            this.m_lock.unlock();
        }
        return this._$7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" setDataset(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        try {
            this.m_lock.lock();
            boolean bl = false;
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl2 = bl = dataset.getDatasource().getWorkspace() == this.m_map.getWorkspace();
            if (!bl) {
                String string = InternalResource.loadString("setDataset(Dataset dataset)", "Layer_WorkspaceNoContainTheDataset(-100~100)", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            LayerNative.jni_SetDataset(this.getHandle(), l);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public QueryParameter getDisplayFilter() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayFilter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = LayerNative.jni_GetDisplayFilter(this.getHandle())) != 0L) {
            this._$4 = InternalQueryParameter.createInstance(l);
        }
        return this._$4;
    }

    public void setDisplayFilter(QueryParameter queryParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayFilter(QueryParameter value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)queryParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("queryParameter", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        QueryParameter queryParameter2 = new QueryParameter(queryParameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)queryParameter2);
        this.m_lock.lock();
        LayerNative.jni_SetDisplayFilter(this.getHandle(), l2);
        InternalQueryParameter.identicalJavaObject(this.getDisplayFilter(), queryParameter2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)queryParameter2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)queryParameter);
        this.m_lock.unlock();
    }

    public LayerSetting getAdditionalSetting() {
        Dataset dataset;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAddtionalSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getTheme() == null && this._$5 == null && (dataset = this.getDataset()) != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L) {
            Class<?> clazz = dataset.getClass();
            if (clazz.equals(DatasetVector.class)) {
                this._$5 = new LayerSettingVector(this, this.m_layers);
            } else if (clazz.equals(DatasetImage.class)) {
                this._$5 = new LayerSettingImage(this, this.m_layers);
            } else if (clazz.equals(DatasetGrid.class)) {
                this._$5 = new LayerSettingGrid(this, this.m_layers);
            }
        }
        return this._$5;
    }

    public void setAdditionalSetting(LayerSetting layerSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAddtionalSetting(LayerSetting layerSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getAdditionalSetting() == null) {
            String string = InternalResource.loadString("setAddtionalSetting(LayerSetting layerSetting)", "Layer_UnsupportedOperationOfSetAdditionalSetting", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (layerSetting == null) {
            String string = InternalResource.loadString("layerSetting", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerSettingType layerSettingType = this.getAdditionalSetting().getType();
        if (layerSettingType.equals((Object)layerSetting.getType())) {
            if (layerSettingType.equals((Object)LayerSettingType.VECTOR)) {
                LayerSettingVector layerSettingVector = (LayerSettingVector)layerSetting;
                ((LayerSettingVector)this._$5).setStyle(layerSettingVector.getStyle());
            } else if (layerSettingType.equals((Object)LayerSettingType.GRID)) {
                LayerSettingGrid layerSettingGrid = (LayerSettingGrid)layerSetting;
                ((LayerSettingGrid)this._$5).setColorTable(layerSettingGrid.getColorTable());
                ((LayerSettingGrid)this._$5).setColorDictionary(layerSettingGrid.getColorDictionary());
                ((LayerSettingGrid)this._$5).setSpecialValueColor(layerSettingGrid.getSpecialValueColor());
                if (!((LayerSettingGrid)layerSetting).isOwnerLayer && !((LayerSettingGrid)layerSetting).is_set) {
                    ((LayerSettingGrid)this._$5).setSpecialValue(((DatasetGrid)this.getDataset()).getNoValue());
                } else {
                    ((LayerSettingGrid)this._$5).setSpecialValue(layerSettingGrid.getSpecialValue());
                }
                ((LayerSettingGrid)this._$5).setBrightness(layerSettingGrid.getBrightness());
                ((LayerSettingGrid)this._$5).setContrast(layerSettingGrid.getContrast());
                ((LayerSettingGrid)this._$5).setOpaqueRate(layerSettingGrid.getOpaqueRate());
                ((LayerSettingGrid)this._$5).setSpecialValueTransparent(layerSettingGrid.isSpecialValueTransparent());
            } else if (layerSettingType.equals((Object)LayerSettingType.IMAGE)) {
                LayerSettingImage layerSettingImage = (LayerSettingImage)layerSetting;
                ((LayerSettingImage)this._$5).setOpaqueRate(layerSettingImage.getOpaqueRate());
                ((LayerSettingImage)this._$5).setTransparent(layerSettingImage.isTransparent());
                ((LayerSettingImage)this._$5).setTransparentColor(layerSettingImage.getTransparentColor());
                ((LayerSettingImage)this._$5).setBrightness(layerSettingImage.getBrightness());
                ((LayerSettingImage)this._$5).setContrast(layerSettingImage.getContrast());
                ((LayerSettingImage)this._$5).setTransparentColorTolerance(layerSettingImage.getTransparentColorTolerance());
                if (layerSettingImage.getDisplayBandIndexes() != null) {
                    ((LayerSettingImage)this._$5).setDisplayColorSpace(layerSettingImage.getDisplayColorSpace());
                    ((LayerSettingImage)this._$5).setDisplayBandIndexes(layerSettingImage.getDisplayBandIndexes());
                }
            } else if (layerSettingType.equals((Object)LayerSettingType.NetCDF)) {
                LayerSettingNetCDF layerSettingNetCDF = (LayerSettingNetCDF)layerSetting;
                ((LayerSettingNetCDF)this._$5).setColorTable(layerSettingNetCDF.getColorTable());
                ((LayerSettingNetCDF)this._$5).setBrightness(layerSettingNetCDF.getBrightness());
                ((LayerSettingNetCDF)this._$5).setContrast(layerSettingNetCDF.getContrast());
                ((LayerSettingNetCDF)this._$5).setSpecialValueColor(layerSettingNetCDF.getSpecialValueColor());
                if (!((LayerSettingNetCDF)layerSetting).isOwnerLayer && !((LayerSettingNetCDF)layerSetting).is_set) {
                    ((LayerSettingNetCDF)this._$5).setSpecialValue(((DatasetGrid)this.getDataset()).getNoValue());
                } else {
                    ((LayerSettingNetCDF)this._$5).setSpecialValue(layerSettingNetCDF.getSpecialValue());
                }
                ((LayerSettingNetCDF)this._$5).setOpaqueRate(layerSettingNetCDF.getOpaqueRate());
                ((LayerSettingNetCDF)this._$5).setSpecialValueTransparent(layerSettingNetCDF.isSpecialValueTransparent());
                ((LayerSettingNetCDF)this._$5).setXDimension(layerSettingNetCDF.getXDimension());
                ((LayerSettingNetCDF)this._$5).setXStartIndex(layerSettingNetCDF.getXStartIndex());
                ((LayerSettingNetCDF)this._$5).setXEndIndex(layerSettingNetCDF.getXEndIndex());
                ((LayerSettingNetCDF)this._$5).setYDimension(layerSettingNetCDF.getYDimension());
                ((LayerSettingNetCDF)this._$5).setYStartIndex(layerSettingNetCDF.getYStartIndex());
                ((LayerSettingNetCDF)this._$5).setYEndIndex(layerSettingNetCDF.getYEndIndex());
                ((LayerSettingNetCDF)this._$5).setOptionalDimension(layerSettingNetCDF.getOptionalDimension());
                ((LayerSettingNetCDF)this._$5).setOptionalDimIndex(layerSettingNetCDF.getOptionalDimIndex());
            }
        } else {
            String string = InternalResource.loadString("layerSetting", "Layer_TheArgumentOfLayerSettingIsInvalidLayerSettingType", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public Theme getTheme() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTheme()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$6 == null && (l = LayerNative.jni_GetTheme(this.getHandle())) != 0L) {
            this._$6 = Theme.createInstance(l, this);
        }
        return this._$6;
    }

    public Selection getSelection() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = this.getDataset();
        if (InternalDataset.getIsVector(dataset) && this.m_selection == null && (l = LayerNative.jni_GetSelection(this.getHandle())) != 0L) {
            this.m_selection = new Selection(l, this);
        }
        return this.m_selection;
    }

    public void setSelection(Selection selection) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelection(Selection selection)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (selection == null) {
            String string = InternalResource.loadString("selection", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)selection) == 0L) {
            String string = InternalResource.loadString("selection", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getDataset());
        if (selection.getDataset() == null) {
            String string = InternalResource.loadString("selection", "Layer_TheDatasetOfSelectionShouldNotBeNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)selection.getDataset());
        if (l2 == 0L) {
            String string = InternalResource.loadString("selection", "Layer_TheDatasetOfSelectionHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (l != l2) {
            String string = InternalResource.loadString("selection", "Layer_TheDatasetShouldBeIdentical", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)selection);
        LayerNative.jni_SetSelection(this.getHandle(), l3, selection.isDefaultStyleEnabled());
        this.m_lock.unlock();
    }

    public boolean isSelectable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSelectable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetSelectable(this.getHandle());
    }

    public void setSelectable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSelectable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetSelectable(this.getHandle(), bl);
        LayerSelectableChangedEvent layerSelectableChangedEvent = new LayerSelectableChangedEvent((Object)this, this, bl);
        this.fireSelectableChanged(layerSelectableChangedEvent);
        this.m_layers.fireSelectableChanged(layerSelectableChangedEvent);
    }

    public boolean isSnapable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSnapable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsSnapable(this.getHandle());
    }

    public void setSnapable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSnapable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsSnapable(this.getHandle(), bl);
        LayerSnapableChangedEvent layerSnapableChangedEvent = new LayerSnapableChangedEvent((Object)this, this, bl);
        this.fireSnapableChanged(layerSnapableChangedEvent);
        this.m_layers.fireSnapableChanged(layerSnapableChangedEvent);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsSymbolScalable(this.getHandle());
    }

    public void setSymbolScalable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsSymbolScalable(this.getHandle(), bl);
    }

    public double getSymbolScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetSymbolScale(this.getHandle());
    }

    public void setSymbolScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("", "Layer_SymbolScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetSymbolScale(this.getHandle(), d);
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsVisible(this.getHandle(), bl);
        LayerVisibleChangedEvent layerVisibleChangedEvent = new LayerVisibleChangedEvent((Object)this, this, bl);
        this.fireVisibleChanged(layerVisibleChangedEvent);
        this.m_layers.fireVisibleChanged(layerVisibleChangedEvent);
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsAntialias(this.getHandle());
    }

    public void setAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsAntialias(this.getHandle(), bl);
    }

    public double getMaxVisibleScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetMaxVisibleScale(this.getHandle());
    }

    public void setMaxVisibleScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Layer_MaxVisibleScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetMaxVisibleScale(this.getHandle(), d);
    }

    public double getMinVisibleScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetMinVisibleScale(this.getHandle());
    }

    public void setMinVisibleScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Layer_MinVisibleScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetMinVisibleScale(this.getHandle(), d);
    }

    public double getMinVisibleGeometrySize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleGeometrySize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetMinVisibleGeometrySize(this.getHandle());
    }

    public void setMinVisibleGeometrySize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleGeometrySize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Layer_MinVisibleGeometrySizeShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetMinVisibleGeometrySize(this.getHandle(), d);
    }

    public boolean isEditable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEditable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsEditable(this.getHandle());
    }

    public void setEditable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEditable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsEditable(this.getHandle(), 0, bl);
        LayerEditableChangedEvent layerEditableChangedEvent = new LayerEditableChangedEvent((Object)this, this, bl);
        this.fireEditableChanged(layerEditableChangedEvent);
        this.m_layers.fireEditableChanged(layerEditableChangedEvent);
    }

    public String[] getValueExpressions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getValueExpressions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = null;
        if (this._$2 == null && this.getTheme() != null) {
            String string = LayerNative.jni_GetValueExpressions(this.getHandle());
            stringArray = InternalToolkitMapping.splitString(string, ";");
            this._$2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this._$2[i] = stringArray[i];
            }
        }
        return this._$2;
    }

    public void setValueExpressions(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setValueExpressions(String[] value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this._$2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this._$2[i] = stringArray[i];
        }
        String string = ";";
        if (this.getTheme() != null) {
            string = InternalToolkitMapping.joinString(stringArray, ";");
            LayerNative.jni_SetValueExpressions(this.getHandle(), string);
        }
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null && (l = LayerNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this._$3 = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this._$3, false);
            if (this._$3.isEmpty()) {
                this._$3 = null;
            }
        }
        return this._$3;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            LayerNative.jni_SetClipRegion(this.getHandle(), 0L);
            this._$3 = null;
        } else {
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            LayerNative.jni_SetClipRegion(this.getHandle(), l);
            if (this._$3 != null) {
                this._$3.fromXML(geoRegion.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
    }

    public int getOpaqueRate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOpaqueRate()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetOpaqueRate(this.getHandle());
    }

    public void setOpaqueRate(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpaqueRate(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        LayerNative.jni_SetOpaqueRate(this.getHandle(), n);
    }

    public void setFillMarkerOrder(FillMarkerOrderMode fillMarkerOrderMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMarkerOrder(FillMarkerOrderMode fillMarkerOrderMode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(fillMarkerOrderMode);
        LayerNative.jni_SetFillMarkerOrderMode(this.getHandle(), n);
    }

    public FillMarkerOrderMode getFillMarkerOrder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillMarkerOrderMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerNative.jni_GetFillMarkerOrderMode(this.getHandle());
        return n == 0 ? FillMarkerOrderMode.LayerTopLeft : FillMarkerOrderMode.GeometryTopLeft;
    }

    public boolean removeThemeElementPosition(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeThemeElementPosition(int geometryID)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_RemoveThemeElementPosition(this.getHandle(), n);
    }

    public Point2D getThemeElementPosition(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThemeElementPosition(int geometryID)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        LayerNative.jni_GetThemeElementPosition(this.getHandle(), n, dArray);
        Point2D point2D = new Point2D();
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public void setThemeElementPosition(int n, Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThemeElementPosition(int geometryID, Point2D position)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        LayerNative.jni_SetThemeElementPosition(this.getHandle(), n, d, d2);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        LayerNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void clearThemeElementPositions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearThemeElementPositions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_ClearThemeElementPositions(this.getHandle());
    }

    public boolean hitTest(Point2D point2D, double d, ArrayList<GeoText> arrayList) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D pt, double tolerance, ArrayList<GeoText> testResult)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        } else {
            arrayList.clear();
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        String string = "";
        long[] lArray = LayerNative.jni_GetGeoTextHitTest(this.getHandle(), point2D.getX(), point2D.getY(), d, l, string);
        boolean bl = false;
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                GeoText geoText = InternalGeoText.createInstance(lArray[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoText, true);
                arrayList.add(geoText);
            }
            bl = true;
        }
        return bl;
    }

    public boolean hitTest(Point2D point2D, double d, String string, ArrayList<GeoText> arrayList) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("hitTest(Point2D pt, double tolerance, String resultExpression, ArrayList<GeoText> testResult)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (arrayList == null) {
            String string3 = InternalResource.loadString("testResult", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string3);
        }
        arrayList.clear();
        if (d < 0.0) {
            String string4 = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        long[] lArray = LayerNative.jni_GetGeoTextHitTest(this.getHandle(), point2D.getX(), point2D.getY(), d, l, string);
        boolean bl = false;
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                GeoText geoText = InternalGeoText.createInstance(lArray[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoText, true);
                arrayList.add(geoText);
            }
            bl = true;
        }
        return bl;
    }

    public boolean hitTestGeoCompound(Point2D point2D, double d, String string, ArrayList<GeoCompound> arrayList) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("hitTest(Point2D pt, double tolerance, String resultExpression, ArrayList<GeoText> testResult)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (arrayList == null) {
            String string3 = InternalResource.loadString("testResult", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string3);
        }
        arrayList.clear();
        if (d < 0.0) {
            String string4 = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        long[] lArray = LayerNative.jni_GetGeoCompoundHitTest(this.getHandle(), point2D.getX(), point2D.getY(), d, l, string);
        boolean bl = false;
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                GeoCompound geoCompound = InternalGeoCompound.createInstance(lArray[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoCompound, true);
                arrayList.add(geoCompound);
            }
            bl = true;
        }
        return bl;
    }

    public Selection hitTest(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = this.getDataset();
        Selection selection = null;
        if (InternalDataset.getIsVector(dataset)) {
            if (d < 0.0) {
                String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
            long l2 = LayerNative.jni_HitTest(this.getHandle(), point2D.getX(), point2D.getY(), d, l);
            if (l2 != 0L) {
                selection = new Selection(l2, this);
                InternalHandleDisposable.setIsDisposable(selection, true);
            }
        }
        return selection;
    }

    public boolean isVisibleScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisibleScale(double dScale)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsVisibleScale(this.getHandle(), d);
    }

    public String getRepresentationField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRepresentationField()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetRepresentationField(this.getHandle());
    }

    public void setRepresentationField(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setRepresentationField(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        LayerNative.jni_SetRepresentationField(this.getHandle(), string);
    }

    public boolean isRepresentationEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRepresentationEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsRepresentationEnabled(this.getHandle());
    }

    public void setRepresentationEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRepresentationEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetRepresentationEnabled(this.getHandle(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector themeToDatasetVector(Datasource datasource, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("themeToDatasetVector(Datasource datasource, String datasetName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (datasource == null) {
            String string3 = InternalResource.loadString("datasource", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l == 0L) {
            String string4 = InternalResource.loadString("datasource", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("datasetName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetVector datasetVector = null;
        try {
            this.m_lock.lock();
            if (this.getTheme() != null) {
                DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo(string, DatasetType.CAD);
                datasetVector = datasource.getDatasets().create(datasetVectorInfo);
                long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
                long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
                if (this.m_map.getViewBounds().equals(new Rectangle2D(0.0, 0.0, 0.0, 0.0))) {
                    this.m_map.setViewBounds(this.getDataset().getBounds());
                }
                double d = this.m_map.getImageSize().getWidth();
                double d2 = this.m_map.getImageSize().getHeight();
                if (d < 2.0 && d2 < 2.0) {
                    this.m_map.setImageSize(new Dimension(256, 256));
                } else {
                    this.m_map.setImageSize(new Dimension((int)d, (int)d2));
                }
                boolean bl = false;
                if (l2 != 0L && l3 != 0L) {
                    bl = LayerNative.jni_ThemeToDatasetVector(this.getHandle(), l2, l3);
                }
                if (!bl) {
                    datasource.getDatasets().delete(string);
                    datasetVector = null;
                }
                this.m_map.setImageSize(new Dimension((int)d, (int)d2));
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return datasetVector;
    }

    @Deprecated
    public Geometry[] themeSymbolsToGeometrys(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("themeSymbolsToGeometrys(Recordset recordset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        if (l2 == 0L) {
            String string = InternalResource.loadString("map", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = LayerNative.jni_ThemeSymbolsToGeometrys(this.getHandle(), l, l2);
        int n = lArray.length;
        Geometry[] geometryArray = new Geometry[n];
        for (int i = 0; i < n; ++i) {
            geometryArray[i] = InternalGeometry.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return geometryArray;
    }

    public Geometry[] themeSymbolsToGeometries(Recordset recordset) {
        return this.themeSymbolsToGeometrys(recordset);
    }

    @Deprecated
    public boolean isDiposed() {
        return this.isDisposed();
    }

    public boolean isDisposed() {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            bl = true;
        }
        return bl;
    }

    protected void clearHandle() {
        this.m_lock.lock();
        if (this.m_selection != null) {
            this.m_selection.clearHandle();
            this.m_selection = null;
        }
        if (this._$4 != null) {
            InternalQueryParameter.clearHandle(this._$4);
            this._$4 = null;
        }
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        if (this._$7 != null) {
            this._$7 = null;
        }
        if (this._$6 != null) {
            this._$6.clearHandle();
            this._$6 = null;
        }
        this.m_layers = null;
        this.m_map = null;
        if (this._$1 != 0L) {
            LayerNative.jni_DeleteSelfEventHandle(this._$1);
            this._$1 = 0L;
        }
        if (this._$3 != null) {
            InternalGeoRegion.clearHandle(this._$3);
            this._$3 = null;
        }
        this.setHandle(0L);
        this.m_lock.unlock();
    }

    void reset() {
        LayerNative.jni_Reset(this.getHandle());
    }

    public synchronized void addElementDrawingListener(ElementDrawingListener elementDrawingListener) {
        if (this.m_elementDrawingListeners == null) {
            this.m_elementDrawingListeners = new Vector();
        }
        if (this.m_elementDrawingListeners.isEmpty()) {
            LayerNative.jni_RegisterElementDrawingCallBack(this.getHandle(), this._$1);
        }
        if (!this.m_elementDrawingListeners.contains(elementDrawingListener)) {
            this.m_elementDrawingListeners.add(elementDrawingListener);
        }
    }

    public synchronized void removeElementDrawingListener(ElementDrawingListener elementDrawingListener) {
        if (this.m_elementDrawingListeners != null && this.m_elementDrawingListeners.contains(elementDrawingListener)) {
            this.m_elementDrawingListeners.remove(elementDrawingListener);
        }
        if (this.m_elementDrawingListeners == null || this.m_elementDrawingListeners.isEmpty()) {
            LayerNative.jni_UnRegisterElementDrawingCallBack(this.getHandle(), this._$1);
        }
    }

    protected void fireElementDrawing(ElementDrawingEvent elementDrawingEvent) {
        if (this.m_elementDrawingListeners != null) {
            Vector vector = this.m_elementDrawingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ElementDrawingListener)vector.elementAt(i)).elementDrawing(elementDrawingEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addCaptionChangedListener(LayerCaptionChangedListener layerCaptionChangedListener) {
        if (this.m_layerCaptionChangedListener == null) {
            this.m_layerCaptionChangedListener = new Vector();
        }
        if (!this.m_layerCaptionChangedListener.contains(layerCaptionChangedListener)) {
            this.m_layerCaptionChangedListener.add(layerCaptionChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeCaptionChangedListener(LayerCaptionChangedListener layerCaptionChangedListener) {
        if (this.m_layerCaptionChangedListener != null && this.m_layerCaptionChangedListener.contains(layerCaptionChangedListener)) {
            this.m_layerCaptionChangedListener.remove(layerCaptionChangedListener);
        }
    }

    @Deprecated
    protected void fireCaptionChanged(LayerCaptionChangedEvent layerCaptionChangedEvent) {
        if (this.m_layerCaptionChangedListener != null) {
            Vector vector = this.m_layerCaptionChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerCaptionChangedListener)vector.elementAt(i)).captionChanged(layerCaptionChangedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addSelectableChangedListener(LayerSelectableChangedListener layerSelectableChangedListener) {
        if (this.m_layerSelectableChangedListener == null) {
            this.m_layerSelectableChangedListener = new Vector();
        }
        if (!this.m_layerSelectableChangedListener.contains(layerSelectableChangedListener)) {
            this.m_layerSelectableChangedListener.add(layerSelectableChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeSelectableChangedListener(LayerSelectableChangedListener layerSelectableChangedListener) {
        if (this.m_layerSelectableChangedListener != null && this.m_layerSelectableChangedListener.contains(layerSelectableChangedListener)) {
            this.m_layerSelectableChangedListener.remove(layerSelectableChangedListener);
        }
    }

    @Deprecated
    protected void fireSelectableChanged(LayerSelectableChangedEvent layerSelectableChangedEvent) {
        if (this.m_layerSelectableChangedListener != null) {
            Vector vector = this.m_layerSelectableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerSelectableChangedListener)vector.elementAt(i)).selectableChanged(layerSelectableChangedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addEditableChangedListener(LayerEditableChangedListener layerEditableChangedListener) {
        if (this.m_layerEditableChangedListener == null) {
            this.m_layerEditableChangedListener = new Vector();
        }
        if (!this.m_layerEditableChangedListener.contains(layerEditableChangedListener)) {
            this.m_layerEditableChangedListener.add(layerEditableChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeEditableChangedListener(LayerEditableChangedListener layerEditableChangedListener) {
        if (this.m_layerEditableChangedListener != null && this.m_layerEditableChangedListener.contains(layerEditableChangedListener)) {
            this.m_layerEditableChangedListener.remove(layerEditableChangedListener);
        }
    }

    @Deprecated
    protected void fireEditableChanged(LayerEditableChangedEvent layerEditableChangedEvent) {
        if (this.m_layerEditableChangedListener != null) {
            Vector vector = this.m_layerEditableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerEditableChangedListener)vector.elementAt(i)).editableChanged(layerEditableChangedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addVisibleChangedListener(LayerVisibleChangedListener layerVisibleChangedListener) {
        if (this.m_layerVisibleChangedListener == null) {
            this.m_layerVisibleChangedListener = new Vector();
        }
        if (!this.m_layerVisibleChangedListener.contains(layerVisibleChangedListener)) {
            this.m_layerVisibleChangedListener.add(layerVisibleChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeVisibleChangedListener(LayerVisibleChangedListener layerVisibleChangedListener) {
        if (this.m_layerVisibleChangedListener != null && this.m_layerVisibleChangedListener.contains(layerVisibleChangedListener)) {
            this.m_layerVisibleChangedListener.remove(layerVisibleChangedListener);
        }
    }

    @Deprecated
    protected void fireVisibleChanged(LayerVisibleChangedEvent layerVisibleChangedEvent) {
        if (this.m_layerVisibleChangedListener != null) {
            Vector vector = this.m_layerVisibleChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(layerVisibleChangedEvent);
            }
        }
    }

    @Deprecated
    public synchronized void addSnapableChangedListener(LayerSnapableChangedListener layerSnapableChangedListener) {
        if (this.m_layerSnapableChangedListener == null) {
            this.m_layerSnapableChangedListener = new Vector();
        }
        if (!this.m_layerSnapableChangedListener.contains(layerSnapableChangedListener)) {
            this.m_layerSnapableChangedListener.add(layerSnapableChangedListener);
        }
    }

    @Deprecated
    public synchronized void removeSnapableChangedListener(LayerSnapableChangedListener layerSnapableChangedListener) {
        if (this.m_layerSnapableChangedListener != null && this.m_layerSnapableChangedListener.contains(layerSnapableChangedListener)) {
            this.m_layerSnapableChangedListener.remove(layerSnapableChangedListener);
        }
    }

    @Deprecated
    protected void fireSnapableChanged(LayerSnapableChangedEvent layerSnapableChangedEvent) {
        if (this.m_layerSnapableChangedListener != null) {
            Vector vector = this.m_layerSnapableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerSnapableChangedListener)vector.elementAt(i)).snapableChanged(layerSnapableChangedEvent);
            }
        }
    }

    static void elementDrawingCallBack(Layer layer, long l, Object[] objectArray, long l2, long l3) {
        if (layer != null) {
            Geometry geometry = null;
            if (l != 0L) {
                geometry = InternalGeometry.createInstance(l);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
            }
            GeoCompound geoCompound = null;
            if (l2 != 0L) {
                geoCompound = InternalGeoCompound.createInstance(l2);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoCompound, false);
            }
            Boolean bl = false;
            if (l3 != 0L) {
                bl = InternalToolkitMapping.getHandleBooleanValue(l3);
            }
            ElementDrawingEvent elementDrawingEvent = new ElementDrawingEvent((Object)layer, geoCompound, geometry, objectArray, bl);
            layer.fireElementDrawing(elementDrawingEvent);
            if (l3 != 0L) {
                InternalToolkitMapping.setHandleBooleanValue(l3, elementDrawingEvent.getCancel());
            }
        }
    }

    public boolean isCrossroadOptimized() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCrossroadOptimized()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsCrossroadOptimized(this.getHandle());
    }

    public void setCrossroadOptimized(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCrossroadOptimized(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetCrossroadOptimized(this.getHandle(), bl);
    }

    public void setExternalInfo(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setExternalInfo(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        LayerNative.jni_SetExternalInfo(this.getHandle(), string);
    }

    public String getExternalInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExternalInfo()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetExternalInfo(this.getHandle());
    }

    public LayerGroup getParentGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExternalInfo()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_parentGroup;
    }

    void setParentGroup(LayerGroup layerGroup) {
        this.m_parentGroup = layerGroup;
    }
}

