/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.GeoStyle;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.mapping.ChartAttributeInfo;
import com.supermap.mapping.ChartObjectInfoNative;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.S57EdgeStyle;
import com.supermap.mapping.Selection;

public class ChartObjectInfo
extends InternalHandle {
    private Selection _$2 = null;
    S57EdgeStyle[] m_s57EdgeStyles = null;
    private ChartAttributeInfo[] _$1 = null;

    protected ChartObjectInfo(long l, Selection selection) {
        this.setHandle(l);
        this._$2 = selection;
    }

    protected static ChartObjectInfo createInstance(long l, Selection selection) {
        if (l == 0L) {
            return null;
        }
        ChartObjectInfo chartObjectInfo = new ChartObjectInfo(l, selection);
        return chartObjectInfo;
    }

    protected void clearHandle() {
        if (this._$1 != null) {
            for (ChartAttributeInfo chartAttributeInfo : this._$1) {
                if (chartAttributeInfo == null) continue;
                chartAttributeInfo.dispose();
            }
            this._$1 = null;
        }
        if (this.m_s57EdgeStyles != null) {
            for (S57EdgeStyle s57EdgeStyle : this.m_s57EdgeStyles) {
                s57EdgeStyle.getStyle().dispose();
            }
            this.m_s57EdgeStyles = null;
        }
        this.setHandle(0L);
    }

    public String getLongName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLongName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetLongName(this.getHandle());
    }

    public long getFeatureID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFeatureID()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetFeatureID(this.getHandle());
    }

    public String getAcronym() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAcronym()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetAcronym(this.getHandle());
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetName(this.getHandle());
    }

    public String getLocalName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLocalName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetLocalName(this.getHandle());
    }

    public int getCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetCode(this.getHandle());
    }

    public String getAgencyToken() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAgencyToken()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetAgencyToken(this.getHandle());
    }

    public GeometryType getGeometryType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeometryType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ChartObjectInfoNative.jni_GetGeometryType(this.getHandle());
        return (GeometryType)InternalEnum.parseUGCValue(GeometryType.class, n);
    }

    public String getS57FeatureTypeName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getS57FeatureTypeName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetS57FeatureTypeName(this.getHandle());
    }

    public int getRecordsetID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordsetID()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetRecordsetID(this.getHandle());
    }

    public double getDepth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDepth()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetDepth(this.getHandle());
    }

    public void setDepth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDepth()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ChartObjectInfoNative.jni_SetDepth(this.getHandle(), d);
    }

    public String getMasterLongName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMasterLongName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetMasterLongName(this.getHandle());
    }

    public String getCollectionLongName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCollectionLongName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ChartObjectInfoNative.jni_GetCollectionLongName(this.getHandle());
    }

    public ChartAttributeInfo[] getS57Attributes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getS57Attributes()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = ChartObjectInfoNative.jni_GetS57Attributes(this.getHandle());
        if (this._$1 != null) {
            for (ChartAttributeInfo chartAttributeInfo : this._$1) {
                if (chartAttributeInfo == null) continue;
                chartAttributeInfo.dispose();
            }
            this._$1 = null;
        }
        if (this._$1 == null) {
            this._$1 = new ChartAttributeInfo[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                this._$1[i] = ChartAttributeInfo.createInstance(lArray[i]);
            }
        }
        return this._$1;
    }

    public boolean setS57AttributeValue(String string, Object object) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setS57AttributeValue()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        long l = 0L;
        long[] lArray = ChartObjectInfoNative.jni_GetS57Attributes(this.getHandle());
        for (int i = 0; i < lArray.length; ++i) {
            ChartAttributeInfo chartAttributeInfo = ChartAttributeInfo.createInstance(lArray[i]);
            if (chartAttributeInfo.getAcronym().compareToIgnoreCase(string) != 0) continue;
            chartAttributeInfo.setValue(object);
            l = lArray[i];
            break;
        }
        return ChartObjectInfoNative.jni_SetS57AttributeValue(this.getHandle(), l);
    }

    public Selection getSelection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    public GeoStyle[] getPointStyles() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointStyles()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = ChartObjectInfoNative.jni_GetPointStyles(this.getHandle());
        GeoStyle[] geoStyleArray = new GeoStyle[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geoStyleArray[i] = InternalGeoStyle.createInstance(lArray[i]);
        }
        return geoStyleArray;
    }

    public S57EdgeStyle[] getEdgesStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_s57EdgeStyles != null) {
            for (S57EdgeStyle object : this.m_s57EdgeStyles) {
                object.getStyle().dispose();
            }
            this.m_s57EdgeStyles = null;
        }
        if (this.m_s57EdgeStyles == null) {
            int n = ChartObjectInfoNative.jni_GetEdgeStyleCount(this.getHandle());
            this.m_s57EdgeStyles = new S57EdgeStyle[n];
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            boolean[] blArray = new boolean[n];
            ChartObjectInfoNative.jni_GetEdgesStyles(this.getHandle(), lArray, lArray2, blArray);
            for (int i = 0; i < n; ++i) {
                S57EdgeStyle s57EdgeStyle = new S57EdgeStyle();
                s57EdgeStyle.setEdgeID(lArray[i]);
                s57EdgeStyle.setVisible(blArray[i]);
                GeoStyle geoStyle = InternalGeoStyle.createInstance(lArray2[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle, true);
                s57EdgeStyle.setStyle(geoStyle);
                this.m_s57EdgeStyles[i] = s57EdgeStyle;
            }
        }
        return this.m_s57EdgeStyles;
    }

    public void setEdgesStyle(S57EdgeStyle[] s57EdgeStyleArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (s57EdgeStyleArray == null) {
            String string = InternalResource.loadString("getLineStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = s57EdgeStyleArray.length;
        if (n == 0) {
            return;
        }
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            S57EdgeStyle s57EdgeStyle = s57EdgeStyleArray[i];
            if (s57EdgeStyle == null) continue;
            lArray[i] = s57EdgeStyle.getEdgeID();
            blArray[i] = s57EdgeStyle.isVisible();
            lArray2[i] = s57EdgeStyleArray[i].getStyle() != null ? InternalHandle.getHandle((InternalHandle)s57EdgeStyleArray[i].getStyle()) : 0L;
        }
        ChartObjectInfoNative.jni_SetEdgesStyles(this.getHandle(), lArray, lArray2, blArray, n);
    }
}

