/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.SceneAddedEvent;
import com.supermap.data.SceneAddedListener;
import com.supermap.data.SceneClearedEvent;
import com.supermap.data.SceneClearedListener;
import com.supermap.data.SceneClearingEvent;
import com.supermap.data.SceneClearingListener;
import com.supermap.data.SceneRemovedEvent;
import com.supermap.data.SceneRemovedListener;
import com.supermap.data.SceneRemovingEvent;
import com.supermap.data.SceneRemovingListener;
import com.supermap.data.SceneRenamedEvent;
import com.supermap.data.SceneRenamedListener;
import com.supermap.data.SceneRenamingEvent;
import com.supermap.data.SceneRenamingListener;
import com.supermap.data.ScenesNative;
import com.supermap.data.Workspace;
import java.util.concurrent.CopyOnWriteArrayList;

public class Scenes {
    private Workspace _$1;
    transient CopyOnWriteArrayList<SceneAddedListener> m_sceneAddedListeners;
    transient CopyOnWriteArrayList<SceneRemovingListener> m_sceneRemovingListeners;
    transient CopyOnWriteArrayList<SceneRemovedListener> m_sceneRemovedListeners;
    transient CopyOnWriteArrayList<SceneClearingListener> m_sceneClearingListeners;
    transient CopyOnWriteArrayList<SceneClearedListener> m_sceneClearedListeners;
    transient CopyOnWriteArrayList<SceneRenamingListener> m_sceneRenamingListeners;
    transient CopyOnWriteArrayList<SceneRenamedListener> m_sceneRenamedListeners;

    Scenes(Workspace workspace) {
        this._$1 = workspace;
    }

    public String get(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScenesNative.jni_GetItem(this._$1.getHandle(), n);
    }

    public int getCount() {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ScenesNative.jni_GetCount(this._$1.getHandle());
    }

    public int add(String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string5 = InternalResource.loadString("name", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        int n = -1;
        n = ScenesNative.jni_Add(this._$1.getHandle(), string, string2);
        if (n > -1) {
            SceneAddedEvent sceneAddedEvent = new SceneAddedEvent(this, string);
            this.fireAdded(sceneAddedEvent);
        }
        return n;
    }

    public boolean insert(int n, String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (n < 0 || n > this.getCount()) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.indexOf(string) >= 0) {
            String string6 = InternalResource.loadString("name", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        return ScenesNative.jni_Insert(this._$1.getHandle(), n, string, string2);
    }

    public boolean setSceneXML(int n, String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n >= this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (string == null) {
            string = "";
        }
        return ScenesNative.jni_SetSceneXML(this._$1.getHandle(), n, string);
    }

    public boolean setSceneXML(String string, String string2) {
        int n;
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = this.indexOf(string)) == -1) {
            String string5 = InternalResource.loadString("name", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        return this.setSceneXML(n, string2);
    }

    public String getSceneXML(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScenesNative.jni_GetSceneXML(this._$1.getHandle(), n);
    }

    public String getSceneXML(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = this.indexOf(string);
        if (n == -1) {
            String string4 = InternalResource.loadString("name", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        return ScenesNative.jni_GetSceneXML(this._$1.getHandle(), n);
    }

    public boolean remove(int n) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(n);
        SceneRemovingEvent sceneRemovingEvent = new SceneRemovingEvent(this, string);
        this.fireRemoving(sceneRemovingEvent);
        if (sceneRemovingEvent.getCancel()) {
            return false;
        }
        boolean bl = false;
        bl = ScenesNative.jni_Remove(this._$1.getHandle(), n);
        if (bl) {
            SceneRemovedEvent sceneRemovedEvent = new SceneRemovedEvent(this, string);
            this.fireRemoved(sceneRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        int n = this.indexOf(string);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SceneClearingEvent sceneClearingEvent = new SceneClearingEvent(this);
        this.fireClearing(sceneClearingEvent);
        if (sceneClearingEvent.getCancel()) {
            return;
        }
        int n = this.getCount();
        ScenesNative.jni_Clear(this._$1.getHandle());
        SceneClearedEvent sceneClearedEvent = new SceneClearedEvent(this, n);
        this.fireCleared(sceneClearedEvent);
    }

    public int indexOf(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = ScenesNative.jni_IndexOf(this._$1.getHandle(), string);
        }
        return n;
    }

    public String getAvailableSceneName(String string) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        return ScenesNative.jni_GetAvailableSceneName(this._$1.getHandle(), string);
    }

    public boolean rename(String string, String string2) {
        if (this._$1 == null || this._$1.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.indexOf(string) == -1) {
            String string6 = InternalResource.loadString("oldName", "Scene_NameIsNotInScenes", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2.equalsIgnoreCase(string)) {
            return false;
        }
        if (this.indexOf(string2) >= 0) {
            String string7 = InternalResource.loadString("newName", "Scenes_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        SceneRenamingEvent sceneRenamingEvent = new SceneRenamingEvent(this, string, string2);
        this.fireRenaming(sceneRenamingEvent);
        if (sceneRenamingEvent.getCancel()) {
            return false;
        }
        boolean bl = false;
        bl = ScenesNative.jni_Rename(this._$1.getHandle(), string, string2);
        if (bl) {
            SceneRenamedEvent sceneRenamedEvent = new SceneRenamedEvent(this, string, string2);
            this.fireRenamed(sceneRenamedEvent);
        }
        return bl;
    }

    public synchronized void addAddedListener(SceneAddedListener sceneAddedListener) {
        if (this.m_sceneAddedListeners == null) {
            this.m_sceneAddedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneAddedListeners.contains(sceneAddedListener)) {
            this.m_sceneAddedListeners.add(sceneAddedListener);
        }
    }

    public void removeAddedListener(SceneAddedListener sceneAddedListener) {
        if (this.m_sceneAddedListeners != null && this.m_sceneAddedListeners.contains(sceneAddedListener)) {
            this.m_sceneAddedListeners.remove(sceneAddedListener);
        }
    }

    protected void fireAdded(SceneAddedEvent sceneAddedEvent) {
        if (this.m_sceneAddedListeners != null) {
            CopyOnWriteArrayList<SceneAddedListener> copyOnWriteArrayList = this.m_sceneAddedListeners;
            for (SceneAddedListener sceneAddedListener : copyOnWriteArrayList) {
                sceneAddedListener.sceneAdded(sceneAddedEvent);
            }
        }
    }

    public synchronized void addRemovingListener(SceneRemovingListener sceneRemovingListener) {
        if (this.m_sceneRemovingListeners == null) {
            this.m_sceneRemovingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRemovingListeners.contains(sceneRemovingListener)) {
            this.m_sceneRemovingListeners.add(sceneRemovingListener);
        }
    }

    public void removeRemovingListener(SceneRemovingListener sceneRemovingListener) {
        if (this.m_sceneRemovingListeners != null && this.m_sceneRemovingListeners.contains(sceneRemovingListener)) {
            this.m_sceneRemovingListeners.remove(sceneRemovingListener);
        }
    }

    protected void fireRemoving(SceneRemovingEvent sceneRemovingEvent) {
        if (this.m_sceneRemovingListeners != null) {
            CopyOnWriteArrayList<SceneRemovingListener> copyOnWriteArrayList = this.m_sceneRemovingListeners;
            for (SceneRemovingListener sceneRemovingListener : copyOnWriteArrayList) {
                sceneRemovingListener.sceneRemoving(sceneRemovingEvent);
            }
        }
    }

    public synchronized void addRemovedListener(SceneRemovedListener sceneRemovedListener) {
        if (this.m_sceneRemovedListeners == null) {
            this.m_sceneRemovedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRemovedListeners.contains(sceneRemovedListener)) {
            this.m_sceneRemovedListeners.add(sceneRemovedListener);
        }
    }

    public void removeRemovedListener(SceneRemovedListener sceneRemovedListener) {
        if (this.m_sceneRemovedListeners != null && this.m_sceneRemovedListeners.contains(sceneRemovedListener)) {
            this.m_sceneRemovedListeners.remove(sceneRemovedListener);
        }
    }

    protected void fireRemoved(SceneRemovedEvent sceneRemovedEvent) {
        if (this.m_sceneRemovedListeners != null) {
            CopyOnWriteArrayList<SceneRemovedListener> copyOnWriteArrayList = this.m_sceneRemovedListeners;
            for (SceneRemovedListener sceneRemovedListener : copyOnWriteArrayList) {
                sceneRemovedListener.sceneRemoved(sceneRemovedEvent);
            }
        }
    }

    public synchronized void addClearingListener(SceneClearingListener sceneClearingListener) {
        if (this.m_sceneClearingListeners == null) {
            this.m_sceneClearingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneClearingListeners.contains(sceneClearingListener)) {
            this.m_sceneClearingListeners.add(sceneClearingListener);
        }
    }

    public void removeClearingListener(SceneClearingListener sceneClearingListener) {
        if (this.m_sceneClearingListeners != null && this.m_sceneClearingListeners.contains(sceneClearingListener)) {
            this.m_sceneClearingListeners.remove(sceneClearingListener);
        }
    }

    protected void fireClearing(SceneClearingEvent sceneClearingEvent) {
        if (this.m_sceneClearingListeners != null) {
            CopyOnWriteArrayList<SceneClearingListener> copyOnWriteArrayList = this.m_sceneClearingListeners;
            for (SceneClearingListener sceneClearingListener : copyOnWriteArrayList) {
                sceneClearingListener.sceneClearing(sceneClearingEvent);
            }
        }
    }

    public synchronized void addClearedListener(SceneClearedListener sceneClearedListener) {
        if (this.m_sceneClearedListeners == null) {
            this.m_sceneClearedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneClearedListeners.contains(sceneClearedListener)) {
            this.m_sceneClearedListeners.add(sceneClearedListener);
        }
    }

    public void removeClearedListener(SceneClearedListener sceneClearedListener) {
        if (this.m_sceneClearedListeners != null && this.m_sceneClearedListeners.contains(sceneClearedListener)) {
            this.m_sceneClearedListeners.remove(sceneClearedListener);
        }
    }

    protected void fireCleared(SceneClearedEvent sceneClearedEvent) {
        if (this.m_sceneClearedListeners != null) {
            CopyOnWriteArrayList<SceneClearedListener> copyOnWriteArrayList = this.m_sceneClearedListeners;
            for (SceneClearedListener sceneClearedListener : copyOnWriteArrayList) {
                sceneClearedListener.sceneCleared(sceneClearedEvent);
            }
        }
    }

    public synchronized void addRenamingListener(SceneRenamingListener sceneRenamingListener) {
        if (this.m_sceneRenamingListeners == null) {
            this.m_sceneRenamingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRenamingListeners.contains(sceneRenamingListener)) {
            this.m_sceneRenamingListeners.add(sceneRenamingListener);
        }
    }

    public void removeRenamingListener(SceneRenamingListener sceneRenamingListener) {
        if (this.m_sceneRenamingListeners != null && this.m_sceneRenamingListeners.contains(sceneRenamingListener)) {
            this.m_sceneRenamingListeners.remove(sceneRenamingListener);
        }
    }

    protected void fireRenaming(SceneRenamingEvent sceneRenamingEvent) {
        if (this.m_sceneRenamingListeners != null) {
            CopyOnWriteArrayList<SceneRenamingListener> copyOnWriteArrayList = this.m_sceneRenamingListeners;
            for (SceneRenamingListener sceneRenamingListener : copyOnWriteArrayList) {
                sceneRenamingListener.sceneRenaming(sceneRenamingEvent);
            }
        }
    }

    public synchronized void addRenamedListener(SceneRenamedListener sceneRenamedListener) {
        if (this.m_sceneRenamedListeners == null) {
            this.m_sceneRenamedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_sceneRenamedListeners.contains(sceneRenamedListener)) {
            this.m_sceneRenamedListeners.add(sceneRenamedListener);
        }
    }

    public void removeRenamedListener(SceneRenamedListener sceneRenamedListener) {
        if (this.m_sceneRenamedListeners != null && this.m_sceneRenamedListeners.contains(sceneRenamedListener)) {
            this.m_sceneRenamedListeners.remove(sceneRenamedListener);
        }
    }

    protected void fireRenamed(SceneRenamedEvent sceneRenamedEvent) {
        if (this.m_sceneRenamedListeners != null) {
            CopyOnWriteArrayList<SceneRenamedListener> copyOnWriteArrayList = this.m_sceneRenamedListeners;
            for (SceneRenamedListener sceneRenamedListener : copyOnWriteArrayList) {
                sceneRenamedListener.sceneRenamed(sceneRenamedEvent);
            }
        }
    }

    protected void clearHandle() {
        this._$1 = null;
    }
}

