/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoTextNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.TextPart;
import com.supermap.data.TextStyle;
import java.util.ArrayList;

public class GeoText
extends Geometry {
    private ArrayList _$6 = null;
    private TextStyle _$5 = null;

    public GeoText() {
        long l = GeoTextNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this._$6 = new ArrayList();
    }

    public GeoText(GeoText geoText) {
        if (geoText == null) {
            String string = InternalResource.loadString("geoText", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoText.getHandle() == 0L) {
            String string = InternalResource.loadString("geoText", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_Clone(geoText.getHandle());
        this.setHandle(l, true);
        this._$6 = new ArrayList();
        int n = geoText.getTextPartsList().size();
        for (int i = 0; i < n; ++i) {
            TextPart textPart = new TextPart(this, i);
            this._$6.add(textPart);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoText);
    }

    public GeoText(TextPart textPart) {
        if (textPart == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this._$6 = new ArrayList();
        this.addPart(textPart);
        InternalHandleDisposable.makeSureNativeObjectLive(textPart);
    }

    public GeoText(TextPart textPart, TextStyle textStyle) {
        if (textPart == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoTextNative.jni_New();
        this.setHandle(l, true);
        this._$6 = new ArrayList();
        this.addPart(textPart);
        this.setTextStyle(textStyle);
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle);
    }

    GeoText(long l) {
        this.setHandle(l, false);
        this._$6 = new ArrayList();
        this._$1();
    }

    protected static GeoText creatInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoText(l);
    }

    public String getText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetContent(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetPartCount(this.getHandle());
    }

    public TextStyle getTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = GeoTextNative.jni_GetTextStyle(this.getHandle())) != 0L) {
            this._$5 = TextStyle.createInstance(l);
        }
        return this._$5;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = InternalResource.loadString("textStyle", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        GeoTextNative.jni_SetTextStyle(this.getHandle(), textStyle2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(textStyle2);
    }

    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetPartCount(this.getHandle()) == 0;
    }

    public int addPart(TextPart textPart) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textPart == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = GeoTextNative.jni_AddPart(this.getHandle(), textPart.getHandle(), textPart.getX(), textPart.getY());
        TextPart textPart2 = new TextPart(this, n);
        this._$6.add(textPart2);
        InternalHandleDisposable.makeSureNativeObjectLive(textPart);
        return n;
    }

    public TextPart getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        TextPart textPart = (TextPart)this._$6.get(n);
        return textPart;
    }

    public boolean insertPart(int n, TextPart textPart) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textPart == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = GeoTextNative.jni_InsertPart(this.getHandle(), n, textPart.getHandle(), textPart.getX(), textPart.getY());
        if (bl) {
            TextPart textPart2 = new TextPart(this, n);
            this._$6.add(n, textPart2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(textPart);
        return bl;
    }

    public int indexOf(TextPart textPart) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textPart == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this._$6.indexOf(textPart);
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoTextNative.jni_RemovePart(this.getHandle(), n);
        if (bl) {
            this._$6.remove(n);
        }
        return bl;
    }

    public boolean setPart(int n, TextPart textPart) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textPart == null) {
            String string = InternalResource.loadString("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = InternalResource.loadString("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeoTextNative.jni_SetPart(this.getHandle(), n, textPart.getHandle(), textPart.getX(), textPart.getY());
        if (bl) {
            TextPart textPart2 = new TextPart(this, n);
            this._$6.set(n, textPart2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(textPart);
        return bl;
    }

    public static GeoText makeAlongLineText(String string, GeoLine geoLine) {
        if (geoLine.getHandle() == 0L) {
            String string2 = InternalResource.loadString("line", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("text", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        GeoText geoText = new GeoText();
        boolean bl = GeoTextNative.jni_MakeAlongLineText(geoText.getHandle(), string, geoLine.getHandle(), false, 0.0);
        if (bl) {
            geoText._$1();
            InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
            return geoText;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
        return null;
    }

    public static GeoText makeAlongLineText(String string, GeoLine geoLine, double d) {
        if (geoLine.getHandle() == 0L) {
            String string2 = InternalResource.loadString("line", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("text", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        GeoText geoText = new GeoText();
        boolean bl = GeoTextNative.jni_MakeAlongLineText(geoText.getHandle(), string, geoLine.getHandle(), true, d);
        if (bl) {
            geoText._$1();
            InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
            return geoText;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
        return null;
    }

    public GeoText clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoText(this);
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoTextNative.jni_Clear(this.getHandle());
        this._$6.clear();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoTextNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public boolean fromXML(String string) {
        boolean bl = super.fromXML(string);
        if (bl) {
            this._$1();
        }
        return bl;
    }

    protected void clearHandle() {
        super.clearHandle();
        if (this._$6 != null) {
            this._$6.clear();
            this._$6 = null;
        }
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
    }

    ArrayList getTextPartsList() {
        return this._$6;
    }

    void reset() {
        this.getTextStyle().reset();
    }

    private void _$1() {
        this._$6.clear();
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            TextPart textPart = new TextPart(this, i);
            this._$6.add(textPart);
        }
    }
}

