/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoParametricRegion;
import com.supermap.data.GeoParametricRegionCompoundNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoParametricRegionCompound
extends GeoParametricRegion {
    private ArrayList<Geometry> _$6;

    public GeoParametricRegionCompound() {
        super(0L);
        long l = GeoParametricRegionCompoundNative.jni_New();
        this.setHandle(l, true);
        this._$6 = new ArrayList();
    }

    GeoParametricRegionCompound(long l) {
        super(0L);
        this.setHandle(l, false);
        this._$6 = new ArrayList();
        GeoParametricRegionCompound.refreshFromUGC1(this);
    }

    public GeoParametricRegionCompound(GeoParametricRegionCompound geoParametricRegionCompound) {
        if (geoParametricRegionCompound == null) {
            String string = InternalResource.loadString("GeoParametricRegionCompound", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoParametricRegionCompound);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoParametricRegionCompound", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoParametricRegionCompoundNative.jni_Clone(l);
        this._$6 = new ArrayList();
        this.setHandle(l2, true);
        GeoParametricRegionCompound.refreshFromUGC1(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoParametricRegionCompound);
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricRegionCompoundNative.jni_getPerimeter(this.getHandle());
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricRegionCompoundNative.jni_getArea(this.getHandle());
    }

    public int add(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoParametricRegionCompoundNative.jni_add(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this._$6.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this._$6.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSubCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricRegionCompoundNative.jni_getCount(this.getHandle());
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemoveSub(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$6.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        bl = GeoParametricRegionCompoundNative.jni_remove(this.getHandle(), n);
        if (bl) {
            this._$6.get(n).clearHandle();
            InternalHandleDisposable.setIsDisposable(this._$6.get(n), true);
            this._$6.remove(n);
        }
        return bl;
    }

    public Geometry get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$6.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$6.get(n);
    }

    public boolean insert(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("InsertSub(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this._$6.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoParametricRegionCompoundNative.jni_insert(this.getHandle(), n, geometry2.getHandle());
        if (bl) {
            this._$6.add(n, geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean set(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSub(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this._$6.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoParametricRegionCompoundNative.jni_set(this.getHandle(), n, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this._$6.get(n);
            geometry3.clearHandle();
            this._$6.remove(n);
            this._$6.add(n, geometry2);
            geometry2.setIsDisposable(false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public GeoParametricRegionCompound clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoParametricRegionCompound(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoParametricRegionCompoundNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getCount() == 0;
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricRegionCompoundNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this._$6.size(); ++i) {
            this._$6.get(i).setIsDisposable(true);
            this._$6.get(i).setHandle(0L);
            this._$6.get(i).clearHandle();
        }
        this._$6.clear();
    }

    static void refreshFromUGC1(GeoParametricRegionCompound geoParametricRegionCompound) {
        int n = geoParametricRegionCompound.getCount();
        long[] lArray = new long[n];
        GeoParametricRegionCompoundNative.jni_AllGeometrys(geoParametricRegionCompound.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoParametricRegionCompound._$6.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoParametricRegionCompound);
    }

    void refrashPartsList() {
        for (int i = 0; i < this._$6.size(); ++i) {
            Geometry geometry;
            if (this._$6.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this._$6.get(i);
                ((GeoRegion)geometry).refrashPartsList();
            }
            if (!(this._$6.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this._$6.get(i);
            ((GeoLine)geometry).refrashPartsList();
        }
    }

    protected static GeoParametricRegionCompound creatInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoParametricRegionCompound(l);
    }
}

