/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.EditHistoryNative;
import com.supermap.data.EditType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Recordset;

public class EditHistory
extends InternalHandleDisposable {
    private boolean _$3 = false;

    public EditHistory() {
        this.setHandle(EditHistoryNative.jni_New(), true);
    }

    EditHistory(long l) {
        this.setHandle(l, false);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCount(this.getHandle());
    }

    public void setCapacity(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCapacity(int maxCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("maxCount", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new NullPointerException(string);
        }
        EditHistoryNative.jni_SetMaxCount(this.getHandle(), n);
    }

    public int getCapacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCapacity()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetMaxCount(this.getHandle());
    }

    public int getCurrentIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentIndex()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCurrentIndex(this.getHandle());
    }

    public boolean getCanRedo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCanRedo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCanRedo(this.getHandle());
    }

    public boolean getCanUndo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCanUndo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_GetCanUndo(this.getHandle());
    }

    public boolean add(EditType editType, Recordset recordset, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(EditType editType, Recordset recordset, boolean isCurrentOnly)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (editType == null) {
            String string = InternalResource.loadString("editType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = recordset.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = editType.getUGCValue();
        boolean bl2 = false;
        bl2 = !this._$3 ? EditHistoryNative.jni_Add(this.getHandle(), n, l, bl) : EditHistoryNative.jni_Add2(this.getHandle(), n, l, bl);
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
        return bl2;
    }

    public boolean undo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("undo()", "BatchAddOperation_Unsupport_Undo", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_Undo(this.getHandle());
    }

    public boolean undo(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("undo(int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("undo(int count)", "BatchAddOperation_Unsupport_Undo", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("count", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_UndoCount(this.getHandle(), n);
    }

    public boolean redo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("redo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("redo()", "BatchAddOperation_Unsupport_Redo", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_Redo(this.getHandle());
    }

    public boolean redo(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("redo(int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("redo(int count)", "BatchAddOperation_Unsupport_Redo", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("count", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_RedoCount(this.getHandle(), n);
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount() - 1) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return EditHistoryNative.jni_Remove(this.getHandle(), n);
    }

    public boolean removeRange(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount() - 1 || n2 < 0 || n + n2 > this.getCount()) {
            String string = InternalResource.loadString("removeRange(int index, int count)", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 == 0) {
            return true;
        }
        return EditHistoryNative.jni_RemoveRange(this.getHandle(), n, n2);
    }

    public boolean clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return EditHistoryNative.jni_RemoveRange(this.getHandle(), 0, this.getCount());
    }

    public void batchBegin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("batchBegin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("batchBegin()", "BatchHasBegun", "data_resources");
            throw new IllegalStateException(string);
        }
        this._$3 = EditHistoryNative.jni_BatchBegin(this.getHandle());
    }

    public void batchEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("batchEnd()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        EditHistoryNative.jni_BatchEnd(this.getHandle());
        this._$3 = false;
    }

    public void batchCancel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("batchCancel()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        EditHistoryNative.jni_BatchCancel(this.getHandle());
        this._$3 = false;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            EditHistoryNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected static EditHistory createInstance(long l) {
        return new EditHistory(l);
    }
}

