/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.executeengine.model;

import bexee.model.BPELDocumentException;
import bexee.model.process.BPELProcess;
import bexee.model.process.impl.BPELProcessImpl;
import bexee.util.BexeeProperties;
import com.supermap.geoprocessor.executeengine.model.GeoBPELProcessFactoryImpl;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GeoBPELProcessFactory {
    private static Log log = LogFactory.getLog(GeoBPELProcessFactory.class);

    public BPELProcess createBPELProcess(InputStream inputStream) throws BPELDocumentException {
        return null;
    }

    public static GeoBPELProcessFactoryImpl getInstance() {
        GeoBPELProcessFactoryImpl geoBPELProcessFactoryImpl = null;
        String string = BexeeProperties.getProperty((String)"bexee.process.factory");
        if (string == null) {
            log.debug((Object)("bexee.dao.factory not set, creating default factory: " + BPELProcessImpl.class.getName()));
            geoBPELProcessFactoryImpl = new GeoBPELProcessFactoryImpl();
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                geoBPELProcessFactoryImpl = (GeoBPELProcessFactoryImpl)((Object)clazz.newInstance());
            }
            catch (Exception exception) {
                log.warn((Object)("unable to create " + string + ", creating default factory: " + BPELProcessImpl.class.getName()));
                geoBPELProcessFactoryImpl = new GeoBPELProcessFactoryImpl();
            }
        }
        return geoBPELProcessFactoryImpl;
    }
}

