/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCompoundNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import java.util.ArrayList;

public class GeoCompound
extends Geometry {
    private ArrayList<Geometry> _$5;

    public GeoCompound() {
        long l = GeoCompoundNative.jni_New();
        this.setHandle(l, true);
        this._$5 = new ArrayList();
    }

    GeoCompound(long l) {
        this.setHandle(l, false);
        this._$5 = new ArrayList();
        GeoCompound.refreshFromUGC1(this);
    }

    public GeoCompound(GeoCompound geoCompound) {
        if (geoCompound == null) {
            String string = InternalResource.loadString("geoCompound", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoCompound);
        if (l == 0L) {
            String string = InternalResource.loadString("geoCompound", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCompoundNative.jni_Clone(l);
        this._$5 = new ArrayList();
        this.setHandle(l2, true);
        GeoCompound.refreshFromUGC1(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoCompound);
    }

    public int addPart(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoCompoundNative.jni_addPart(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this._$5.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this._$5.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n;
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCompoundNative.jni_getPartCount(this.getHandle());
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemovePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$5.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        bl = GeoCompoundNative.jni_removePart(this.getHandle(), n);
        if (bl) {
            this._$5.get(n).clearHandle();
            InternalHandleDisposable.setIsDisposable(this._$5.get(n), true);
            this._$5.remove(n);
        }
        return bl;
    }

    public Geometry getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$5.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$5.get(n);
    }

    public boolean insertPart(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("InsertPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this._$5.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoCompoundNative.jni_insertPart(this.getHandle(), n, geometry2.getHandle());
        if (bl) {
            this._$5.add(n, geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean setPart(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this._$5.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoCompoundNative.jni_setPart(this.getHandle(), n, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this._$5.get(n);
            geometry3.clearHandle();
            this._$5.remove(n);
            this._$5.add(n, geometry2);
            geometry2.setIsDisposable(false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public void adjust(boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Adjust(boolean isMinGeometryMovedUp)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCompoundNative.jni_adjust(this.getHandle(), bl);
        int n2 = this.getPartCount();
        long[] lArray = new long[n2];
        GeoCompoundNative.jni_AllSubGeometrys(this.getHandle(), lArray);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (n = 0; n < this._$5.size(); ++n) {
            arrayList.add(this._$5.get(n));
        }
        this._$5.clear();
        block1: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (((Geometry)arrayList.get(i)).getHandle() != lArray[n]) continue;
                this._$5.add((Geometry)arrayList.get(i));
                arrayList.remove(i);
                continue block1;
            }
        }
    }

    public Geometry[] divide(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Divide(boolean isTopOnly)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeoCompoundNative.jni_divide(this.getHandle(), bl);
        int n = lArray.length;
        Geometry[] geometryArray = new Geometry[n];
        for (int i = 0; i < n; ++i) {
            geometryArray[i] = Geometry.createInstance(lArray[i]);
        }
        return geometryArray;
    }

    public GeoCompound clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCompound(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCompoundNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    public void rotate(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(point2D, d);
        this.refrashPartsList();
    }

    public Geometry mirror(Point2D point2D, Point2D point2D2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCompound geoCompound = (GeoCompound)super.mirror(point2D, point2D2);
        this.refrashPartsList();
        return geoCompound;
    }

    public void offset(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(d, d2);
        this.refrashPartsList();
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCompoundNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this._$5.size(); ++i) {
            this._$5.get(i).setIsDisposable(true);
            this._$5.get(i).setHandle(0L);
            this._$5.get(i).clearHandle();
        }
        this._$5.clear();
    }

    static void refreshFromUGC1(GeoCompound geoCompound) {
        int n = geoCompound.getPartCount();
        long[] lArray = new long[n];
        GeoCompoundNative.jni_AllSubGeometrys(geoCompound.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoCompound._$5.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoCompound);
    }

    void refrashPartsList() {
        for (int i = 0; i < this._$5.size(); ++i) {
            Geometry geometry;
            if (this._$5.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this._$5.get(i);
                ((GeoRegion)geometry).refrashPartsList();
            }
            if (!(this._$5.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this._$5.get(i);
            ((GeoLine)geometry).refrashPartsList();
        }
    }

    protected static GeoCompound creatInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoCompound(l);
    }
}

