/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingDGNNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;
import java.io.File;

public class ImportSettingDGN
extends ImportSetting {
    public ImportSettingDGN() {
        long l = ImportSettingDGNNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingDGN(ImportSettingDGN importSettingDGN) {
        if (importSettingDGN == null) {
            String string = InternalResource.loadString("ImportSettingDGN", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingDGN);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingDGN", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingDGNNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingDGN.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingDGN.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingDGN.getTargetPrjCoordSys());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingDGN));
    }

    public ImportSettingDGN(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public ImportSettingDGN(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingDGN(String string, Datasource datasource, boolean bl) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
        this.setImportingAsCAD(bl);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingDGN(String string, DatasourceConnectionInfo datasourceConnectionInfo, boolean bl) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        this.setImportingAsCAD(bl);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportingAsCAD(this.getHandle(), bl);
    }

    public boolean isImportingCellAsPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingSymbolBlockAsPoint()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportingCellAsPoint(this.getHandle());
    }

    public void setImportingCellAsPoint(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingSymbolBlockAsPoint(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportingCellAsPoint(this.getHandle(), bl);
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ImportSettingDGNNative.jni_GetSpatialIndex(this.getHandle());
        return InternalSpatialIndexInfo.createInstance(l);
    }

    public void setSpatialIndex(SpatialIndexInfo spatialIndexInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndexType value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetSpatialIndex(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)spatialIndexInfo));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)spatialIndexInfo);
    }

    public boolean isImportingByLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingByLayer()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportingByLayer(this.getHandle());
    }

    public void setImportingByLayer(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingByLayer(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportingByLayer(this.getHandle(), bl);
    }

    public String getStyleMappingTableFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyleMapFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingDGNNative.jni_GetStyleMapFilePath(this.getHandle());
    }

    public void setStyleMappingTableFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setStyleMapFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string4);
        }
        ImportSettingDGNNative.jni_SetStyleMapFilePath(this.getHandle(), file.getPath());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingDGNNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportEmptyDT(this.getHandle(), bl);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

