/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import net.sf.sojo.core.reflect.AccessiblePrivilegedAction;

public final class StackTraceElementWrapper
implements Serializable {
    private static final long serialVersionUID = 6249331607491652074L;
    private String className = null;
    private String methodName = null;
    private String fileName = null;
    private int lineNumber = -1;
    private boolean nativeMethod = false;

    public StackTraceElementWrapper() {
    }

    public StackTraceElementWrapper(StackTraceElement pvStackTraceElement) {
        this.setClassName(pvStackTraceElement.getClassName());
        this.setMethodName(pvStackTraceElement.getMethodName());
        this.setFileName(pvStackTraceElement.getFileName());
        this.setLineNumber(pvStackTraceElement.getLineNumber());
        this.setNativeMethod(pvStackTraceElement.isNativeMethod());
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String pvClassName) {
        this.className = pvClassName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String pvFileName) {
        this.fileName = pvFileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int pvLineNumber) {
        this.lineNumber = pvLineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String pvMethodName) {
        this.methodName = pvMethodName;
    }

    public boolean isNativeMethod() {
        return this.nativeMethod;
    }

    public void setNativeMethod(boolean pvNativeMethod) {
        this.nativeMethod = pvNativeMethod;
    }

    public boolean getNativeMethod() {
        return this.nativeMethod;
    }

    public String toString() {
        return this.getClassName() + "." + this.getMethodName() + " (" + this.getFileName() + ":" + this.getLineNumber() + ")";
    }

    private StackTraceElement tryToCreateStackTraceElementInstanceIntern() {
        StackTraceElement lvStackTraceElement = null;
        try {
            Constructor lvConstructor = StackTraceElement.class.getDeclaredConstructor(new Class[0]);
            AccessController.doPrivileged(new AccessiblePrivilegedAction(lvConstructor));
            lvStackTraceElement = (StackTraceElement)lvConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            try {
                Constructor<?> lvConstructor = StackTraceElement.class.getDeclaredConstructors()[0];
                AccessController.doPrivileged(new AccessiblePrivilegedAction(lvConstructor));
                lvStackTraceElement = (StackTraceElement)lvConstructor.newInstance(this.getClassName(), this.getMethodName(), this.getFileName(), new Integer(this.getLineNumber()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return lvStackTraceElement;
    }

    public StackTraceElement tryToCreateStackTraceElement() {
        StackTraceElement lvStackTraceElement = null;
        try {
            lvStackTraceElement = this.tryToCreateStackTraceElementInstanceIntern();
            Field lvField = StackTraceElement.class.getDeclaredField("declaringClass");
            AccessController.doPrivileged(new AccessiblePrivilegedAction(lvField));
            lvField.set(lvStackTraceElement, this.getClassName());
            lvField = StackTraceElement.class.getDeclaredField("methodName");
            AccessController.doPrivileged(new AccessiblePrivilegedAction(lvField));
            lvField.set(lvStackTraceElement, this.getMethodName());
            lvField = StackTraceElement.class.getDeclaredField("fileName");
            AccessController.doPrivileged(new AccessiblePrivilegedAction(lvField));
            lvField.set(lvStackTraceElement, this.getFileName());
            lvField = StackTraceElement.class.getDeclaredField("lineNumber");
            AccessController.doPrivileged(new AccessiblePrivilegedAction(lvField));
            lvField.set(lvStackTraceElement, new Integer(this.getLineNumber()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lvStackTraceElement;
    }
}

