/*
 * Decompiled with CFR 0.152.
 */
package com.github.inspektr.error.web;

import com.github.inspektr.error.ErrorLogManager;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.web.filter.OncePerRequestFilter;

public class ErrorLoggingFilter
extends OncePerRequestFilter {
    @NotNull
    private ErrorLogManager errorLogManager;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            this.errorLogManager.recordError((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.errorLogManager.recordError((Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            this.errorLogManager.recordError(t);
            throw new ServletException(t);
        }
    }

    public void setErrorLogManager(ErrorLogManager errorlogManager) {
        this.errorLogManager = errorlogManager;
    }
}

